/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import javax.xml.stream.XMLStreamException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongVarchar;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.Datum;
import oracle.xdb.XMLType;

public class XMLDatum
extends LongVarchar {
    public XMLDatum() {
    }

    protected XMLDatum(XMLDatum source) {
        super(source);
    }

    protected XMLDatum(Object object) {
        super(object);
    }

    public XMLDatum(XMLType value) throws SQLException {
        super(value);
    }

    public XMLDatum(CharSequence value) {
        super(value);
    }

    public XMLDatum(File value) {
        super(value);
    }

    public XMLDatum(Reader reader) throws IOException {
        new XMLDatum();
        this(XMLDatum.getBuilder().write(reader).build());
    }

    public XMLDatum(Reader reader, int cutOverLen) throws IOException {
        new XMLDatum();
        this(XMLDatum.getBuilder(cutOverLen).write(reader).build());
    }

    public static XMLDatum constructFrom(Object value) throws IOException, SQLException {
        if (value instanceof XMLType) {
            return new XMLDatum((XMLType)value);
        }
        if (value instanceof char[]) {
            return new XMLDatum(String.valueOf((char[])value));
        }
        if (value instanceof CharSequence) {
            return new XMLDatum((CharSequence)value);
        }
        if (value instanceof File) {
            return new XMLDatum((File)value);
        }
        if (value instanceof Reader) {
            return new XMLDatum((Reader)value);
        }
        if (value instanceof Datum) {
            Datum datumValue = (Datum)value;
            return new XMLDatum(datumValue.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof XMLType) {
            XMLType xmlType = (XMLType)this.getValue();
            return xmlType.getLength();
        }
        return super.getLength();
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof XMLDatum) {
            isEqual = super.equals(obj);
        }
        return isEqual;
    }

    @Override
    public Reader getReader() throws IOException, SQLException {
        if (this.getValue() instanceof XMLType) {
            XMLType xmlType = (XMLType)this.getValue();
            try {
                return DataTypesUtil.getXMLAsReader(xmlType.getInputStream(), "UTF-8");
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        return super.getReader();
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        Object value = this.getValue();
        switch (valueType) {
            case DATUM: {
                if (value instanceof XMLType) {
                    return value;
                }
                try {
                    XMLType tempXMLType = XMLType.createXML(connectionProvider.getValidDataTypeConnection(), (InputStream)DataTypesUtil.getXMLAsBytes(this.getReader()));
                    return tempXMLType;
                }
                catch (XMLStreamException | DataTypeConnectionException e) {
                    throw new IOException(e);
                }
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    public static XMLDatumBuilder getBuilder() {
        return XMLDatum.getBuilder(32768);
    }

    private XMLDatumBuilder getBuilder0(int cutOverLen) {
        return new XMLDatumBuilder(cutOverLen);
    }

    public static XMLDatumBuilder getBuilder(int cutOverLen) {
        return new XMLDatum().getBuilder0(cutOverLen);
    }

    protected static void close(XMLType xmlType) throws SQLException {
        xmlType.close();
    }

    protected static void free(XMLType xmlType) throws SQLException {
        xmlType.free();
    }

    public class XMLDatumBuilder
    extends LongVarchar.LongVarcharBuilder {
        protected XMLDatumBuilder(int cutOverLen) {
            super(cutOverLen);
        }

        @Override
        public XMLDatumBuilder write(Reader reader) throws IOException {
            return (XMLDatumBuilder)super.write(reader);
        }

        @Override
        public XMLDatum build() throws IOException {
            super.build();
            return XMLDatum.this;
        }
    }
}

