/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.naming.OperationNotSupportedException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;

public abstract class RaptorTask<V>
implements Callable<V> {
    private boolean _isPausable = false;
    private boolean _isCancelable = true;
    private IRaptorTaskStatus _requestedStatus = null;
    private Object _pauseLock = new Object();
    private Object _waitLock = new Object();
    private List<String> _tasksToWait4 = new ArrayList<String>();
    private RaptorTaskDescriptor _raptorTaskDescriptor;
    private Future<V> _future = null;
    private boolean _outcomeSet;
    private IRaptorTaskProgressUpdater _updater = new TaskProgressUpdater();

    public RaptorTask(String name) {
        this._raptorTaskDescriptor = new RaptorTaskDescriptor(name);
    }

    public RaptorTask(String name, boolean isInDeterminate) {
        this._raptorTaskDescriptor = new RaptorTaskDescriptor(name, isInDeterminate);
    }

    public RaptorTask(String name, boolean isInDeterminate, IRaptorTaskRunMode mode) {
        this._raptorTaskDescriptor = new RaptorTaskDescriptor(name, isInDeterminate, mode);
    }

    public String toString() {
        return this._raptorTaskDescriptor.getName() + "_" + this.hashCode();
    }

    public final boolean requestCancel() {
        if (!this.isCancellable()) {
            return false;
        }
        this._requestedStatus = IRaptorTaskStatus.FINISHED;
        this.setMessage(Messages.getString("RaptorTask.3"));
        boolean cancelled = this.cancel();
        if (cancelled) {
            this.setMessage(Messages.getString("RaptorTask.0"));
        } else {
            this.setMessage(Messages.getString("RaptorTask.5"));
        }
        return cancelled;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isCancellable() {
        return this._isCancelable;
    }

    public void setCancellable(boolean cancellable) {
        this._isCancelable = cancellable;
    }

    protected boolean isPausable() {
        return this._isPausable;
    }

    public void setPausable(boolean pausable) {
        this._isPausable = pausable;
    }

    public final void requestPause() {
        if (!this.isPausable()) {
            return;
        }
        this._requestedStatus = IRaptorTaskStatus.PAUSED;
        this.setMessage(Messages.getString("RaptorTask.6"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V call() throws Exception {
        this.setStatus(IRaptorTaskStatus.RUNNABLE);
        V returnObj = null;
        try {
            returnObj = this.doWork();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.tearDown();
        }
        RaptorTask raptorTask = this;
        synchronized (raptorTask) {
            this.notify();
        }
        return returnObj;
    }

    protected void tearDown() {
    }

    protected abstract V doWork() throws TaskException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this._pauseLock;
        synchronized (object) {
            this._requestedStatus = IRaptorTaskStatus.RUNNABLE;
            this._pauseLock.notify();
        }
    }

    public final IRaptorTaskStatus getStatus() {
        return this._raptorTaskDescriptor.getStatus();
    }

    public final RaptorTaskDescriptor getDescriptor() {
        return this._raptorTaskDescriptor;
    }

    void setStatus(IRaptorTaskStatus status) {
        this.getDescriptor().setStatus(status);
    }

    public void setMessage(String message) {
        this.getDescriptor().setMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        Object object = this._pauseLock;
        synchronized (object) {
            try {
                this._raptorTaskDescriptor.setStatus(IRaptorTaskStatus.PAUSED);
                String oldMessage = this.getDescriptor().getMessage();
                this.setMessage(Messages.getString("RaptorTask.8"));
                this._pauseLock.wait();
                this.setMessage(oldMessage);
                this._raptorTaskDescriptor.setStatus(IRaptorTaskStatus.RUNNABLE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public List<String> getTasksToWait4() {
        return this._tasksToWait4;
    }

    protected void wait4(List<String> tasksNames) {
        String oldMessage = this.getDescriptor().getMessage();
        IRaptorTaskStatus oldStatus = this.getStatus();
        this._raptorTaskDescriptor.setStatus(IRaptorTaskStatus.WAITING);
        this.setMessage(Messages.getString("RaptorTask.10"));
        this._tasksToWait4.addAll(tasksNames);
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        List<RaptorTask<?>> tasks = raptorTaskManager.getTasksForNames(tasksNames);
        tasks.removeIf(t -> t.toString().equals(this.toString()));
        raptorTaskManager.wait4Tasks(tasks, this._waitLock);
        this.setMessage(oldMessage);
        this._raptorTaskDescriptor.setStatus(oldStatus);
    }

    protected void checkCanProceed() throws ExecutionException {
        if (this._requestedStatus != null && this._requestedStatus != this._raptorTaskDescriptor.getStatus()) {
            switch (this._requestedStatus) {
                case PAUSED: {
                    this.pause();
                    break;
                }
                case FINISHED: {
                    this.getDescriptor().setCancelled(true);
                    throw new ExecutionException(new CancellationException(Messages.getString("RaptorTask.0")));
                }
            }
        }
    }

    void setFuture(Future<V> f) {
        this._future = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getResult() throws InterruptedException, ExecutionException {
        if (this._outcomeSet) {
            throw new ExecutionException(new OperationNotSupportedException("Can only call getResult once."));
        }
        while (this._future == null && this.getStatus() == IRaptorTaskStatus.NEW) {
            RaptorTask raptorTask = this;
            synchronized (raptorTask) {
                this.wait(1000L);
            }
        }
        if (this._future == null) {
            throw new ExecutionException(Messages.getString("RaptorTask.10"), new NullPointerException());
        }
        try {
            V _outcome = this._future.get();
            this._outcomeSet = true;
            this._future = null;
            return _outcome;
        }
        catch (CancellationException ce) {
            throw new ExecutionException(ce);
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    public IRaptorTaskProgressUpdater getRaptorTaskProgressUpdater() {
        return this._updater;
    }

    protected boolean mayInterrupt() {
        return false;
    }

    private final class TaskProgressUpdater
    implements IRaptorTaskProgressUpdater {
        private TaskProgressUpdater() {
        }

        @Override
        public void checkCanProceed() throws ExecutionException {
            RaptorTask.this.checkCanProceed();
        }

        @Override
        public RaptorTaskDescriptor getDescriptor() {
            return RaptorTask.this.getDescriptor();
        }

        @Override
        public boolean isCancellable() {
            return RaptorTask.this.isCancellable();
        }

        @Override
        public boolean isPausable() {
            return RaptorTask.this.isPausable();
        }
    }
}

