/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.lsp.LSP;

public class WebSocket {
    public static Logger LOG = Logger.getLogger("main");
    public static final String secKey = "Sec-WebSocket-Key";
    public static final String ping = "ping";
    public static final String pong = "pong";
    public static final String ignore = "ignore";
    public static final String ignoreAndPause = "ignorignoreAndPause";
    public static final String closeFrame = "closeFrame";
    byte[] first2 = new byte[2];
    byte[] key = null;

    public String unframe(InputStream client) {
        try {
            byte[] encoded;
            byte[] first2 = new byte[2];
            int read = client.read(first2, 0, 2);
            if (read == -1) {
                return ignoreAndPause;
            }
            if (read == 0) {
                return ignoreAndPause;
            }
            if (read != 2) {
                throw new AssertionError((Object)("2 != " + read));
            }
            int zeroth = first2[0] & 0xFF;
            int FIN = zeroth >> 7;
            int opcode = zeroth & 0xF;
            int first = first2[1] & 0xFF;
            int maskBit = first >> 7;
            int dataLength = first & 0x7F;
            System.out.println("FIN=" + FIN + ", opcode=" + opcode + ", maskBit=" + maskBit + ", dataLength=" + dataLength);
            if (opcode == 9) {
                return pong;
            }
            if (opcode == 10) {
                return ignore;
            }
            int indexFirstMask = 2;
            if (dataLength == 126) {
                indexFirstMask = 4;
            } else if (dataLength == 127) {
                indexFirstMask = 10;
            }
            byte[] second = new byte[indexFirstMask - 2];
            if (2 < indexFirstMask && (read = client.read(second, 0, indexFirstMask - 2)) != indexFirstMask - 2) {
                throw new AssertionError((Object)("read=" + read + " != " + (indexFirstMask - 2)));
            }
            int msgLen = 0;
            for (int i = 0; i < second.length; ++i) {
                msgLen += (second[i] & 0xFF) << 8 * (second.length - 1 - i);
            }
            if (msgLen == 0) {
                msgLen = dataLength;
            }
            System.out.println("msgLen=" + msgLen);
            if (msgLen == 0) {
                if (opcode == 8) {
                    return closeFrame;
                }
                return ignore;
            }
            if (maskBit == 1) {
                this.key = new byte[4];
                read = client.read(this.key, 0, 4);
                if (read != 4) {
                    throw new AssertionError((Object)("4 != " + read));
                }
            }
            if ((read = client.read(encoded = new byte[msgLen], 0, msgLen)) != msgLen) {
                throw new AssertionError((Object)("read = " + read + " != " + msgLen));
            }
            byte[] decoded = new byte[msgLen];
            for (int i = 0; i < encoded.length; ++i) {
                int b = encoded[i];
                if (maskBit == 1) {
                    b ^= this.key[i % 4];
                }
                decoded[i] = (byte)b;
            }
            String ret = new String(decoded);
            if (opcode == 8) {
                return closeFrame;
            }
            return ret;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new LSP.EndOfStream();
        }
    }

    public void writeClient(OutputStream client, String messageText) throws IOException {
        int i;
        boolean maskBit = false;
        byte[] messageBytes = messageText.getBytes(LSP.UTF_8);
        byte[] payloadLen = messageBytes.length < 126 ? new byte[]{(byte)(messageBytes.length + 0)} : new byte[]{126, (byte)(messageBytes.length >> 8), (byte)messageBytes.length};
        int keyLen = 0;
        byte[] out = new byte[1 + payloadLen.length + keyLen + messageBytes.length];
        out[0] = -127;
        for (i = 0; i < payloadLen.length; ++i) {
            out[i + 1] = payloadLen[i];
        }
        for (i = 0; i < keyLen; ++i) {
            out[i + 1 + payloadLen.length] = this.key[i];
        }
        for (i = 0; i < messageBytes.length; ++i) {
            byte b = messageBytes[i];
            out[i + 1 + payloadLen.length + keyLen] = b;
        }
        System.out.println(Arrays.toString(payloadLen) + "    out.length=" + out.length);
        client.write(out);
    }

    public static void upgrade(String token, OutputStream send) throws IOException, NoSuchAlgorithmException {
        byte[] response = ("HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: websocket\r\nSec-WebSocket-Accept: " + Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA-1").digest((token.substring(secKey.length() + 1).trim() + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes("UTF-8"))) + "\r\n\r\n").getBytes("UTF-8");
        send.write(response, 0, response.length);
    }

    public void pong(OutputStream send) throws IOException {
        byte[] response = new byte[2];
        int unsigned = 161;
        int opcode = unsigned >> 4;
        System.out.println("pong:  FIN=" + (unsigned & 1) + ", opcode=" + opcode);
        response[0] = (byte)unsigned;
        response[1] = this.first2[1];
        send.write(response, 0, response.length);
    }
}

