/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RaptorSimpleFormatter
extends Formatter {
    private static Long lastTime = System.currentTimeMillis();
    private static String MSG = "%-10s%dms\t%s.%-20s\t%s\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord log) {
        String s = String.format(MSG, log.getLevel().getName(), new Long(log.getMillis() - lastTime), log.getSourceClassName().substring(log.getSourceClassName().lastIndexOf(".") + 1), log.getSourceMethodName(), log.getMessage());
        Class<RaptorSimpleFormatter> clazz = RaptorSimpleFormatter.class;
        synchronized (RaptorSimpleFormatter.class) {
            lastTime = log.getMillis();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return s;
        }
    }

    public static void initBasicLogger() {
        if (Logger.getLogger("") != null && Logger.getLogger("").getHandlers() != null && Logger.getLogger("").getHandlers().length == 1 && Logger.getLogger("").getHandlers()[0] != null) {
            Logger.getLogger("").removeHandler(Logger.getLogger("").getHandlers()[0]);
        }
        ConsoleHandler c = new ConsoleHandler();
        c.setFormatter(new RaptorSimpleFormatter());
        Logger l = Logger.getLogger("oracle.dbtools.raptor");
        l.setLevel(Level.ALL);
        l.addHandler(c);
    }
}

