/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.insight;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.insight.BasicSuggestedItem;
import oracle.dbtools.insight.SynonymsCache;
import oracle.dbtools.insight.UsersCache;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;

public class BasicInsightableOracleDatabase {
    static boolean debug = false;
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List<Object> binds = new ArrayList<Object>();
    public boolean colNameOrdering = true;
    public final int minLimit = 50;
    public int limit = 50;
    UsersCache users = null;
    SynonymsCache synonyms = null;
    static Map<String, Boolean> dbaSynonymsAtConnection = new HashMap<String, Boolean>();
    private static final String USERNAME_CRITERIA = " and username like ? ";
    private static final String OBJ_TYPE_EQ_PKG = " and object_type = 'PACKAGE' ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String PROCNAME_CRITERIA = " and procedure_name like ? ";
    private static final String VARNAME_CRITERIA = " and name like ? ";
    private static final String OWN_PKG_CRITERIA = " and (o.object_name = ? and a.package_name = ? or o.owner=?) ";
    private static final String STANDALONE_PROC_CRITERIA = " and o.object_name = ? ";
    private static final String PACKAGED_PROC_CRITERIA = " and o.object_name = ? and a.object_name = ? ";
    private boolean prepareUserTablesCalled = false;
    boolean prepareColumnsCalled = false;
    private String schema = null;
    public boolean excludeVirtualColumns = false;
    public boolean adjustCase = true;
    private List<String> prefixedUsers = null;
    public boolean isCancellable = false;
    static int wrkNo = 0;
    private boolean isSynonym = false;
    private static Map<Connection, Statement> pool = new HashMap<Connection, Statement>();
    private Map<String, String> tableAliases = null;
    boolean setTableAliasesCalled = false;
    private boolean isPrefixed = false;
    static boolean isRunning = false;
    public static Mode mode = Mode.UNION;

    public BasicInsightableOracleDatabase(String connection, boolean colNameOrdering) {
        this.connectionName = connection;
        this.colNameOrdering = colNameOrdering;
        this.synonyms = SynonymsCache.synonymsAtConnection.get(connection);
        if (this.synonyms == null) {
            SynonymsCache.fillIn(connection);
            this.synonyms = SynonymsCache.synonymsAtConnection.get(connection);
        }
        this.users = UsersCache.usersAtConnection.get(connection);
    }

    private int limit() {
        return this.limit;
    }

    private final String queryUserTables() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'TABLE' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.owner# = " + this.users.schema + " \nand o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE     object_type = 'TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryUserViews() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'VIEW' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.owner# = " + this.users.schema + " \nand o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE \tobject_type = 'VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllTables() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'TABLE' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type = 'TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllViews() {
        if (this.users != null && this.users.isObjQueriable) {
            return "select 'VIEW' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String queryAllSynonyms() {
        Boolean candidate = dbaSynonymsAtConnection.get(this.connectionName);
        if (candidate == null) {
            Connection conn = null;
            Statement ps = null;
            boolean locked = false;
            try {
                conn = ChameleonConnection.getConnection(this.connectionName);
                if (!ChameleonConnection.isTestConnection()) {
                    locked = LockManager.tryLock(conn, 500L);
                }
                if (!locked) {
                    candidate = false;
                }
                if (candidate == null) {
                    ps = conn.prepareStatement("select 1 FROM sys.DBA_OBJECTS WHERE 1=0");
                    ps.executeQuery();
                    candidate = true;
                }
            }
            catch (Exception e) {
                candidate = false;
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (locked) {
                    LockManager.unlock(conn);
                }
                dbaSynonymsAtConnection.put(this.connectionName, candidate);
            }
        }
        return "select 'TABLE' type, owner, object_name, null column_name, null column_id, null data_type \nFROM " + (candidate != false ? " dba_objects" : " all_objects") + "\nWHERE object_name like ? and object_type = 'SYNONYM' \nand rownum <=" + this.limit() + "\n";
    }

    private final String objName() {
        return (this.users != null && this.users.isObjQueriable ? "" : "object_") + "name";
    }

    private final String OBJ_LIKE_CRITERIA() {
        return " and " + this.objName() + " like ? ";
    }

    private final String OWNER_CRITERIA() {
        if (this.users != null && this.users.isObjQueriable) {
            return " and owner# = ? ";
        }
        return " and owner = ? ";
    }

    private final String MIXED_CASE_CRITERIA() {
        return " and upper(" + this.objName() + ")!=" + this.objName() + " ";
    }

    private final String QUERY_COLUMNS_BY_OWNER_TABLE() {
        return "SELECT 'COLUMN' type, owner, table_name object_name, column_name, column_id, data_type \nFROM sys.all_tab_cols \nWHERE hidden_column = 'NO' and rownum <=" + this.limit() + " and owner = ? and table_name = ? ";
    }

    private final String QUERY_COLUMN_SEQUENCES() {
        return "SELECT 'SEQUENCE' type, USER owner,  object_name, 'NEXTVAL' column_name, null column_id, null data_type \nFROM sys.user_objects \nWHERE object_type = 'SEQUENCE' and rownum <=" + this.limit() + "  ";
    }

    private final String COLUMN_LIKE_CRITERIA() {
        return " and column_name like ? ";
    }

    private final String COLUMN_TYPE_NOT_CRITERIA() {
        return " and data_type != ? ";
    }

    private final String COLUMN_NAME_NOT_CRITERIA() {
        return " and column_name != ? ";
    }

    private final String queryProcedures(boolean isUser) {
        if (this.users != null && this.users.isObjQueriable) {
            return "select case type# when 7 then 'PROCEDURE' \n               when 8 then 'FUNCTION' \n               when 9 then 'PACKAGE' \n               when 33 then 'OPERATOR' \nend type,\n ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nWHERE " + (String)(isUser ? "o.owner# = " + this.users.schema + " and " : "") + "name not like 'BIN%' \nand type# in (7,8,9) \nand rownum <=" + this.limit() + "\n";
        }
        return "SELECT object_type type, " + (isUser ? "SYS_CONTEXT('USERENV','CURRENT_SCHEMA')" : "owner") + "  owner, object_name, null column_name, null column_id, null data_type \nFROM " + (isUser ? "user" : "all") + "_objects \nWHERE rownum <=" + this.limit() + " and object_name not like 'BIN$%'  and object_type IN ('PROCEDURE','FUNCTION','PACKAGE','OPERATOR') \n";
    }

    private final String QUERY_SCHEMAS() {
        return "SELECT 'SCHEMA' type, username owner, username object_name, null column_name, null column_id, null data_type \nFROM all_users WHERE rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_PACKAGED_PROCEDURES() {
        return "SELECT 'FUNCTION' type, owner, object_name/*||'.'||procedure_name*/ object_name, /*null*/procedure_name column_name, null column_id, null data_type \nFROM all_procedures \nWHERE rownum <=" + this.limit() + " OBJ_TYPE_EQ_PKG  and procedure_name is not null \n";
    }

    private final String QUERY_PACKAGED_GLOBAL_VARIABLES() {
        return "select 'NUMBER' type, owner, object_name, name as column_name, null column_id, null data_type \nFROM all_identifiers a\n WHERE usage_context_id = 1\n   and usage = 'DECLARATION'\n   and type = 'VARIABLE'\nand object_type = 'PACKAGE' and rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_ARGUMENTS() {
        return "SELECT 'ARGUMENT' type, null owner,  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name,  a.argument_name||'=>'||substr(a.argument_name,1,1)||'/*'||a.data_type||' '||a.defaulted||'*/' column_name, a.position column_id, null data_type \nFROM all_arguments a, all_objects o \nWHERE a.object_id=o.object_id and rownum <=" + this.limit() + " and    argument_name is not null \n";
    }

    public void prepareUserTables() {
        if (this.prepareUserTablesCalled) {
            return;
        }
        this.prepareUserTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryUserTables());
        this.query.append("\n union all \n");
        this.query.append(this.queryUserViews());
    }

    public void prepareColumns(String name, String colPref) {
        String prefix = null;
        String postfix = null;
        List tmp = LexerToken.parse((String)name);
        if (tmp.size() != 3 || !".".equals(((LexerToken)tmp.get((int)1)).content)) {
            String table;
            postfix = name;
            if (this.synonyms != null && (table = this.synonyms.getTable(null, postfix)) != null) {
                prefix = table.substring(0, table.indexOf(46));
                postfix = table.substring(table.indexOf(46) + 1);
            }
        } else {
            List tmp1;
            String table;
            prefix = ((LexerToken)tmp.get((int)0)).content;
            postfix = ((LexerToken)tmp.get((int)2)).content;
            if (this.synonyms != null && (table = this.synonyms.getTable(prefix, postfix)) != null && (tmp1 = LexerToken.parse((String)table)).size() == 3) {
                prefix = ((LexerToken)tmp1.get((int)0)).content;
                postfix = ((LexerToken)tmp1.get((int)2)).content;
            }
        }
        if (prefix == null) {
            prefix = this.getCurrentSchema();
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(1));
        this.binds.add(Service.handleMixedCase((String)prefix));
        this.binds.add(Service.handleMixedCase((String)postfix));
        if (colPref != null && !"".equals(colPref)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)colPref) + "%");
        }
    }

    private String getCurrentSchema() {
        if (this.schema == null) {
            try {
                this.schema = DBUtil.getInstance(this.getConnection()).executeOracleReturnOneCol("select SYS_CONTEXT('USERENV','CURRENT_SCHEMA') current_schema FROM dual", new HashMap());
            }
            catch (Exception e) {
                Logger.warn(BasicInsightableOracleDatabase.class, e);
                this.schema = "N/A";
            }
        }
        if (this.schema == null) {
            Logger.warn(BasicInsightableOracleDatabase.class, "GetCurrentSchema: schema == null");
            this.schema = "N/A";
        }
        return this.schema;
    }

    public void prepareFQColumns(Set<String> names, String prefix) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(names.size()));
        this.setFQBinds(names, this.binds);
        if (prefix != null && !"".equals(prefix)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)prefix) + "%");
        }
    }

    public void excludeColTypes(List<String> types) {
        for (String type : types) {
            this.query.append(this.COLUMN_TYPE_NOT_CRITERIA());
            this.binds.add(type);
        }
    }

    public void excludeColNames(List<String> names) {
        for (String name : names) {
            this.query.append(this.COLUMN_NAME_NOT_CRITERIA());
            this.binds.add(name);
        }
    }

    public boolean isPrepared() {
        return this.query.length() > 0;
    }

    private String queryByOwnerTable(int size) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                ret.append("\n  union all\n");
            }
            ret.append(this.QUERY_COLUMNS_BY_OWNER_TABLE());
            if (!this.excludeVirtualColumns) continue;
            ret.append(" and virtual_column='NO' ");
        }
        return ret.toString();
    }

    private void setFQBinds(Set<String> names, List<Object> binds) {
        for (String name : names) {
            String table;
            String prefix = name.substring(0, name.indexOf(46));
            binds.add(Service.handleMixedCase((String)prefix));
            String postfix = name.substring(name.indexOf(46) + 1);
            if (this.synonyms != null && (table = this.synonyms.getTable(prefix, postfix)) != null) {
                prefix = table.substring(0, table.indexOf(46));
                postfix = table.substring(table.indexOf(46) + 1);
            }
            binds.add(Service.handleMixedCase((String)postfix));
        }
    }

    public Set<BasicSuggestedItem> fetch() throws Exception {
        if (this.query == null || this.query.length() == 0) {
            return Collections.emptySet();
        }
        long t1 = System.currentTimeMillis();
        TreeSet<BasicSuggestedItem> ret = new TreeSet<BasicSuggestedItem>();
        String qry = null;
        Connection conn = this.getConnection();
        if (conn == null) {
            return Collections.emptySet();
        }
        qry = conn.getMetaData().getDatabaseMajorVersion() > 10 ? this.query.toString().replace("OBJ_TYPE_EQ_PKG", OBJ_TYPE_EQ_PKG) : this.query.toString().replace("OBJ_TYPE_EQ_PKG", "");
        if (mode == Mode.SERIAL) {
            List<Object> binds = new ArrayList<Object>();
            binds.addAll(this.binds);
            int indexOfUnionAll = qry.indexOf("union all");
            while (0 < indexOfUnionAll) {
                String sql = qry.substring(0, indexOfUnionAll);
                qry = qry.substring(indexOfUnionAll + "union all".length());
                int numBinds = new StringTokenizer(" " + sql + " ", "?").countTokens() - 1;
                List<Object> sb = binds.subList(0, numBinds);
                binds = binds.subList(numBinds, binds.size());
                ret.addAll(this.fetch(conn, sql, sb));
                indexOfUnionAll = qry.indexOf("union all");
            }
            if (10 < qry.length()) {
                ret.addAll(this.fetch(conn, qry, binds));
            }
        } else if (mode == Mode.UNION) {
            ret.addAll(this.fetch(conn, qry, this.binds));
        } else {
            throw new AssertionError((Object)"Unexpected ccase");
        }
        if (this.prefixedUsers != null) {
            for (String user : this.prefixedUsers) {
                ret.add(new BasicSuggestedItem("SCHEMA", null, user));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BasicSuggestedItem> fetch(Connection conn, String qry, List<Object> binds) throws Exception {
        TreeSet<BasicSuggestedItem> ret;
        block38: {
            boolean locked;
            block37: {
                ret = new TreeSet<BasicSuggestedItem>();
                ResultSet rs = null;
                locked = false;
                CancelOnTimeout cancel = null;
                try {
                    locked = LockManager.tryLock(conn, 300L);
                    if (!locked) {
                        Set<BasicSuggestedItem> set = Collections.emptySet();
                        return set;
                    }
                    String curuser = conn.getMetaData().getUserName();
                    long t0 = System.currentTimeMillis();
                    PreparedStatement statement = conn.prepareStatement(qry);
                    if (this.isCancellable) {
                        cancel = new CancelOnTimeout(statement);
                        cancel.start();
                    }
                    statement.setFetchSize(this.limit() + 5);
                    long t1 = System.currentTimeMillis();
                    pool.put(conn, statement);
                    if (binds != null) {
                        DBUtil.bind(statement, binds);
                    }
                    try {
                        rs = statement.executeQuery();
                    }
                    catch (Exception e) {
                        Logger.warn(BasicInsightableOracleDatabase.class, e);
                        TreeSet<BasicSuggestedItem> treeSet = ret;
                        if (rs != null) {
                            DBUtil.closeResultSet(rs);
                        }
                        if (locked) {
                            LockManager.unlock(conn);
                        }
                        pool.put(conn, null);
                        return treeSet;
                    }
                    if (debug) {
                        System.out.println(statement.toString() + " prepared " + (t1 - t0) + ", executed " + (System.currentTimeMillis() - t1));
                    }
                    String lastObj = null;
                    HashMap<Integer, String> arguments = new HashMap<Integer, String>();
                    long t2 = System.currentTimeMillis();
                    while (rs.next()) {
                        String type = rs.getString("type");
                        String name = rs.getString("object_name");
                        if (qry.indexOf("object_name||'.'||procedure_name") <= 0) {
                            name = Service.addDoubleQuote((String)name);
                        }
                        String colName = rs.getString("column_name");
                        if ("ARGUMENT".equals(type)) {
                            String object = name;
                            if (lastObj == null || object.equals(lastObj)) {
                                arguments.put(rs.getInt("column_id"), colName);
                            } else {
                                this.inlineArguments(ret, arguments);
                                arguments.put(rs.getInt("column_id"), colName);
                            }
                            lastObj = object;
                            continue;
                        }
                        String owner = rs.getString("owner");
                        if (colName != null && ("COLUMN".equals(type) || "PROCEDURE".equals(type) || "FUNCTION".equals(type)) || "NUMBER".equals(type)) {
                            colName = Service.addDoubleQuote((String)colName);
                            if (owner == null || name == null) {
                                System.out.println(owner);
                            }
                            List<String> cols = this.translate(owner, name, colName);
                            Integer pos = rs.getInt("column_id");
                            if (pos == null || this.colNameOrdering) {
                                pos = -1;
                            }
                            for (String col : cols) {
                                BasicSuggestedItem item = new BasicSuggestedItem(type, null, col, pos);
                                item.columnType = rs.getString("data_type");
                                ret.add(item);
                            }
                            continue;
                        }
                        if ("SEQUENCE".equals(type)) {
                            ret.add(new BasicSuggestedItem(type, name, colName));
                            continue;
                        }
                        if (this.users != null) {
                            int o = -1;
                            try {
                                o = Integer.parseInt(owner);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (o >= 0) {
                                owner = this.users.getUserName(o);
                            }
                        }
                        ret.add(new BasicSuggestedItem(type, curuser.equals(owner) || this.isSynonym ? "" : owner, name));
                    }
                    if (arguments.size() > 0) {
                        this.inlineArguments(ret, arguments);
                        arguments.clear();
                    }
                    if (cancel != null) {
                        cancel.quit = true;
                    }
                    if (debug) {
                        System.out.println("Finished " + statement.toString() + ", time=" + (System.currentTimeMillis() - t0) + ", ret.size()=" + ret.size());
                    }
                    if (rs == null) break block37;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    System.out.println("ret.size()=" + ret.size());
                    break block38;
                }
                finally {
                    if (rs != null) {
                        DBUtil.closeResultSet(rs);
                    }
                    if (locked) {
                        LockManager.unlock(conn);
                    }
                    pool.put(conn, null);
                }
                DBUtil.closeResultSet(rs);
            }
            if (locked) {
                LockManager.unlock(conn);
            }
            pool.put(conn, null);
        }
        if (ret.size() >= this.limit()) {
            BasicSuggestedItem si = null;
            Iterator iterator = ret.iterator();
            if (iterator.hasNext()) {
                BasicSuggestedItem tmp;
                si = tmp = (BasicSuggestedItem)iterator.next();
            }
            ret.add(new BasicSuggestedItem(si.getType(), null, "..."));
        }
        return ret;
    }

    public void setTableAliases(Map<String, String> arg) {
        this.setTableAliases(arg, false);
    }

    public void setTableAliases(Map<String, String> arg, boolean isPref) {
        if (this.setTableAliasesCalled) {
            return;
        }
        this.setTableAliasesCalled = true;
        this.isPrefixed = isPref;
        if (this.synonyms == null) {
            this.tableAliases = arg;
        } else {
            this.tableAliases = new HashMap<String, String>();
            for (String alias : arg.keySet()) {
                String table;
                String tableOrSynonym = arg.get(alias);
                String prefix = null;
                String postfix = tableOrSynonym;
                if (postfix.charAt(0) != '\"' && postfix.indexOf(46) > 0) {
                    prefix = postfix.substring(0, postfix.indexOf(46));
                    postfix = postfix.substring(postfix.indexOf(46) + 1);
                }
                if ((table = this.synonyms.getTable(prefix, postfix)) != null) {
                    tableOrSynonym = table;
                }
                this.tableAliases.put(alias, tableOrSynonym);
            }
        }
    }

    String getTable(String alias) {
        if (this.tableAliases == null) {
            return null;
        }
        return this.tableAliases.get(alias);
    }

    private List<String> translate(String owner, String table, String column) {
        boolean isQualified = false;
        int cnt = 0;
        for (String key : this.tableAliases.keySet()) {
            String tbl;
            ++cnt;
            String tAlias = this.tableAliases.get(key);
            if (key.equalsIgnoreCase(tAlias)) continue;
            String prefix = null;
            String postfix = key;
            if (postfix.charAt(0) != '\"' && postfix.indexOf(46) > 0) {
                prefix = postfix.substring(0, postfix.indexOf(46));
                postfix = postfix.substring(postfix.indexOf(46) + 1);
            }
            if (tAlias.equals(tbl = this.synonyms.getTable(prefix, postfix))) continue;
            isQualified = true;
            break;
        }
        if (this.colNameOrdering && this.isPrefixed) {
            isQualified = true;
        }
        if (1 < cnt) {
            isQualified = true;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (this.tableAliases.size() == 0) {
            ret.add(column);
            return ret;
        }
        for (String alias : this.tableAliases.keySet()) {
            String tbl = this.tableAliases.get(alias);
            if (!tbl.equalsIgnoreCase(owner + "." + table) && !tbl.equalsIgnoreCase(table) && !tbl.equalsIgnoreCase("\"" + owner + "\".\"" + table + "\"") && !tbl.equalsIgnoreCase("\"" + owner + "\"." + table) && !tbl.equalsIgnoreCase("\"" + table + "\"")) continue;
            String qualifiedColName = isQualified ? alias + "." + column : column;
            ret.add(qualifiedColName);
        }
        return ret;
    }

    private void inlineArguments(Set<BasicSuggestedItem> ret, Map<Integer, String> arguments) {
        StringBuilder fullArgs = new StringBuilder();
        StringBuilder shortArgs = new StringBuilder();
        for (int i = 1; i <= arguments.size(); ++i) {
            String arg = arguments.get(i);
            boolean isDefault = 0 < arg.indexOf(" Y*/");
            arg = arg.replace(" Y*/", "*/");
            arg = arg.replace(" N*/", "*/");
            if (fullArgs.length() > 0) {
                fullArgs.append(",");
            }
            fullArgs.append(arg);
            if (isDefault) continue;
            if (shortArgs.length() > 0) {
                shortArgs.append(",");
            }
            shortArgs.append(arg);
        }
        if (fullArgs.length() != shortArgs.length()) {
            ret.add(new BasicSuggestedItem("ARGUMENT", null, "/*min sig:*/" + shortArgs.toString()));
            ret.add(new BasicSuggestedItem("ARGUMENT", null, "/*full sig:*/" + fullArgs.toString()));
        } else {
            ret.add(new BasicSuggestedItem("ARGUMENT", null, fullArgs.toString()));
        }
    }

    public Connection getConnection() throws Exception {
        return ChameleonConnection.getConnection(this.connectionName);
    }

    public static void profile(int duration, int granularity) {
        BasicInsightableOracleDatabase.profile(duration, granularity, 5);
    }

    public static void profile(final int duration, final int granularity, final int stackDepth) {
        if (isRunning) {
            System.out.println("********fired more than once********");
            return;
        }
        isRunning = true;
        String threadName = Thread.currentThread().getName();
        System.out.println("threadName=" + threadName);
        new Thread(){

            @Override
            public void run() {
                String threadName1 = Thread.currentThread().getName();
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + (long)duration) {
                    try {
                        Thread.sleep(granularity);
                        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
                        boolean divide = false;
                        boolean divide2 = false;
                        for (ThreadInfo info : infos) {
                            StackTraceElement elem;
                            if (threadName1.equals(info.getThreadName())) continue;
                            if (divide) {
                                System.out.println("----------------" + info.getThreadName());
                            }
                            divide = false;
                            StackTraceElement[] elems = info.getStackTrace();
                            int i = 0;
                            StackTraceElement[] stackTraceElementArray = elems;
                            int n = stackTraceElementArray.length;
                            for (int j = 0; !(j >= n || (elem = stackTraceElementArray[j]).toString().startsWith("org") || elem.toString().startsWith("oracle.dbtools.raptor.plsql.BackgroundParser") || elem.toString().startsWith("oracle.ide.model.FacadeBufferReference$PollingThread") || elem.toString().startsWith("oracle.ide.util.WeakDataReference$Cleaner") || elem.toString().startsWith("oracle.ide.status.StatusExecutor") || elem.toString().startsWith("oracle.ide.log.QueuedLoggingHandler")); ++j) {
                                if (elem.toString().startsWith("java") || elem.toString().startsWith("sun") || elem.toString().startsWith("oracle.net.ns") || elem.toString().startsWith("oracle.jdbc") || elem.toString().startsWith("oracle.dbtools.raptor.backgroundTask") || elem.toString().startsWith("oracle.javatools.db.execute.QueryWrapper") || elem.toString().startsWith("oracle.javatools.db.execute.ConnectionWrapper") || i >= stackDepth) continue;
                                System.out.println(elem.toString());
                                divide = true;
                                divide2 = true;
                                ++i;
                            }
                        }
                        if (!divide2) continue;
                        System.out.println("=================" + (System.currentTimeMillis() - start));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }

    static {
        try {
            Properties pr = System.getProperties();
            Object m = pr.get("sqldev.insight.mode");
            if (debug) {
                System.out.println("pr.getProperty(\"sqldev.insight.mode\")=" + m);
            }
            if (m != null) {
                for (Mode m1 : Mode.values()) {
                    if (!m1.toString().equals(m)) continue;
                    mode = m1;
                }
            } else {
                String md = ICommonConfig.Storage.getInstance().getString("INSIGHTDBQUERYMODE");
                for (Mode m1 : Mode.values()) {
                    if (!m1.toString().equals(md)) continue;
                    mode = m1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Mode {
        UNION,
        SERIAL;

    }

    private class CancelOnTimeout
    extends Thread {
        boolean quit;
        Statement stmt;

        CancelOnTimeout(Statement stmt) {
            super("CancelOnTimeout" + wrkNo++);
            this.quit = false;
            this.stmt = stmt;
        }

        @Override
        public void run() {
            try {
                int timeout = 500;
                if (500 < BasicInsightableOracleDatabase.this.limit) {
                    timeout = 10000;
                }
                if (mode == Mode.UNION) {
                    timeout *= 2;
                } else if (mode == Mode.SERIAL) {
                    timeout /= 3;
                }
                int minTimeout = 400;
                if (timeout < 400) {
                    timeout = 400;
                }
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.quit) {
                    return;
                }
                if (debug) {
                    System.out.println("Canceling- " + this.stmt.toString());
                }
                long tc = System.currentTimeMillis();
                this.stmt.cancel();
                if (debug) {
                    System.out.println("-done  " + (System.currentTimeMillis() - tc));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

