/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.awt.EventQueue;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.nav.GITConnectionListNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.nav.cmd.GITNavDeleteCommand;

public class GITNavigatorController
implements Controller {
    public boolean handleEvent(IdeAction action, Context context) {
        if (context == null) {
            return false;
        }
        Element[] selection = context.getSelection();
        GITRepositoryNavigator nav = GITRepositoryNavigator.getInstance();
        if (selection == null) {
            return false;
        }
        if (GITUtil.isRepositoryNavigatorView(context.getView()) && selection.length > 0) {
            GITRemote[] nodes;
            if (action.getCommandId() == 51 && (nodes = GITUtil.getGitRemoteNodes(context)).length > 0) {
                RevertNodeCommand.reload((Context)context, (boolean)false);
                this.refreshNavigator(context);
                return true;
            }
            if (action.getCommandId() == 20) {
                boolean stat = false;
                for (Element elm : selection) {
                    if (!(elm instanceof GITRemote)) continue;
                    this.invokeCommand(context, new GITNavDeleteCommand());
                    stat = true;
                }
                return stat;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (context == null) {
            return false;
        }
        GITRepositoryNavigator nav = GITRepositoryNavigator.getInstance();
        if (GITUtil.isRepositoryNavigatorView(context.getView())) {
            if (action.getCommandId() == 51) {
                GITRemote[] nodes = GITUtil.getGitRemoteNodes(context);
                if (nodes.length == 0) {
                    return false;
                }
                for (GITRemote node : nodes) {
                    if (node.canRefresh()) continue;
                    action.setEnabled(false);
                    return true;
                }
                action.setEnabled(true);
                return true;
            }
            if (action.getCommandId() == 20) {
                if (context.getElement() instanceof GITConnectionListNode) {
                    action.setEnabled(false);
                    return true;
                }
                GITRemote[] nodes = GITUtil.getGitRemoteNodes(context);
                if (nodes.length == 0) {
                    return false;
                }
                for (GITRemote node : nodes) {
                    if (node.canDelete()) continue;
                    action.setEnabled(false);
                    return true;
                }
                action.setEnabled(true);
                return true;
            }
        }
        return false;
    }

    private void refreshNavigator(final Context context) {
        if (context.getView() instanceof NavigatorWindow) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExplorer explorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
                    TNode nodeT = explorer.searchTNode((Element)context.getNode(), explorer.getRoot());
                    explorer.expand(nodeT, false, true);
                }
            });
        }
    }

    private void invokeCommand(Context context, GITNavDeleteCommand command) {
        try {
            command.setContext(context);
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITNavigatorController.class.getName()).log(Level.WARNING, e.getMessage());
        }
    }
}

