/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSQuickDiffReferenceProvider;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

public class GITQuickDiffIndexProvider
extends VCSQuickDiffReferenceProvider {
    private static final String ID = "GitIndexCopy";

    GITQuickDiffIndexProvider() {
        super((VCSExtension)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"));
    }

    protected InputStream openInputStream(URL url) throws IOException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("CatIndexFile");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File file = new File(url.getPath());
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            boolean stat = client.catIndexEntry(file, 0, out, monitor);
            if (!stat) {
                throw new IOException(Resource.format("QUICK_DIFF_FILE_CONTENT", URLFileSystem.getPlatformPathName((URL)url)));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITQuickDiffIndexProvider.class.getName()).warning(ex.getMessage());
            throw new IOException(Resource.format("QUICK_DIFF_FILE_CONTENT", URLFileSystem.getPlatformPathName((URL)url)));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    protected boolean isAvailableImpl(URL url) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        VCSStatusFilter filter = profile.getStatusFilter("filters.status.indexed");
        try {
            return filter.accept((VCSStatus)profile.getPolicyStatusCache().get(url));
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return Resource.get("QUICK_DIFF_INDEX");
    }
}

