/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.library.LibrarySearchQueryFilter;

public class LibrarySearchQueryFilterLibraryNameImpl
extends LibrarySearchQueryFilter {
    private List<DefaultMutableTreeNode> m_libraryNodesToBeFilteredOut = new ArrayList<DefaultMutableTreeNode>();

    public LibrarySearchQueryFilterLibraryNameImpl(String searchText) {
        super(LibrarySearchQueryFilterLibraryNameImpl.collapseSpaces((String)(searchText.endsWith("*") ? searchText.toLowerCase() : searchText.toLowerCase() + "*")));
    }

    private static String collapseSpaces(String source) {
        String[] tokens;
        StringBuffer buffer = new StringBuffer();
        for (String token : tokens = source.split(" ")) {
            if ("".equals(token)) continue;
            buffer.append(token);
        }
        return buffer.toString();
    }

    @Override
    public void filterSearchResults(DefaultMutableTreeNode treeRoot) {
        for (DefaultMutableTreeNode nextLibrary : this.m_libraryNodesToBeFilteredOut) {
            nextLibrary.removeFromParent();
        }
    }

    @Override
    public boolean queryLibraries(DefaultMutableTreeNode root, SearchProgress searchProgress) {
        this.m_libraryNodesToBeFilteredOut.addAll(this.getLibraryTreeNodeSubset(root));
        return this.filterLibrariesRecursively(root, this.compilePattern());
    }

    private final boolean filterLibrariesRecursively(DefaultMutableTreeNode root, Pattern pattern) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            Library nextLibrary;
            DefaultMutableTreeNode libraryChildNode = (DefaultMutableTreeNode)root.getChildAt(i);
            if (libraryChildNode.getChildCount() > 0) {
                this.filterLibrariesRecursively(libraryChildNode, pattern);
                continue;
            }
            if (!(libraryChildNode.getUserObject() instanceof Library) || !pattern.matcher(LibrarySearchQueryFilterLibraryNameImpl.collapseSpaces((nextLibrary = (Library)libraryChildNode.getUserObject()).getName().toLowerCase())).matches()) continue;
            this.m_libraryNodesToBeFilteredOut.remove(libraryChildNode);
        }
        return true;
    }

    @Override
    public Icon getHitChildIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }
}

