/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.help.HelpSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JDKModel;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.library.JDKEditPanel;
import oracle.jdevimpl.library.LibrariesPanel;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryListNode;

public class JDKPanel
extends LibrariesPanel {
    private JDKEditPanel _detailPanel;

    public JDKPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.getHelpId());
    }

    @Override
    protected LibraryEditPanel getDetailPanel() {
        if (this._detailPanel == null) {
            this._detailPanel = new JDKEditPanel();
        }
        return this._detailPanel;
    }

    @Override
    protected String getDetailTitle() {
        return LibraryArb.getString(69);
    }

    @Override
    public String getHelpId() {
        return "f1_idededitj2se_html";
    }

    @Override
    public void setSplit(boolean split) {
        ((JDKEditPanel)this.getDetailPanel()).setListsVisible(split);
    }

    @Override
    protected Library commitChanges(MutableLibraryList list, Library lib, LibraryEditPanel panel) throws Exception {
        if (lib == null) {
            return lib;
        }
        JDKEditPanel jdkPanel = (JDKEditPanel)panel;
        String exeText = jdkPanel.getExecutableText();
        if (jdkPanel.getExecutable() == null) {
            Object message = null;
            message = exeText == null || exeText.trim().length() == 0 ? ControlsArb.getString(60) : ControlsArb.format(62, exeText) + " " + ControlsArb.getString(60);
            MessageDialog.error((Component)jdkPanel, (Object)message, (String)ControlsArb.getString(72), null);
            return null;
        }
        JDKModel model = new JDKModel((JDK)lib, list, (Component)jdkPanel);
        model.setName(jdkPanel.getLibraryName());
        model.setClassPath(jdkPanel.getClassPath());
        model.setSourcePath(jdkPanel.getSourcePath());
        model.setDocPath(jdkPanel.getDocPath());
        model.setExecutable(jdkPanel.getExecutable());
        model.setVMs(jdkPanel.getVMs());
        model.setSDKDir(jdkPanel.getSDKDir());
        model.setJavaVersion(jdkPanel.getJavaVersion());
        return model.commit();
    }

    @Override
    protected Library createNewElement(ListWrapper[] wrapper) {
        ListWrapper list = wrapper[0];
        HashStructure hash = HashStructure.newInstance();
        Library lib = new JDKAdapter(hash);
        JDKEditPanel newPanel = new JDKEditPanel();
        newPanel.setLibrary(lib);
        newPanel.setLibraryLists(this.getLibraryLists());
        newPanel.setListsVisible(true);
        newPanel.setLibraryList(list);
        this.listener.initialize(newPanel, lib);
        if (OnePageWizardDialogFactory.runDialog((Component)this, (Component)newPanel, (Component)newPanel.btnExe, (String)this.getDetailTitle(), (int)7, (VetoableChangeListener)this.listener, (DialogRunnerCallback)new SizeKeeperCallback("new.jdk"))) {
            lib = this.listener.getLibrary();
            wrapper[0] = (ListWrapper)newPanel.getLibraryList();
        } else {
            lib = null;
        }
        return lib;
    }

    @Override
    protected LibraryListNode buildListNode(ListWrapper list) {
        List libs = list != null ? list.getJdkList() : null;
        Iterator i = libs != null ? libs.iterator() : null;
        return new LibrariesPanel.LibrariesPanelLibraryListNode(this, list, i);
    }
}

