/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.extension.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.JProjectLibraries;

abstract class HasLibraryRule
extends RuleFunction {
    private static final String PARAMETER_NAME = "library-name";

    HasLibraryRule() {
    }

    protected boolean hasApplicationLibrary(Workspace workspace, Collection<String> names) {
        if (workspace != null) {
            ApplicationLibraries appLibraries = ApplicationLibraries.getInstance(workspace);
            for (String name : names) {
                if (!appLibraries.hasLibrary(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasProjectLibrary(Project project, Collection<String> names) {
        if (project != null) {
            JProjectLibraries libraries = JProjectLibraries.getInstance((PropertyStorage)project);
            for (String name : names) {
                if (!libraries.hasLibrary(name)) continue;
                return true;
            }
            DependencyConfiguration config = DependencyConfiguration.getInstance((Project)project);
            List dependables = config.getDependencyList();
            if (dependables != null) {
                for (Object dependency : dependables) {
                    Element source = ((Dependable)dependency).getSource();
                    if (!(source instanceof Project)) continue;
                    JProjectLibraries depLibraries = JProjectLibraries.getInstance((PropertyStorage)((Project)source));
                    for (String name : names) {
                        if (!depLibraries.hasExport(name)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected final Collection<String> getLibraryNames(Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        RuleFunctionParameter param = this.getRequiredParameterOrThrow(parameters, PARAMETER_NAME);
        HashSet<String> names = new HashSet<String>();
        for (String name : param.getValue().split(",")) {
            names.add(name.trim());
        }
        return names;
    }
}

