/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PatternFilter;

public class ContentFolder {
    private final URL ROOT_URL;
    private final URL CONTENT_FOLDER_URL;
    private final String RELATIVE_PATH;
    private ArrayList _filters;
    private boolean _includeSubfolders;
    private static final int INCLUDE_FILTERS = 0;
    private static final int EXCLUDE_FILTERS = 1;

    public ContentFolder(URL contentFolderURL) {
        this(null, contentFolderURL, null);
    }

    public ContentFolder(URL contentFolderURL, PatternFilter[] filters) {
        this(null, contentFolderURL, filters);
    }

    public ContentFolder(URL contentFolderURL, URL srcRootURL) {
        this(contentFolderURL, srcRootURL, null);
    }

    public ContentFolder(URL contentFolderURL, URL srcRootURL, PatternFilter[] filters) {
        if (srcRootURL == null) {
            throw new IllegalArgumentException("The srcRootURL cannot be null.");
        }
        if (contentFolderURL != null && URLFileSystem.toRelativeSpec((URL)contentFolderURL, (URL)srcRootURL, (boolean)true) == null) {
            throw new IllegalArgumentException("The content folder (" + URLFileSystem.getPlatformPathName((URL)contentFolderURL) + ") is not under the specified source root (" + URLFileSystem.getPlatformPathName((URL)srcRootURL) + ").");
        }
        this._includeSubfolders = true;
        this.ROOT_URL = srcRootURL;
        this.CONTENT_FOLDER_URL = contentFolderURL == null ? srcRootURL : contentFolderURL;
        String relPath = URLFileSystem.toRelativeSpec((URL)contentFolderURL, (URL)srcRootURL, (boolean)true);
        this.RELATIVE_PATH = relPath == null || "".equals(relPath) ? "" : (relPath.endsWith("/") ? relPath : relPath + "/");
        this.setFilters(filters);
    }

    public PatternFilter getPrimaryIncludeFilter() {
        if (this.isIncludeSubfolders()) {
            return PatternFilter.newInclude((String)this.recursivePattern());
        }
        return PatternFilter.newInclude((String)this.nonRecursivePattern());
    }

    private String recursivePattern() {
        return this.RELATIVE_PATH.length() == 0 ? "**" : this.RELATIVE_PATH;
    }

    private String nonRecursivePattern() {
        return this.RELATIVE_PATH.length() == 0 ? "*" : this.RELATIVE_PATH + "*";
    }

    public void addRelativeExcludeFilter(String excludePattern) {
        String pattern = this.RELATIVE_PATH + excludePattern;
        if (pattern.length() > 0) {
            PatternFilter excludeFilter = PatternFilter.newExclude((String)pattern);
            this.addFilter(excludeFilter);
        }
    }

    void removeRelativeExcludeFilter(String pattern) {
        String resolvedPattern;
        if (this._filters != null && (resolvedPattern = this.RELATIVE_PATH + pattern).length() > 0) {
            PatternFilter resolvedFilter = PatternFilter.newExclude((String)resolvedPattern);
            this._filters.remove(resolvedFilter);
            if (this._filters.size() == 0) {
                this._filters.add(PatternFilter.newInclude((String)"**"));
            }
        }
    }

    public void addFilter(PatternFilter patternFilter) {
        if (patternFilter == null) {
            throw new IllegalArgumentException();
        }
        if (this._filters == null) {
            this._filters = new ArrayList();
        }
        if (!this._filters.contains(patternFilter)) {
            if (patternFilter.isInclude()) {
                this._filters.remove(PatternFilter.newInclude((String)"**"));
                if (this.RELATIVE_PATH.length() > 0) {
                    this._filters.remove(PatternFilter.newInclude((String)this.RELATIVE_PATH));
                }
                this._filters.add(patternFilter);
            } else {
                this._filters.add(0, patternFilter);
            }
        }
    }

    public void addRelativeIncludeFilter(String includePattern) {
        String pattern = this.RELATIVE_PATH + includePattern;
        if (pattern.length() > 0) {
            PatternFilter includeFilter = PatternFilter.newInclude((String)pattern);
            this.addFilter(includeFilter);
        }
    }

    void removeRelativeIncludeFilter(String pattern) {
        String resolvedPattern;
        if (this._filters != null && (resolvedPattern = this.RELATIVE_PATH + pattern).length() > 0) {
            PatternFilter resolvedFilter = PatternFilter.newInclude((String)resolvedPattern);
            this._filters.remove(resolvedFilter);
            if (this._filters.size() == 0) {
                this._filters.add(this.getPrimaryIncludeFilter());
            }
        }
    }

    public URL getRootURL() {
        return this.ROOT_URL;
    }

    public URL getContentFolderURL() {
        return this.CONTENT_FOLDER_URL;
    }

    boolean isIncludeSubfolders() {
        return this._includeSubfolders;
    }

    public void setIncludeSubfolders(boolean include) {
        this._includeSubfolders = include;
    }

    ArrayList getIncludeFilters() {
        return this.getDisplayedFilters(0);
    }

    ArrayList getExcludeFilters() {
        return this.getDisplayedFilters(1);
    }

    boolean isExcludeAll() {
        return this._filters != null && this._filters.size() == 0;
    }

    public PatternFilter[] getAllFilters() {
        PatternFilter includeAllFilter;
        if (this._filters == null) {
            this._filters = new ArrayList();
            this._filters.add(this.getPrimaryIncludeFilter());
        }
        if (this._filters.size() == 0) {
            return new PatternFilter[0];
        }
        PatternFilter nonRecursiveFilter = PatternFilter.newInclude((String)this.nonRecursivePattern());
        if (this._filters.contains(nonRecursiveFilter)) {
            this._filters.remove(nonRecursiveFilter);
        }
        if (this._filters.contains(includeAllFilter = PatternFilter.newInclude((String)"**"))) {
            this._filters.remove(includeAllFilter);
        }
        boolean hasInclude = false;
        int length = this._filters.size();
        for (int i = length - 1; i >= 0; --i) {
            PatternFilter pf = (PatternFilter)this._filters.get(i);
            if (!pf.isInclude()) continue;
            hasInclude = true;
            break;
        }
        if (!hasInclude) {
            this._filters.add(this.getPrimaryIncludeFilter());
        }
        PatternFilter[] filterArray = new PatternFilter[this._filters.size()];
        this._filters.toArray(filterArray);
        if (filterArray[0].isInclude()) {
            return filterArray;
        }
        if (filterArray.length == 1 || filterArray[filterArray.length - 1].isExclude()) {
            PatternFilter[] adjustedFilters = new PatternFilter[filterArray.length + 1];
            System.arraycopy(filterArray, 0, adjustedFilters, 0, filterArray.length);
            adjustedFilters[filterArray.length] = this.getPrimaryIncludeFilter();
            return adjustedFilters;
        }
        return filterArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentFolder)) {
            return false;
        }
        ContentFolder that = (ContentFolder)object;
        return this._includeSubfolders == that._includeSubfolders && URLFileSystem.equals((URL)this.ROOT_URL, (URL)that.ROOT_URL) && URLFileSystem.equals((URL)this.CONTENT_FOLDER_URL, (URL)that.CONTENT_FOLDER_URL) && (this._filters != null && that._filters != null && this._filters.equals(that._filters) || this._filters == null && that._filters == null);
    }

    public String toString() {
        return URLFileSystem.getPlatformPathName((URL)this.CONTENT_FOLDER_URL);
    }

    private void setFilters(PatternFilter[] patternFilters) {
        if (patternFilters == null) {
            return;
        }
        if (this._filters == null) {
            this._filters = new ArrayList();
        }
        for (int i = 0; i < patternFilters.length; ++i) {
            this._filters.add(patternFilters[i]);
        }
        this._includeSubfolders = !this._filters.contains(PatternFilter.newInclude((String)this.nonRecursivePattern()));
    }

    private ArrayList getDisplayedFilters(int filterType) {
        ArrayList<PatternFilter> displayedFilters = new ArrayList<PatternFilter>();
        if (this._filters != null) {
            for (PatternFilter filter : this._filters) {
                PatternFilter displayedFilter;
                String newPattern;
                String pattern = filter.getPattern();
                if (pattern.startsWith(this.RELATIVE_PATH)) {
                    if (pattern.equals(this.RELATIVE_PATH)) continue;
                    newPattern = pattern.substring(this.RELATIVE_PATH.length());
                } else {
                    newPattern = pattern;
                }
                if (newPattern.length() <= 0 || newPattern.equals("*") || newPattern.endsWith("**")) continue;
                if (filter.isInclude() && filterType == 0) {
                    displayedFilter = PatternFilter.newInclude((String)newPattern);
                    displayedFilters.add(displayedFilter);
                    continue;
                }
                if (!filter.isExclude() || filterType != 1) continue;
                displayedFilter = PatternFilter.newExclude((String)newPattern);
                displayedFilters.add(displayedFilter);
            }
        }
        return displayedFilters;
    }
}

