/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

class AncestorExpr
extends Attribute {
    String def;
    AncestorDescendantNodes.Type type;
    Predicate unaryFilter;

    public AncestorExpr(String name, String def, AncestorDescendantNodes.Type type, Predicate full) {
        this.name = name;
        this.def = def;
        this.type = type;
        this.unaryFilter = AncestorExpr.unaryFilter(full, name);
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        int nameCol = attributePositions.get(this.name);
        int defCol = attributePositions.get(this.def);
        for (Tuple t : candidates) {
            ParseNode node = t.values[defCol];
            if (this.type == AncestorDescendantNodes.Type.CLOSEST && node != null) {
                node = node.parent();
            }
            while (node != null) {
                ParseNode[] t1 = new ParseNode[t.values.length];
                System.arraycopy(t.values, 0, t1, 0, t.values.length);
                t1[nameCol] = node;
                if (this.unaryFilter.eval(attributePositions, t1, this.src, null)) {
                    ret.add(new Tuple(t1));
                }
                node = node.parent();
            }
        }
        return ret;
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return varDefs.get(this.def);
    }

    @Override
    public String toString() {
        return "\"" + this.name + this.type.oper() + this.def + "\"";
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        Integer pos = attributePositions.get(this.name);
        return tuple[pos];
    }
}

