/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import oracle.arbori.util.Service;

public class IO {
    public static String readFile(Class<?> c, String file) throws IOException {
        URL u = c.getResource(file);
        if (u == null) {
            u = IO.fileNameMainOrTestResource(c, file, "main");
            if (u == null) {
                throw new IOException("File " + file + " not found.");
            }
            try {
                String ret = IO.readFile(u.openStream());
                return ret;
            }
            catch (Exception e) {
                u = IO.fileNameMainOrTestResource(c, file, "test");
                return IO.readFile(u.openStream());
            }
        }
        return IO.readFile(u.openStream());
    }

    public static URL fileNameGitResource(Class<?> c, String file) throws MalformedURLException {
        return IO.fileNameMainOrTestResource(c, file, "main");
    }

    private static URL fileNameMainOrTestResource(Class<?> c, String file, String mainOrTest) throws MalformedURLException {
        String pattern;
        Object tmp = c.getResource("").toString();
        int pos = ((String)tmp).indexOf(pattern = "/classes/");
        if (pos < 0) {
            pattern = "/bin/";
        }
        if ((pos = ((String)tmp).indexOf(pattern)) < 0) {
            return null;
        }
        String pkg = ((String)tmp).substring(pos += pattern.length());
        if ((pos = ((String)(tmp = ((String)tmp).substring(0, pos))).lastIndexOf("arbori")) < 0) {
            pos = ((String)tmp).indexOf("/bin/");
            if (0 < pos) {
                tmp = ((String)tmp).replace("/bin/", "/dbtools-libraries/dbtools-arbori");
            }
        } else {
            if ((pos = ((String)tmp).indexOf("/", pos)) < 0) {
                return null;
            }
            tmp = ((String)tmp).substring(0, pos);
        }
        tmp = (String)tmp + "/src/" + mainOrTest + "/resources";
        if (file.startsWith(pkg)) {
            file = file.substring(pkg.length());
        }
        if (file.startsWith("/" + pkg)) {
            file = file.substring(pkg.length() + 1);
        }
        tmp = (String)tmp + "/" + pkg + file;
        return new URL((String)tmp);
    }

    public static String readFile(String file) throws FileNotFoundException, IOException {
        InputStream fis = null;
        if (file.startsWith("\"") && file.endsWith("\"")) {
            file = file.substring(1, file.length() - 1);
        }
        fis = file.startsWith("file:") ? new URL(file).openStream() : new FileInputStream(file);
        String ret = IO.readFile(fis);
        fis.close();
        return ret;
    }

    public static String readFile(InputStream is) throws IOException {
        String line;
        StringBuilder ret = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            ret.append(line + System.lineSeparator());
        }
        return ret.toString();
    }

    public static List<File> filesInDirectory(String location, String ext) throws IOException {
        return Files.list(Paths.get(location, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith("." + ext)).map(Path::toFile).collect(Collectors.toList());
    }

    public static String[] dirsInDirectory(String location) throws IOException {
        File file = new File(location);
        String[] directories = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        });
        return directories;
    }

    public static List<File> visitor4Directory(String location, String[] exts) throws IOException {
        String[] directories;
        LinkedList<File> ret = new LinkedList<File>();
        for (String ext : exts) {
            ret.addAll(IO.filesInDirectory(location, ext));
        }
        File file = new File(location);
        for (String dir : directories = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        })) {
            ret.addAll(IO.visitor4Directory(location + "/" + dir, exts));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String fromPath, String fromEncoding, String toPath, String toEncoding) {
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            FileInputStream fin = new FileInputStream(fromPath);
            BufferedInputStream bin = new BufferedInputStream(fin);
            reader = fromEncoding == null ? new InputStreamReader(bin) : new InputStreamReader((InputStream)bin, fromEncoding);
            File toFile = new File(toPath);
            File toDir = toFile.getParentFile();
            if (!toDir.isDirectory()) {
                toDir.mkdirs();
            }
            if (!toFile.isFile()) {
                toFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(toPath);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            writer = toEncoding == null ? new OutputStreamWriter(bout) : new OutputStreamWriter((OutputStream)bout, toEncoding);
            int len = 0;
            char[] buf = new char[1024];
            while ((len = reader.read(buf, 0, 1024)) > 0) {
                writer.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            try {
                writer.close();
            }
            catch (Exception e) {
                Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, String dstdir) {
        InputStream in = null;
        OutputStream out = null;
        ZipFile jar = null;
        try {
            int len;
            String name;
            if (url.toString().startsWith("jar:file:")) {
                int end = url.toString().indexOf(33);
                String jarFile = url.toString().substring("jar:file:".length(), end);
                jar = new JarFile(jarFile);
                JarEntry je = ((JarFile)jar).getJarEntry(url.toString().substring(end + 2));
                in = ((JarFile)jar).getInputStream(je);
                String path = je.getName();
                File file = new File(path);
                name = file.getName();
            } else {
                String path = url.getPath();
                File file = new File(path);
                name = file.getName();
                in = new FileInputStream(path);
            }
            out = new FileOutputStream(new File(dstdir + File.separator + name));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

