/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import oracle.mof.xmi.XMIErrorMessage;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XMIErrorHandler
implements ErrorHandler {
    private static Pattern XDK_WORKAROUND_PATTERN;
    private URL m_location;
    private boolean m_warningAsError;
    private SAXParseException m_fatalError;
    private boolean m_errorOccurred;
    private ArrayList<XMIErrorMessage> m_messages = new ArrayList();
    private boolean m_sortMessages;

    public XMIErrorHandler(URL location, boolean warningAsError) {
        this.m_location = location;
        this.m_warningAsError = warningAsError;
    }

    @Override
    public void warning(SAXParseException exception) {
        this.createMessage(this.m_warningAsError, exception);
    }

    @Override
    public void error(SAXParseException exception) {
        this.createMessage(true, exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.m_fatalError = exception;
        this.error(exception);
    }

    public void exception(Exception exception) {
        if (this.m_fatalError != exception) {
            if (exception instanceof SAXParseException) {
                this.error((SAXParseException)exception);
            } else {
                Object message = exception.getMessage();
                if (message == null) {
                    message = exception.getClass().getName();
                    StackTraceElement[] stack = exception.getStackTrace();
                    if (stack.length > 0) {
                        StackTraceElement ste = stack[0];
                        message = (String)message + " at " + ste.getClassName() + ":" + ste.getLineNumber();
                    }
                }
                this.createMessage(true, -1, -1, (String)message);
            }
        }
    }

    private void createMessage(boolean error, SAXParseException exception) {
        this.createMessage(error, exception.getLineNumber(), exception.getColumnNumber(), XDK_WORKAROUND_PATTERN.matcher(exception.getMessage()).replaceFirst(""));
    }

    private void createMessage(boolean error, int lineNumber, int columnNumber, String message) {
        if (error) {
            this.m_errorOccurred = true;
        }
        this.m_sortMessages = true;
        this.m_messages.add(new XMIErrorMessage(this.m_location, error, lineNumber, columnNumber, message));
    }

    public boolean hasErrors() {
        return this.m_errorOccurred;
    }

    public List<XMIErrorMessage> getMessages() {
        if (this.m_sortMessages) {
            Collections.sort(this.m_messages);
            this.m_sortMessages = false;
        }
        return Collections.unmodifiableList(this.m_messages);
    }

    static {
        try {
            XDK_WORKAROUND_PATTERN = Pattern.compile("^.*<Line \\d+, Column \\d+>: [^(]*: \\([^)]*\\) ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

