/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.placekey;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.spatial.geometry.FastJGeometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.placekey.BaseCell;
import oracle.spatial.util.placekey.Face;
import oracle.spatial.util.placekey.HexSearch;

public class PlaceKey {
    long H3 = 0L;
    static final long H3_MAX_OFFSET = 63L;
    static final long H3_MODE_OFFSET = 59L;
    static final long H3_BASE_OFFSET = 45L;
    static final long H3_RES_OFFSET = 52L;
    static final long H3_RESERVED_OFFSET = 56L;
    static final long H3_PER_DIGIT_OFFSET = 3L;
    static final long H3_HIGH_BIT_MASK = Long.MIN_VALUE;
    static final long H3_HIGH_BIT_MASK_NEGATIVE = Long.MAX_VALUE;
    static final long H3_MODE_MASK = 0x7800000000000000L;
    static final long H3_MODE_MASK_NEGATIVE = -8646911284551352321L;
    static final long H3_BASE_MASK = 0xFE00000000000L;
    static final long H3_BASE_MASK_NEGATIVE = -4468415255281665L;
    static final long H3_RES_MASK = 0xF0000000000000L;
    static final long H3_RES_MASK_NEGATIVE = -67553994410557441L;
    static final long H3_RESERVED_MASK = 0x700000000000000L;
    static final long H3_RESERVED_NEGATIVE = -504403158265495553L;
    static final long H3_DIGIT_MASK = 7L;
    static final long PK_BASE_SHIFT = (long)Math.pow(2.0, 45.0);
    static final long PK_BASE_RES = 12L;
    static final long PK_UNUSED_RES_FILLER = (long)Math.pow(2.0, 9.0) - 1L;
    static final String ALPHABET = "23456789bcdfghjkmnpqrstvwxyz";
    static final int ALPHABET_LENGTH = "23456789bcdfghjkmnpqrstvwxyz".length();
    static final int CODE_LENGTH = 9;
    static final int TUPLE_LENGTH = 3;
    static final char PADDING_CHAR = 'a';
    static final String REPLACEMENT_CHARS = "eu";
    static final Map<String, String> REPLACEMENT_MAP;
    static final Map<String, String> RESTORE_MAP;
    static final int[][] NEW_DIGIT_II;
    static final int[][] NEW_DIGIT_III;
    static final int[][] NEW_ADJUSTMENT_II;
    static final int[][] NEW_ADJUSTMENT_III;
    static final long MAX_RES = 15L;
    static final long H3_NULL = 0L;
    static final int[] DIRECTIONS;
    int rotations;

    public String lonlatToPlaceKey(double d, double d2) {
        d = d * Math.PI / 180.0;
        d2 = d2 * Math.PI / 180.0;
        return this.h3ToPlaceKey(this.lonlatToH3(d, d2, 10));
    }

    public JGeometry PlaceKeyToLonLat(String string) {
        JGeometry jGeometry = this.h3ToLonLat(this.placekeyToH3(string));
        double[] dArray = jGeometry.getPoint();
        dArray[0] = dArray[0] * 180.0 / Math.PI;
        dArray[1] = dArray[1] * 180.0 / Math.PI;
        return new JGeometry(dArray[0], dArray[1], 4326);
    }

    public JGeometry PlaceKeyToPolygon(String string) {
        JGeometry jGeometry = this.h3ToBoundaryLL(this.placekeyToH3(string));
        double[] dArray = jGeometry.getOrdinatesArray();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * 180.0 / Math.PI;
        }
        return JGeometry.createLinearPolygon((double[])dArray, (int)2, (int)4326);
    }

    public String h3ToPlaceKey(long l) {
        int n;
        StringBuilder stringBuilder;
        long l2 = this.truncate_h3(l);
        String string = this.encodeShortH3(l2);
        if ((string = this.cleanString(string)).length() < 9) {
            stringBuilder = new StringBuilder(string);
            for (n = 0; n < 9 - string.length(); ++n) {
                stringBuilder.append('a');
            }
            string = stringBuilder.toString();
        }
        stringBuilder = new StringBuilder();
        for (n = 0; n < string.length(); n += 3) {
            stringBuilder.append(string.substring(n, n + 3));
            stringBuilder.append('-');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("@");
        return stringBuilder.reverse().toString();
    }

    public long truncate_h3(long l) {
        long l2 = (long)Math.pow(2.0, 52.0);
        long l3 = (l + PK_BASE_SHIFT) % l2;
        return l3 >>>= 9;
    }

    public String encodeShortH3(long l) {
        if (l == 0L) {
            return String.valueOf(ALPHABET.charAt(0));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (l > 0L) {
            int n = (int)(l % (long)ALPHABET_LENGTH);
            stringBuilder.append(ALPHABET.charAt(n));
            l = Math.floorDiv(l, (long)ALPHABET_LENGTH);
        }
        return stringBuilder.toString();
    }

    public String cleanString(String string) {
        for (String string2 : REPLACEMENT_MAP.keySet()) {
            if (!string.contains(string2)) continue;
            string.replace(string2, REPLACEMENT_MAP.get(string2));
        }
        return string;
    }

    public long placekeyToH3(String string) {
        string = string.replace("@", "");
        string = string.replace("-", "");
        string = string.replace(String.valueOf('a'), "");
        string = this.uncleanString(string);
        long l = this.decodePlaceKey(string);
        return this.unshortenH3Integer(l);
    }

    public String uncleanString(String string) {
        for (String string2 : RESTORE_MAP.keySet()) {
            if (!string.contains(string2)) continue;
            string.replace(string2, RESTORE_MAP.get(string2));
        }
        return string;
    }

    public long decodePlaceKey(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l += (long)Math.pow(ALPHABET_LENGTH, i) * (long)ALPHABET.indexOf(string.charAt(string.length() - 1 - i));
        }
        return l;
    }

    public long unshortenH3Integer(long l) {
        long l2 = l << 9;
        long l3 = this.getHeaderInt() + PK_UNUSED_RES_FILLER - PK_BASE_SHIFT + l2;
        return l3;
    }

    public long getHeaderInt() {
        Long l = new Long(this.lonlatToH3(0.0, 0.0, 10));
        String string = Long.toBinaryString(l);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 64 - string.length(); ++i) {
            stringBuilder.append('0');
        }
        string = stringBuilder.toString() + string;
        string = string.substring(0, 12);
        StringBuilder stringBuilder2 = new StringBuilder(string);
        string = stringBuilder2.reverse().toString();
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l2 += (long)Math.pow(Double.parseDouble(String.valueOf(string.charAt(i))) * 2.0, i);
        }
        --l2;
        return l2 *= (long)Math.pow(2.0, 52.0);
    }

    public long lonlatToH3(double d, double d2, int n) {
        if ((long)n < 0L || (long)n > 15L) {
            return 0L;
        }
        if (!Double.isFinite(d2) || !Double.isFinite(d)) {
            return 0L;
        }
        Face face = new Face();
        face.lonlatToFaceCoord(d, d2, n);
        long l = this.faceCoordToH3(face, n);
        return l;
    }

    public long faceCoordToH3(Face face, int n) {
        int n2;
        long l = this.h3Init();
        l = this.h3SetMode(l, 1);
        l = this.h3SetResolution(l, n);
        double[] dArray = face.coords.getPoint();
        BaseCell baseCell = new BaseCell();
        if (n == 0) {
            if (dArray[0] > 2.0 || dArray[1] > 2.0 || dArray[2] > 2.0) {
                return 0L;
            }
            l = this.h3SetBaseCell(l, baseCell.faceCoordToBaseCell(face));
            return l;
        }
        Face face2 = face;
        double[] dArray2 = new double[3];
        for (n2 = n - 1; n2 >= 0; --n2) {
            JGeometry jGeometry;
            JGeometry jGeometry2 = face2.coords;
            if (face2.isResClass3(n2 + 1)) {
                jGeometry = face2.coords = face2.ccwParentAp7(face2.coords);
                jGeometry = face2.ccwChildrenAp7(jGeometry);
            } else {
                jGeometry = face2.coords = face2.cwParentAp7(face2.coords);
                jGeometry = face2.cwChildrenAp7(jGeometry);
            }
            JGeometry jGeometry3 = face2.subtractCoordinates(jGeometry2.getPoint(), jGeometry.getPoint());
            jGeometry3 = face2.norm(jGeometry3);
            l = this.h3SetIndexDigit(l, n2 + 1, face2.coordToDigit(jGeometry3));
            dArray2 = face2.coords.getPoint();
        }
        face2.coords = new JGeometry(dArray2[0], dArray2[1], dArray2[2], 4326);
        if (dArray2[0] > 2.0 || dArray2[1] > 2.0 || dArray2[2] > 2.0) {
            return 0L;
        }
        n2 = baseCell.faceCoordToBaseCell(face2);
        l = this.h3SetBaseCell(l, n2);
        int n3 = baseCell.faceCoordToBaseCellCCW60NumRot(face2);
        if (baseCell.isPentagon(n2)) {
            if (this.h3MostSignificantDigit(l) == 1) {
                l = baseCell.baseCellhasCwOffset(n2, face2.face) ? this.h3Rotate60degcw(l) : this.h3Rotate60degccw(l);
            }
            for (int i = 0; i < n3; ++i) {
                l = this.h3PentagonRot60ccw(l);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                l = this.h3Rotate60degccw(l);
            }
        }
        return l;
    }

    public long h3Init() {
        return 0x1FFFFFFFFFFFL;
    }

    public long h3SetMode(long l, int n) {
        return l & 0x87FFFFFFFFFFFFFFL | (long)n << 59;
    }

    public long h3SetResolution(long l, int n) {
        return l & 0xFF0FFFFFFFFFFFFFL | (long)n << 52;
    }

    public long h3SetBaseCell(long l, int n) {
        return l & 0xFFF01FFFFFFFFFFFL | (long)n << 45;
    }

    public long h3SetIndexDigit(long l, int n, int n2) {
        return l & (7L << (int)((15L - (long)n) * 3L) ^ 0xFFFFFFFFFFFFFFFFL) | (long)n2 << (int)((15L - (long)n) * 3L);
    }

    public int h3MostSignificantDigit(long l) {
        for (int i = 1; i <= this.h3GetResolution(l); ++i) {
            if (this.h3GetIndexDigit(l, i) == 0) continue;
            return this.h3GetIndexDigit(l, i);
        }
        return 0;
    }

    public int h3GetResolution(long l) {
        return (int)((l & 0xF0000000000000L) >> 52);
    }

    public int h3GetBaseCell(long l) {
        return (int)((l & 0xFE00000000000L) >> 45);
    }

    public int h3GetIndexDigit(long l, int n) {
        return (int)(l >> (int)((15L - (long)n) * 3L) & 7L);
    }

    public long h3Rotate60degcw(long l) {
        int n = this.h3GetResolution(l);
        for (int i = 1; i <= n; ++i) {
            l = this.h3SetIndexDigit(l, i, this.rotate60cw(this.h3GetIndexDigit(l, i)));
        }
        return l;
    }

    public long h3Rotate60degccw(long l) {
        int n = this.h3GetResolution(l);
        for (int i = 1; i <= n; ++i) {
            l = this.h3SetIndexDigit(l, i, this.rotate60ccw(this.h3GetIndexDigit(l, i)));
        }
        return l;
    }

    public long h3PentagonRot60ccw(long l) {
        boolean bl = false;
        int n = this.h3GetResolution(l);
        for (int i = 1; i <= n; ++i) {
            l = this.h3SetIndexDigit(l, i, this.rotate60ccw(this.h3GetIndexDigit(l, i)));
            if (bl || this.h3GetIndexDigit(l, i) == 0) continue;
            bl = true;
            if (this.h3MostSignificantDigit(l) != 1) continue;
            l = this.h3Rotate60degccw(l);
        }
        return l;
    }

    public int rotate60cw(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 6: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 1;
            }
        }
        return n;
    }

    public int rotate60ccw(int n) {
        switch (n) {
            case 1: {
                return 5;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 4;
            }
        }
        return n;
    }

    public JGeometry h3ToLonLat(long l) {
        Face face = this.h3ToFaceCoord(l);
        JGeometry jGeometry = face.faceCoordToLonLat(this.h3GetResolution(l));
        return jGeometry;
    }

    public JGeometry h3ToBoundaryLL(long l) {
        Face face = this.h3ToFaceCoord(l);
        JGeometry jGeometry = this.h3IsPentagon(l) ? face.faceCoordsToBoundaryPent(this.h3GetResolution(l), 0, 5) : face.faceCoordsToBoundary(this.h3GetResolution(l), 0, 6);
        return jGeometry;
    }

    public Face h3ToFaceCoord(long l) {
        boolean bl;
        int n;
        int n2 = this.h3GetBaseCell(l);
        BaseCell baseCell = new BaseCell();
        Face face = new Face(baseCell.getBaseCell(n2));
        if (baseCell.isPentagon(n2) && this.h3MostSignificantDigit(l) == 5) {
            l = this.h3Rotate60degcw(l);
        }
        double[] dArray = face.coords.getPoint();
        int n3 = this.h3GetResolution(l);
        boolean bl2 = false;
        if (!baseCell.isPentagon(this.h3GetBaseCell(l)) && (n3 == 0 || dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0)) {
            bl2 = true;
        }
        Face face2 = this.h3FaceTraversal(l, baseCell, face);
        if (bl2) {
            return face;
        }
        JGeometry jGeometry = face.coords;
        if (face.isResClass3(n3)) {
            face.coords = face.cwChildrenAp7(face.coords);
            ++n3;
        }
        if ((n = face.adjustClass2Overage(n3, bl = baseCell.isPentagon(n2) && this.h3MostSignificantDigit(l) == 4, 0)) != 0) {
            if (baseCell.isPentagon(n2)) {
                while (face.adjustClass2Overage(n3, false, 0) != 0) {
                }
            }
            if (n3 != this.h3GetResolution(l)) {
                face.coords = face.ccwParentAp7(face.coords);
            }
        } else if (n3 != this.h3GetResolution(l)) {
            face.coords = jGeometry;
        }
        return face;
    }

    public Face h3FaceTraversal(long l, BaseCell baseCell, Face face) {
        int n = this.h3GetResolution(l);
        for (int i = 1; i <= n; ++i) {
            face.coords = face.isResClass3(i) ? face.ccwChildrenAp7(face.coords) : face.cwChildrenAp7(face.coords);
            JGeometry jGeometry = face.neighbor(face.coords, this.h3GetIndexDigit(l, i));
            if (jGeometry == null) continue;
            face.coords = jGeometry;
        }
        return face;
    }

    public boolean h3IsPentagon(long l) {
        BaseCell baseCell = new BaseCell();
        return baseCell.isPentagon(this.h3GetBaseCell(l)) && this.h3MostSignificantDigit(l) == 0;
    }

    public long[] coverPolygonwithHex(JGeometry jGeometry, int n) throws Exception {
        HexSearch hexSearch = new HexSearch();
        Object[] objectArray = jGeometry.getOrdinatesOfElements();
        hexSearch.numSearchedHexes = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            hexSearch = this.getEdgeHexes((double[])objectArray[i], n, hexSearch);
        }
        hexSearch.found.clear();
        FastJGeometry fastJGeometry = new FastJGeometry(jGeometry, 0.0, EnumSet.allOf(FastJGeometry.FastOp.class), true);
        while (hexSearch.numSearchedHexes > 0) {
            int n2 = 0;
            Iterator<Long> iterator = hexSearch.search.iterator();
            for (int i = 0; i < hexSearch.numSearchedHexes; ++i) {
                Long l = iterator.next();
                long[] lArray = this.getKRingNeighbours(l, 1);
                for (int j = 0; j < lArray.length; ++j) {
                    long l2;
                    JGeometry jGeometry2;
                    if (lArray[j] == 0L || !(jGeometry2 = this.h3ToLonLat(l2 = lArray[j])).isInside((JGeometry)fastJGeometry, 0.0) || hexSearch.out.contains(l2)) continue;
                    hexSearch.out.add(l2);
                    hexSearch.found.add(l2);
                }
                ++n2;
            }
            hexSearch.search = new HashSet<Long>(hexSearch.found);
            hexSearch.numSearchedHexes = hexSearch.search.size();
            hexSearch.found.clear();
        }
        long[] lArray = new long[hexSearch.out.size()];
        Iterator<Long> iterator = hexSearch.out.iterator();
        for (int i = 0; i < hexSearch.out.size(); ++i) {
            lArray[i] = iterator.next();
        }
        return lArray;
    }

    public long[] getKRingNeighbours(long l, int n) {
        int n2 = 3 * n * (n + 1) + 1;
        int[] nArray = new int[n2];
        long[] lArray = new long[n2];
        lArray = this.kRingHelper(l, n, lArray, nArray, n2, 0);
        return lArray;
    }

    public long[] kRingHelper(long l, int n, long[] lArray, int[] nArray, int n2, int n3) {
        if (l == 0L) {
            return lArray;
        }
        int n4 = (int)(l % (long)n2);
        while (lArray[n4] != 0L && lArray[n4] != l) {
            n4 = (n4 + 1) % n2;
        }
        if (lArray[n4] == l && nArray[n4] <= n3) {
            return lArray;
        }
        lArray[n4] = l;
        nArray[n4] = n3;
        if (n3 >= n) {
            return lArray;
        }
        for (int i = 0; i < 6; ++i) {
            this.rotations = 0;
            lArray = this.kRingHelper(this.h3Neighbor(l, DIRECTIONS[i]), n, lArray, nArray, n2, n3 + 1);
        }
        return lArray;
    }

    public long h3Neighbor(long l, int n) {
        int n2;
        long l2;
        block18: {
            int n3;
            block17: {
                block19: {
                    int n4;
                    l2 = l;
                    for (n2 = 0; n2 < this.rotations; ++n2) {
                        n = this.rotate60ccw(n);
                    }
                    n2 = 0;
                    int n5 = this.h3GetBaseCell(l2);
                    int n6 = this.h3MostSignificantDigit(l2);
                    int n7 = this.h3GetResolution(l2) - 1;
                    BaseCell baseCell = new BaseCell();
                    Face face = new Face();
                    while (true) {
                        if (n7 == -1) {
                            l2 = this.h3SetBaseCell(l2, baseCell.getBaseCellNeighbour(n5, n));
                            n2 = baseCell.getBaseCellNeighbour60CCWRots(n5, n);
                            if (this.h3GetBaseCell(l2) != 127) break;
                            l2 = this.h3SetBaseCell(l2, baseCell.getBaseCellNeighbour(n5, 5));
                            n2 = baseCell.getBaseCellNeighbour60CCWRots(n5, 5);
                            l2 = this.h3Rotate60degccw(l2);
                            ++this.rotations;
                            break;
                        }
                        n4 = this.h3GetIndexDigit(l2, n7 + 1);
                        n3 = 0;
                        if (face.isResClass3(n7 + 1)) {
                            l2 = this.h3SetIndexDigit(l2, n7 + 1, NEW_DIGIT_II[n4][n]);
                            n3 = NEW_ADJUSTMENT_II[n4][n];
                        } else {
                            l2 = this.h3SetIndexDigit(l2, n7 + 1, NEW_DIGIT_III[n4][n]);
                            n3 = NEW_ADJUSTMENT_III[n4][n];
                        }
                        if (n3 == 0) break;
                        n = n3;
                        --n7;
                    }
                    if (!baseCell.isPentagon(n4 = this.h3GetBaseCell(l2))) break block17;
                    n3 = 0;
                    if (this.h3MostSignificantDigit(l2) == 1) {
                        if (n5 != n4) {
                            if (baseCell.baseCellhasCwOffset(n4, BaseCell.baseCells[n5].face)) {
                                l2 = this.h3Rotate60degccw(l2);
                            }
                            n3 = 1;
                        } else {
                            if (n6 == 0) {
                                return 0L;
                            }
                            if (n6 == 3) {
                                l2 = this.h3Rotate60degccw(l2);
                                ++this.rotations;
                            } else if (n6 == 5) {
                                l2 = this.h3Rotate60degccw(l2);
                                this.rotations += 5;
                            } else {
                                return 0L;
                            }
                        }
                    }
                    for (int i = 0; i < n2; ++i) {
                        l2 = this.h3Rotate60degccw(l2);
                    }
                    if (n5 == n4) break block18;
                    if (n4 != 4 && n4 != 117) break block19;
                    if (n5 != 118 && n5 != 8 && this.h3MostSignificantDigit(l2) != 3) {
                        ++this.rotations;
                    }
                    break block18;
                }
                if (this.h3MostSignificantDigit(l2) != 5 || n3 != 0) break block18;
                ++this.rotations;
                break block18;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                l2 = this.h3Rotate60degccw(l2);
            }
        }
        this.rotations = (this.rotations + n2) % 6;
        return l2;
    }

    public HexSearch getEdgeHexes(double[] dArray, int n, HexSearch hexSearch) {
        for (int i = 0; i < dArray.length - 2; i += 2) {
            JGeometry jGeometry = new JGeometry(dArray[i], dArray[i + 1], 4326);
            JGeometry jGeometry2 = new JGeometry(dArray[i + 2], dArray[i + 3], 4326);
            int n2 = this.lineEstimateHex(jGeometry, jGeometry2, n);
            for (int j = 0; j < n2; ++j) {
                double d = dArray[i] * (double)(n2 - j) / (double)n2 + dArray[i + 2] * (double)j / (double)n2;
                double d2 = dArray[i + 1] * (double)(n2 - j) / (double)n2 + dArray[i + 3] * (double)j / (double)n2;
                long l = this.lonlatToH3(d, d2, n);
                if (hexSearch.found.contains(l)) continue;
                hexSearch.found.add(l);
                hexSearch.search.add(l);
                ++hexSearch.numSearchedHexes;
            }
        }
        return hexSearch;
    }

    public int lineEstimateHex(JGeometry jGeometry, JGeometry jGeometry2, int n) {
        List<Long> list = this.getAllPentagons(n);
        double d = this.getRadiusKm(list.get(0));
        double d2 = this.distKm(jGeometry.getPoint(), jGeometry2.getPoint());
        int n2 = (int)Math.ceil(d2 / (2.0 * d));
        if (n2 == 0) {
            n2 = 1;
        }
        return n2;
    }

    public double getRadiusKm(long l) {
        JGeometry jGeometry = this.h3ToLonLat(l);
        JGeometry jGeometry2 = this.h3ToBoundaryLL(l);
        JGeometry jGeometry3 = new JGeometry(jGeometry2.getOrdinatesArray()[0], jGeometry2.getOrdinatesArray()[1], 4326);
        return this.distKm(jGeometry.getPoint(), jGeometry3.getPoint());
    }

    public double distKm(double[] dArray, double[] dArray2) {
        double d = Math.sin((dArray2[1] - dArray[1]) / 2.0);
        double d2 = Math.sin((dArray2[0] - dArray[0]) / 2.0);
        double d3 = d * d + Math.cos(dArray[1]) * Math.cos(dArray2[1]) * d2 * d2;
        double d4 = 2.0 * Math.atan2(Math.sqrt(d3), Math.sqrt(1.0 - d3)) * 6371.007180918475;
        return d4;
    }

    public List<Long> getAllPentagons(int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        BaseCell baseCell = new BaseCell();
        for (int i = 0; i < 122; ++i) {
            if (!baseCell.isPentagon(i)) continue;
            long l = this.genH3Index(n, i, 0);
            arrayList.add(l);
        }
        return arrayList;
    }

    public long genH3Index(int n, int n2, int n3) {
        long l = this.h3Init();
        l = this.h3SetMode(l, 1);
        l = this.h3SetResolution(l, n);
        l = this.h3SetBaseCell(l, n2);
        for (int i = 1; i <= n; ++i) {
            l = this.h3SetIndexDigit(l, i, n3);
        }
        return l;
    }

    public String[] polygonToPlaceKeys(JGeometry jGeometry) throws Exception {
        Object[] objectArray;
        Object[] objectArray2 = jGeometry.densifyArcs(0.005).getOrdinatesOfElements();
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray = (double[])objectArray2[i];
            for (int j = 0; j < objectArray.length; ++j) {
                objectArray[j] = objectArray[j] * Math.PI / 180.0;
            }
            objectArray2[i] = objectArray;
        }
        jGeometry = JGeometry.createLinearPolygon((Object[])objectArray2, (int)2, (int)jGeometry.getSRID());
        FastJGeometry fastJGeometry = new FastJGeometry(jGeometry, 0.0, EnumSet.allOf(FastJGeometry.FastOp.class), true);
        objectArray = this.coverPolygonwithHex(jGeometry, 10);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            JGeometry jGeometry2 = this.h3ToBoundaryLL((long)objectArray[i]);
            if (jGeometry2.isInside((JGeometry)fastJGeometry, 0.0)) {
                arrayList.add(this.h3ToPlaceKey((long)objectArray[i]));
                arrayList.add("FALSE");
                continue;
            }
            if (!jGeometry2.anyInteract((JGeometry)fastJGeometry, 0.0)) continue;
            arrayList.add(this.h3ToPlaceKey((long)objectArray[i]));
            arrayList.add("TRUE");
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("prn", "pre");
        hashMap.put("f4nny", "f4nne");
        hashMap.put("tw4t", "tw4e");
        hashMap.put("ngr", "ngu");
        hashMap.put("dck", "dce");
        hashMap.put("vjn", "vju");
        hashMap.put("fck", "fce");
        hashMap.put("pns", "pne");
        hashMap.put("sht", "she");
        hashMap.put("kkk", "kke");
        hashMap.put("fgt", "fgu");
        hashMap.put("dyk", "dye");
        hashMap.put("bch", "bce");
        REPLACEMENT_MAP = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put("pre", "prn");
        hashMap.put("f4nne", "f4nny");
        hashMap.put("twet", "tw4t");
        hashMap.put("ngu", "ngr");
        hashMap.put("dce", "dck");
        hashMap.put("vju", "vjn");
        hashMap.put("fce", "fck");
        hashMap.put("pne", "pns");
        hashMap.put("she", "sht");
        hashMap.put("kke", "kkk");
        hashMap.put("fgu", "fgt");
        hashMap.put("dye", "dyk");
        hashMap.put("bce", "bch");
        RESTORE_MAP = Collections.unmodifiableMap(hashMap);
        NEW_DIGIT_II = new int[][]{{0, 1, 2, 3, 4, 5, 6}, {1, 4, 3, 5, 6, 2, 0}, {2, 3, 1, 4, 6, 0, 5}, {3, 6, 4, 5, 0, 1, 2}, {4, 5, 6, 0, 2, 3, 1}, {5, 2, 0, 1, 3, 6, 4}, {6, 0, 5, 2, 1, 4, 3}};
        NEW_DIGIT_III = new int[][]{{0, 1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 6, 0}, {2, 3, 4, 5, 6, 0, 1}, {3, 4, 5, 6, 0, 1, 2}, {4, 5, 6, 0, 1, 2, 3}, {5, 6, 0, 1, 2, 3, 4}, {6, 0, 1, 2, 3, 4, 5}};
        NEW_ADJUSTMENT_II = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 0, 5, 0}, {0, 0, 2, 5, 0, 0, 2}, {0, 1, 3, 3, 0, 0, 0}, {0, 0, 0, 0, 4, 4, 6}, {0, 5, 0, 0, 4, 5, 0}, {0, 0, 2, 0, 6, 0, 6}};
        NEW_ADJUSTMENT_III = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 3, 0, 1, 0}, {0, 0, 2, 2, 0, 0, 5}, {0, 3, 2, 3, 0, 0, 0}, {0, 0, 0, 0, 4, 5, 4}, {0, 1, 0, 0, 5, 5, 0}, {0, 0, 6, 0, 4, 0, 6}};
        DIRECTIONS = new int[]{2, 3, 1, 5, 4, 6};
    }
}

