/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.spatial.util.Util;
import oracle.sql.BLOB;

public class Hilbert {
    public static long hilbert_xy2d(long l, long l2, long l3) {
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        long l8 = l3;
        for (long i = l >> 1; i >= 1L; i >>= 1) {
            l4 = (l7 & i) > 0L ? 1 : 0;
            l5 = (l8 & i) > 0L ? 1 : 0;
            l6 += i * i * (3L * l4 ^ l5);
            if (l5 != 0L) continue;
            if (l4 == 1L) {
                l7 = i - 1L - l7;
                l8 = i - 1L - l8;
            }
            long l9 = l7;
            l7 = l8;
            l8 = l9;
        }
        return l6;
    }

    public static long[] hilbert_d2xy(long l, long l2) {
        long l3 = l2;
        long l4 = 0L;
        long l5 = 0L;
        for (long i = 1L; i < l; i *= 2L) {
            long l6 = 1L & l3 / 2L;
            long l7 = 1L & (l3 ^ l6);
            if (l7 == 0L) {
                if (l6 == 1L) {
                    l4 = i - 1L - l4;
                    l5 = i - 1L - l5;
                }
                l3 = l4;
                l4 = l5;
                l5 = l3;
            }
            l4 += i * l6;
            l5 += i * l7;
            l3 /= 4L;
        }
        return new long[]{l4, l5};
    }

    public static void addToBlocksFromInputTable(long l, String string, String string2, int n) throws IOException, SQLException {
        long l2;
        int n2 = 3;
        Connection connection = DriverManager.getConnection("jdbc:default:connection:");
        PreparedStatement preparedStatement = connection.prepareStatement("select\n  blk_id,\n  lhv,\n  points,\n  num_points\nfrom\n  " + Util.enquoteTableName(connection, string2) + "\nwhere\n  obj_id = ?\norder by\n  lhv\nfor update of points, num_points", 1004, 1008);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        HilbertSelectResultSet hilbertSelectResultSet = new HilbertSelectResultSet(connection, string, n2);
        Blob blob = null;
        FilterOutputStream filterOutputStream = null;
        DataOutputStream dataOutputStream = null;
        long l3 = l2 = Long.MIN_VALUE;
        BlockRecord blockRecord = new BlockRecord(n2);
        int n3 = -1;
        try {
            while (hilbertSelectResultSet.next()) {
                long l4 = hilbertSelectResultSet.getD();
                if (l4 > l3 && n3 >= 0) {
                    filterOutputStream.close();
                    resultSet.updateInt(4, blockRecord.ptId + 1);
                    resultSet.updateRow();
                }
                while (l4 > l3 && resultSet.next()) {
                    n3 = resultSet.getInt(1);
                    l2 = l3;
                    try {
                        l3 = resultSet.getLong(2);
                    }
                    catch (SQLException sQLException) {
                        System.out.println("Value " + resultSet.getString(2));
                        throw new RuntimeException(sQLException);
                    }
                    if (l4 > l3) continue;
                    blob = resultSet.getBlob(3);
                    filterOutputStream = new BufferedOutputStream(blob.setBinaryStream(blob.length() + 1L), 32 * n);
                    dataOutputStream = new DataOutputStream(filterOutputStream);
                    blockRecord.blkId = n3;
                    blockRecord.ptId = resultSet.getInt(4) - 1;
                }
                blockRecord.read(hilbertSelectResultSet);
                ++blockRecord.ptId;
                blockRecord.write(dataOutputStream);
            }
            if (blockRecord.ptId > 0) {
                filterOutputStream.close();
                resultSet.updateInt(4, blockRecord.ptId + 1);
                resultSet.updateRow();
                connection.commit();
            }
        }
        catch (Exception exception) {
            System.out.println("Hilbert blocking Error!");
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        resultSet.close();
        preparedStatement.close();
    }

    public static void confirmLhvColumn(Connection connection, String string) throws SQLException {
        String string2;
        String string3;
        int n = string.indexOf(".");
        if (n < 0) {
            string3 = string;
            string2 = null;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select\n  count(*)\nfrom\n  all_tab_columns\nwhere\n  owner = nvl(?, user) and\n  table_name = ? and\n  column_name = 'LHV'");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            resultSet.close();
            if (n2 == 0) {
                Statement statement = connection.createStatement();
                statement.executeUpdate("alter table " + Util.enquoteTableName(connection, string) + " add (lhv number)");
                statement.close();
            }
        } else {
            throw new RuntimeException();
        }
        preparedStatement.close();
    }

    private static PreparedStatement getBlockInsertionPreparedStatement(Connection connection, String string, long l, int n) throws SQLException {
        return connection.prepareStatement("insert /*+ APPEND */ into " + Util.enquoteTableName(connection, string) + " (\n  obj_id,\n  blk_id,\n  blk_extent,\n  blk_domain,\n  pcblk_min_res,\n  pcblk_max_res,\n  num_points,\n  num_unsorted_points,\n  pt_sort_dim,\n  points,\n  lhv)\nvalues (\n  ?,\n  ?,\n  sdo_geometry(\n" + (n == 2 ? "    2003,\n" : "    3008,\n") + "    " + (l == 0L ? "null" : Long.valueOf(l)) + ",\n    null,\n    sdo_elem_info_array(\n" + (n == 2 ? "      1, 1003, 3),\n" : "      1, 1007, 3),\n") + "    sdo_ordinate_array(\n" + (n == 2 ? "      ?, ?,    ?, ?   )),\n" : "      ?, ?, ?, ?, ?, ?)),\n") + "  null,\n  1,\n  1,\n  ?,\n  ?,\n  null,\n  ?,\n  ?)");
    }

    private static PreparedStatement getUnBlockedAttrsInsertionPreparedStatement(Connection connection, String string, String string2, String string3, long l) throws SQLException {
        if (string2 == null) {
            return null;
        }
        return connection.prepareStatement("insert /*+ APPEND */ into " + Util.enquoteTableName(connection, string2) + " (\n  select\n    block.x ptn_id,\n    block.y point_id,\n    t.*\n  from\n    " + Util.enquoteTableName(connection, string) + " t,\n    table(?) block  where\n    t.rid = block.z)");
    }

    private static int getBlkTableMdNumDims(Connection connection, String string) throws SQLException {
        String string2 = "select sdo_pc_pkg.get_pc_blk_table_ext_dim(blk_table => ?) from dual";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            int n = resultSet.getInt(1);
            resultSet.close();
            preparedStatement.close();
            return n;
        }
        return 0;
    }

    public static void generateBlocksFromInputTable(long l, long l2, String string, String string2, int n, double d, int n2, String string3) throws IOException, SQLException {
        int n3 = n2;
        Connection connection = DriverManager.getConnection("jdbc:default:connection:");
        int n4 = Hilbert.getBlkTableMdNumDims(connection, string2);
        Hilbert.confirmLhvColumn(connection, string2);
        PreparedStatement preparedStatement = Hilbert.getBlockInsertionPreparedStatement(connection, string2, l2, n4);
        PreparedStatement preparedStatement2 = Hilbert.getUnBlockedAttrsInsertionPreparedStatement(connection, string, string3, string2, l2);
        HilbertSelectResultSet hilbertSelectResultSet = new HilbertSelectResultSet(connection, string, n3);
        hilbertSelectResultSet.setFetchSize(n);
        BLOB bLOB = null;
        BufferedOutputStream bufferedOutputStream = null;
        DataOutputStream dataOutputStream = null;
        MBR mBR = new MBR();
        BlockRecord blockRecord = new BlockRecord(n3);
        long l3 = 0L;
        long l4 = 0L;
        try {
            while (hilbertSelectResultSet.next()) {
                long l5 = hilbertSelectResultSet.getD();
                if (blockRecord.ptId > 10 && l5 - l4 > 4L * (l3 - l4)) {
                    Hilbert.finalizeBlock(connection, preparedStatement, preparedStatement2, l3, bLOB, bufferedOutputStream, dataOutputStream, mBR, l, blockRecord.blkId, blockRecord.ptId, n4);
                    ++blockRecord.blkId;
                    blockRecord.ptId = 0;
                }
                blockRecord.read(hilbertSelectResultSet);
                mBR.update(blockRecord);
                if (blockRecord.ptId == 0) {
                    bLOB = BLOB.createTemporary((Connection)connection, (boolean)true, (int)12);
                    bufferedOutputStream = new BufferedOutputStream(bLOB.setBinaryStream(1L), 32 * n);
                    dataOutputStream = new DataOutputStream(bufferedOutputStream);
                    l3 = l4 = l5;
                }
                blockRecord.write(dataOutputStream);
                if (++blockRecord.ptId == n) {
                    Hilbert.finalizeBlock(connection, preparedStatement, preparedStatement2, l5, bLOB, bufferedOutputStream, dataOutputStream, mBR, l, blockRecord.blkId, blockRecord.ptId, n4);
                    ++blockRecord.blkId;
                    blockRecord.ptId = 0;
                }
                l3 = l5;
            }
        }
        catch (Exception exception) {
            System.out.println("Hilbert blocking exception");
            exception.printStackTrace();
        }
        if (blockRecord.ptId > 0) {
            Hilbert.finalizeBlock(connection, preparedStatement, preparedStatement2, Long.MAX_VALUE, bLOB, bufferedOutputStream, dataOutputStream, mBR, l, blockRecord.blkId, blockRecord.ptId, n4);
        }
        connection.commit();
        preparedStatement.close();
        if (preparedStatement2 != null) {
            preparedStatement2.close();
        }
        hilbertSelectResultSet.close();
    }

    private static void finalizeBlock(Connection connection, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, long l, BLOB bLOB, BufferedOutputStream bufferedOutputStream, DataOutputStream dataOutputStream, MBR mBR, long l2, long l3, long l4, int n) throws SQLException, IOException {
        bufferedOutputStream.close();
        Hilbert.writeBlock(preparedStatement, preparedStatement2, l2, l3, mBR, l4, bLOB, l, n);
        bLOB.freeTemporary();
        if (l3 % 10L == 0L) {
            connection.commit();
        }
        mBR.reset();
    }

    private static void writeBlock(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, long l, long l2, MBR mBR, long l3, BLOB bLOB, long l4, int n) throws SQLException {
        preparedStatement.setLong(1, l);
        preparedStatement.setLong(2, l2);
        if (n == 2) {
            preparedStatement.setDouble(3, Math.abs(mBR.coords[0]) < 1.0E-100 ? 0.0 : mBR.coords[0]);
            preparedStatement.setDouble(4, Math.abs(mBR.coords[1]) < 1.0E-100 ? 0.0 : mBR.coords[1]);
            preparedStatement.setDouble(5, Math.abs(mBR.coords[3]) < 1.0E-100 ? 0.0 : mBR.coords[3]);
            preparedStatement.setDouble(6, Math.abs(mBR.coords[4]) < 1.0E-100 ? 0.0 : mBR.coords[4]);
            preparedStatement.setLong(7, l3);
            preparedStatement.setLong(8, l3);
            preparedStatement.setBlob(9, (Blob)bLOB);
            preparedStatement.setLong(10, l4);
        } else {
            preparedStatement.setDouble(3, Math.abs(mBR.coords[0]) < 1.0E-100 ? 0.0 : mBR.coords[0]);
            preparedStatement.setDouble(4, Math.abs(mBR.coords[1]) < 1.0E-100 ? 0.0 : mBR.coords[1]);
            preparedStatement.setDouble(5, Math.abs(mBR.coords[2]) < 1.0E-100 ? 0.0 : mBR.coords[2]);
            preparedStatement.setDouble(6, Math.abs(mBR.coords[3]) < 1.0E-100 ? 0.0 : mBR.coords[3]);
            preparedStatement.setDouble(7, Math.abs(mBR.coords[4]) < 1.0E-100 ? 0.0 : mBR.coords[4]);
            preparedStatement.setDouble(8, Math.abs(mBR.coords[5]) < 1.0E-100 ? 0.0 : mBR.coords[5]);
            preparedStatement.setLong(9, l3);
            preparedStatement.setLong(10, l3);
            preparedStatement.setBlob(11, (Blob)bLOB);
            preparedStatement.setLong(12, l4);
        }
        preparedStatement.executeUpdate();
    }

    private static class MBR {
        protected double[] coords;

        public MBR() {
            this.reset();
        }

        public void reset() {
            this.coords = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE};
        }

        public void update(BlockRecord blockRecord) {
            if (blockRecord.coords[0] < this.coords[0]) {
                this.coords[0] = blockRecord.coords[0];
            }
            if (blockRecord.coords[1] < this.coords[1]) {
                this.coords[1] = blockRecord.coords[1];
            }
            if (blockRecord.coords[2] < this.coords[2]) {
                this.coords[2] = blockRecord.coords[2];
            }
            if (blockRecord.coords[0] > this.coords[3]) {
                this.coords[3] = blockRecord.coords[0];
            }
            if (blockRecord.coords[1] > this.coords[4]) {
                this.coords[4] = blockRecord.coords[1];
            }
            if (blockRecord.coords[2] > this.coords[5]) {
                this.coords[5] = blockRecord.coords[2];
            }
        }
    }

    private static class BlockRecord {
        protected double[] coords;
        protected int blkId = 1;
        protected int ptId = 0;

        protected BlockRecord(int n) {
            this.coords = new double[n];
        }

        public void read(HilbertSelectResultSet hilbertSelectResultSet) throws SQLException {
            for (int i = 0; i < this.coords.length; ++i) {
                this.coords[i] = hilbertSelectResultSet.getDouble(i + 1);
            }
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            for (int i = 0; i < this.coords.length; ++i) {
                dataOutputStream.writeDouble(this.coords[i]);
            }
            dataOutputStream.writeInt(this.blkId);
            dataOutputStream.writeInt(this.ptId);
        }

        public String toString() {
            return "[" + this.blkId + ", " + this.ptId + "](" + this.coords[0] + ", " + this.coords[1] + ", " + this.coords[2] + ")";
        }
    }

    private static class HilbertSelectResultSet {
        private ResultSet m_currentResultSet;
        private final String m_query;
        private final PreparedStatement m_selectStm;
        private final int m_numDims;
        private long m_numResult;
        private long m_dAtOneTrillion;

        public HilbertSelectResultSet(Connection connection, String string, int n) throws SQLException {
            this.m_numDims = n;
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "val_d" + (i + 1) + ", ";
            }
            this.m_query = "select " + string2 + "d from " + Util.enquoteTableName(connection, string) + " where d > ? order by d, val_d1, val_d2, val_d3";
            this.m_selectStm = connection.prepareStatement(this.m_query);
            this.m_selectStm.setLong(1, Long.MIN_VALUE);
            this.m_currentResultSet = this.m_selectStm.executeQuery();
        }

        public boolean next() throws SQLException {
            if (this.m_numResult == 1000000000L) {
                this.m_dAtOneTrillion = this.getD();
            }
            ++this.m_numResult;
            boolean bl = this.m_currentResultSet.next();
            if (this.m_numResult > 1000000000L && this.getD() > this.m_dAtOneTrillion) {
                this.m_currentResultSet.close();
                this.m_selectStm.setLong(1, this.m_dAtOneTrillion);
                this.m_currentResultSet = this.m_selectStm.executeQuery();
                bl = this.m_currentResultSet.next();
                this.m_numResult = 1L;
            }
            return bl;
        }

        public long getD() throws SQLException {
            return this.m_currentResultSet.getLong(this.m_numDims + 1);
        }

        public double getDouble(int n) throws SQLException {
            return this.m_currentResultSet.getDouble(n);
        }

        public void setFetchSize(int n) throws SQLException {
            this.m_currentResultSet.setFetchSize(n);
        }

        public void close() throws SQLException {
            this.m_currentResultSet.close();
        }

        public boolean isAfterLast() throws SQLException {
            return this.m_currentResultSet.isAfterLast();
        }
    }
}

