/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Month;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;

public class ByMonthClause
extends AbstractRepeatIntervalClause<Month, SortedClauseModel<Month>> {
    public ByMonthClause(RepeatIntervalModel repeatIntervalModel) {
        this(Month.class, repeatIntervalModel);
    }

    protected ByMonthClause(SortedClauseModel<Month> sortedClauseModel) {
        super(sortedClauseModel);
    }

    protected ByMonthClause(Class<Month> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<Month>(clazz, ClauseType.BYMONTH, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class Panel
    extends PropertyBasedPanel {
        protected GridBagLayout gridBagLayout2;
        protected Calendar calender;
        protected Locale locale;
        protected Map<String, Integer> monthNames;
        protected JCheckBox[] monthCheckBoxes;
        protected JButton clearButton;

        public Panel(Properties properties) {
            super(properties);
            this.gridBagLayout2 = new GridBagLayout();
            this.calender = Calendar.getInstance();
            this.locale = null;
            this.monthNames = null;
            this.monthCheckBoxes = new JCheckBox[12];
            this.clearButton = new JButton();
            for (int i = 0; i < this.monthCheckBoxes.length; ++i) {
                this.monthCheckBoxes[i] = new JCheckBox();
            }
            this.applyLocale(Locale.getDefault());
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((SortedClauseModel)ByMonthClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout2);
            for (Map.Entry<String, Integer> entry : this.monthNames.entrySet()) {
                String string = entry.getKey();
                JCheckBox jCheckBox = this.monthCheckBoxes[entry.getValue()];
                jCheckBox.setText(string);
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Panel.this.monthCheckBox_actionPerformed(actionEvent);
                    }
                });
            }
            this.clearButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.clearButton_actionPerformed(actionEvent);
                }
            });
            this.clearButton.setMargin(new Insets(0, 0, 0, 0));
            int n = 0;
            int n2 = 1;
            double d = 0.0;
            double d2 = 0.0;
            int n3 = 0;
            for (JCheckBox jCheckBox : this.monthCheckBoxes) {
                this.add((Component)jCheckBox, new GridBagConstraints(n, n2, 1, 1, d, d2, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                ++n3;
                if (++n > 1) {
                    n = 0;
                    ++n2;
                    d = 0.0;
                } else {
                    d = 1.0;
                }
                if (n3 != 11) continue;
                d2 = 0.0;
            }
            this.add((Component)this.clearButton, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        }

        protected void clearButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)ByMonthClause.this.clauseModel).clear();
        }

        protected void applyLocale(Locale locale) {
            this.locale = locale;
            this.monthNames = this.calender.getDisplayNames(2, 2, locale);
            for (Map.Entry<String, Integer> entry : this.monthNames.entrySet()) {
                String string = entry.getKey();
                JCheckBox jCheckBox = this.monthCheckBoxes[entry.getValue()];
                jCheckBox.setText(string);
            }
        }

        protected void setMonthCheckBox(int n, boolean bl) {
            JCheckBox jCheckBox = this.monthCheckBoxes[n];
            ButtonModel buttonModel = jCheckBox.getModel();
            buttonModel.setSelected(bl);
        }

        protected void setMonthCheckBox(Month month, boolean bl) {
            this.setMonthCheckBox(month.ordinal(), bl);
        }

        protected void resetMonthCheckBoxes(Month[] monthArray) {
            Month[] monthArray2 = Month.values();
            int n = 0;
            for (int i = 0; i < this.monthCheckBoxes.length; ++i) {
                Month month = monthArray2[i];
                boolean bl = false;
                if (monthArray != null && n < monthArray.length && month == monthArray[n]) {
                    bl = true;
                    ++n;
                }
                this.setMonthCheckBox(month, bl);
            }
        }

        protected void resetMonthCheckBoxes() {
            this.resetMonthCheckBoxes(null);
        }

        protected void monthCheckBox_actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = jCheckBox.getText();
            Integer n = this.monthNames.get(string);
            Month month = Month.values()[n];
            if (jCheckBox.isSelected()) {
                ((SortedClauseModel)ByMonthClause.this.clauseModel).add(month);
            } else {
                ((SortedClauseModel)ByMonthClause.this.clauseModel).remove(month);
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYMONTH: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        Object object2 = repeatIntervalModelEvent.getOldValue();
                        if (object2 != null && !object2.getClass().isArray()) {
                            Panel.this.setMonthCheckBox((Month)object2, false);
                        }
                        if (object == null) break;
                        if (object.getClass().isArray()) {
                            Panel.this.resetMonthCheckBoxes((Month[])object);
                            break;
                        }
                        Panel.this.setMonthCheckBox((Month)object, true);
                    }
                }
            }
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    string2 = string2.trim();
                    try {
                        ((SortedClauseModel)ByMonthClause.this.clauseModel).add(Month.values()[Integer.valueOf(string2)]);
                    }
                    catch (Throwable throwable) {
                        try {
                            ((SortedClauseModel)ByMonthClause.this.clauseModel).add(Month.valueOf(string2.toUpperCase()));
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

