/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import com.mxgraph.swing.handler.mxKeyboardHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.view.mxGraph;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.scheduler.editors.chain.ChainGraphViewer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChainMxKeyboardHandler
extends mxKeyboardHandler {
    ChainGraphViewer controller = null;
    mxGraphComponent graphComponent;
    InputMap whenFocusedInputMap = null;
    InputMap whenAncestorOfFocusCompInputMap = null;
    ActionMap actionMap = null;

    public ChainMxKeyboardHandler(ChainGraphViewer chainGraphViewer, mxGraphComponent mxGraphComponent2) {
        super(mxGraphComponent2);
        this.controller = chainGraphViewer;
        this.graphComponent = mxGraphComponent2;
    }

    protected InputMap getInputMap(int n) {
        InputMap inputMap = super.getInputMap(n);
        if (n == 0) {
            if (this.whenFocusedInputMap == null) {
                this.whenFocusedInputMap = new InputMap(){
                    {
                        this.put(KeyStroke.getKeyStroke("F2"), "edit");
                        this.put(KeyStroke.getKeyStroke("DELETE"), "delete");
                        this.put(KeyStroke.getKeyStroke("UP"), "selectParent");
                        this.put(KeyStroke.getKeyStroke("DOWN"), "selectChild");
                        this.put(KeyStroke.getKeyStroke("RIGHT"), "selectNext");
                        this.put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious");
                        this.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "enterGroup");
                        this.put(KeyStroke.getKeyStroke("PAGE_UP"), "exitGroup");
                        this.put(KeyStroke.getKeyStroke("HOME"), "home");
                        this.put(KeyStroke.getKeyStroke("ENTER"), "edit");
                        this.put(KeyStroke.getKeyStroke("BACK_SPACE"), "collapse");
                        this.put(KeyStroke.getKeyStroke("control A"), "selectAll");
                        this.put(KeyStroke.getKeyStroke("control D"), "selectNone");
                        this.put(KeyStroke.getKeyStroke("control X"), "cut");
                        this.put(KeyStroke.getKeyStroke("CUT"), "cut");
                        this.put(KeyStroke.getKeyStroke("control C"), "copy");
                        this.put(KeyStroke.getKeyStroke("COPY"), "copy");
                        this.put(KeyStroke.getKeyStroke("control V"), "paste");
                        this.put(KeyStroke.getKeyStroke("PASTE"), "paste");
                        this.put(KeyStroke.getKeyStroke("control G"), "group");
                        this.put(KeyStroke.getKeyStroke("control U"), "ungroup");
                        this.put(KeyStroke.getKeyStroke("control ADD"), "zoomIn");
                        this.put(KeyStroke.getKeyStroke("control SUBTRACT"), "zoomOut");
                    }
                };
            }
            this.whenFocusedInputMap.setParent(inputMap);
            return this.whenFocusedInputMap;
        }
        if (n == 1) {
            if (this.whenAncestorOfFocusCompInputMap == null) {
                this.whenAncestorOfFocusCompInputMap = new InputMap();
            }
            this.whenAncestorOfFocusCompInputMap.setParent(inputMap);
            return this.whenAncestorOfFocusCompInputMap;
        }
        return null;
    }

    protected ActionMap createActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        ActionMap actionMap = super.createActionMap();
        if (this.actionMap.keys() != null) {
            for (Object object : this.actionMap.keys()) {
                actionMap.put(object, this.actionMap.get(object));
            }
        }
        actionMap.put("edit", new EditAction());
        actionMap.put("delete", new DeleteAction());
        actionMap.put("home", mxGraphActions.getHomeAction());
        actionMap.put("enterGroup", mxGraphActions.getEnterGroupAction());
        actionMap.put("exitGroup", mxGraphActions.getExitGroupAction());
        actionMap.put("collapse", mxGraphActions.getCollapseAction());
        actionMap.put("expand", mxGraphActions.getExpandAction());
        actionMap.put("toBack", mxGraphActions.getToBackAction());
        actionMap.put("toFront", mxGraphActions.getToFrontAction());
        actionMap.put("selectNone", mxGraphActions.getSelectNoneAction());
        actionMap.put("selectAll", mxGraphActions.getSelectAllAction());
        actionMap.put("selectNext", mxGraphActions.getSelectNextAction());
        actionMap.put("selectPrevious", mxGraphActions.getSelectPreviousAction());
        actionMap.put("selectParent", mxGraphActions.getSelectParentAction());
        actionMap.put("selectChild", mxGraphActions.getSelectChildAction());
        actionMap.put("cut", TransferHandler.getCopyAction());
        actionMap.put("copy", TransferHandler.getCopyAction());
        actionMap.put("paste", new PasteAction());
        actionMap.put("group", mxGraphActions.getGroupAction());
        actionMap.put("ungroup", mxGraphActions.getUngroupAction());
        actionMap.put("zoomIn", mxGraphActions.getZoomInAction());
        actionMap.put("zoomOut", mxGraphActions.getZoomOutAction());
        return actionMap;
    }

    public void addXMLAction(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equalsIgnoreCase("keyaction")) continue;
            String string2 = XMLHelper.getNodeValue((Node)node2, (String)"keystroke");
            String string3 = XMLHelper.getNodeValue((Node)node2, (String)"actionclass");
            KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
            Object object = this.instantiate(string3);
            if (keyStroke == null || object == null) continue;
            this.whenFocusedInputMap.put(keyStroke, object);
        }
    }

    private Object instantiate(String string) {
        Object var2_2 = null;
        try {
            Object[] objectArray;
            Constructor<?> constructor;
            Class<?> clazz = Class.forName(string);
            try {
                constructor = clazz.getConstructor(mxGraphComponent.class);
                objectArray = new Object[]{this.graphComponent};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = clazz.getConstructor(new Class[0]);
                objectArray = new Object[]{};
            }
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Logger.getLogger(ChainMxKeyboardHandler.class.getName()).log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        return var2_2;
    }

    public mxGraph getGraph(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof mxGraphComponent) {
            return ((mxGraphComponent)object).getGraph();
        }
        return null;
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            super("Edit");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            mxGraph mxGraph2 = ChainMxKeyboardHandler.this.getGraph(actionEvent);
            if (mxGraph2 != null && (objectArray = mxGraph2.getSelectionCells()) != null && objectArray.length == 1) {
                Object object = objectArray[0];
                if (mxGraph2.getModel().isVertex(object)) {
                    ChainMxKeyboardHandler.this.controller.createStepTable(ChainMxKeyboardHandler.this.controller.getNodefromGuiMap(object), object);
                } else if (mxGraph2.getModel().isEdge(object)) {
                    ChainMxKeyboardHandler.this.controller.createRuleTable(ChainMxKeyboardHandler.this.controller.getRuleFromGuiMap(object), object);
                }
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            Object[] objectArray;
            mxGraph mxGraph2 = ChainMxKeyboardHandler.this.getGraph(actionEvent);
            if (mxGraph2 != null && ChainMxKeyboardHandler.this.controller.isEditable() && (objectArray = mxGraph2.getSelectionCells()) != null && objectArray.length == 1 && (action = ChainMxKeyboardHandler.this.controller.getDropAction()) != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    private class PasteAction
    extends AbstractAction {
        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

