/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.beanmodel.BeanBaseRegistry;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.beanmodel.versioning.VersionManagerCreator;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomModelHolder;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.impl.DomModelFactory;
import oracle.bali.xml.dom.impl.DomModelPluginFactory;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContextReference;
import oracle.bali.xml.gui.jdev.explorer.ExplorerCollapseAllAction;
import oracle.bali.xml.gui.jdev.explorer.ExplorerExpandAllAction;
import oracle.bali.xml.gui.jdev.explorer.ExplorerShowAsTopAction;
import oracle.bali.xml.gui.jdev.explorer.ExplorerShowRootAction;
import oracle.bali.xml.gui.jdev.extension.HookDataListener;
import oracle.bali.xml.gui.jdev.extension.guifactory.DeclarativeGuiFactory;
import oracle.bali.xml.gui.jdev.extension.setup.DeclarativeSetupHookData;
import oracle.bali.xml.gui.jdev.extension.setup.DeclarativeSetupHookSupport;
import oracle.bali.xml.gui.jdev.extension.viewfactory.DeclarativeViewFactory;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.bali.xml.gui.jdev.services.JDevVersionControlService;
import oracle.bali.xml.gui.jdev.undo.TransactionMediator;
import oracle.bali.xml.gui.jdev.util.GotoSourceAction;
import oracle.bali.xml.gui.jdev.util.JDevOperationFactory;
import oracle.bali.xml.gui.jdev.util.SurroundAction;
import oracle.bali.xml.gui.jdev.util.WeakNodeListenerProxy;
import oracle.bali.xml.gui.jdev.util.XdfGoToDeclarationAction;
import oracle.bali.xml.gui.jdev.util.XmlGoToPropertiesAction;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlContextReference;
import oracle.bali.xml.model.XmlContextSetupHook;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.model.annotation.AnnotationGrammar;
import oracle.bali.xml.model.annotation.AnnotationMetadataResolver;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.datatransfer.operation.OperationFactory;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.message.AbstractDelegatingIssueList;
import oracle.bali.xml.model.resource.PaternalResourceBundle;
import oracle.bali.xml.preference.XmlPreferenceManager;
import oracle.bali.xml.preference.jdev.JDevXmlPreferenceManager;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.UndoableEditWrapper;
import oracle.bali.xml.share.WeakListenerProxy;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.status.IssueListener;
import oracle.ide.status.StatusManager;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;

public class JDevXmlContext
extends SwingXmlContext {
    public static final String PROPERTY_PROJECT = "project";
    private static final Log LOG = new Log("status-xml");
    private NodeListener _nodeListener = new ContextNodeListener();
    private ProjectObserver _projectObserver;
    private boolean _guessingAllowed;
    private Project _project;
    private Workspace _workspace;
    private XmlGui _activeGui;
    private Set _techKeys;
    private long _activeGuiTimestamp;
    private LinkedList<SoftReference<JDevXmlContext>> _softlyPinnedRelatedJDevXmlContexts = new LinkedList();
    private Object _softlyPinnedRelatedJDevXmlContextsLock = new Object();
    private static final ContextIssueListener _ISSUE_LISTENER = new ContextIssueListener();
    private AtomicReference<AuditIssueList> _lastCurrentAuditIssueList = new AtomicReference();
    private boolean _issueListenerAttached = false;
    private final Object _issueListenerMonitor = new Object();
    private DeclarativeGuiFactory _guiFactory = null;
    private DeclarativeViewFactory _viewFactory = null;
    private static DeclarativeSetupHookDataListener _sSetupHookDataListener = new DeclarativeSetupHookDataListener();
    private final XMLSourceNode _ideNode;
    private final Context _context;
    private static final Logger _LOGGER = Logger.getLogger(JDevXmlContext.class.getName());

    public JDevXmlContext(Context context) {
        this._context = context;
        Node ideNode = context.getNode();
        if (!(ideNode instanceof XMLSourceNode)) {
            throw new IllegalArgumentException("No JDev Node");
        }
        this._ideNode = (XMLSourceNode)ideNode;
        JDevXmlContext._setProjectWorkspace(this, context.getProject(), context.getWorkspace(), !context.getBoolean("Context.INTENTIONAL_NULL"));
        SchemaRegistryAddin.loadSchema((Element)this._ideNode);
        WeakNodeListenerProxy.attach((Node)this._ideNode, this._nodeListener);
    }

    @Deprecated
    public static JDevXmlContext getXmlContext(XMLSourceNode node, Project project) {
        if (node != null) {
            Context ideContext = Context.newIdeContext((Node)node);
            ideContext.setProject(project);
            return JDevXmlContext.getXmlContext(ideContext);
        }
        return null;
    }

    public static JDevXmlContext getXmlContext(Context ideContext) {
        return XMLSourceNode.getXmlContext(ideContext);
    }

    public static JDevXmlContext getXmlContextOrThrow(Context ideContext) throws Exception {
        return XMLSourceNode.getXmlContextOrThrow(ideContext);
    }

    public static Context createContext(JDevXmlContext xmlContext) {
        return JDevXmlContext.createContext(xmlContext, true);
    }

    public static Context createContext(JDevXmlContext xmlContext, boolean useSelection) {
        if (xmlContext != null) {
            return xmlContext.createContext(useSelection);
        }
        return null;
    }

    public Context createContext() {
        return this.createContext(true);
    }

    public Context createContext(boolean useSelection) {
        Element element;
        Context context = new Context((Node)this.getIdeDocument());
        context.setProject(this.getProject());
        context.setWorkspace(this.getWorkspace());
        if (useSelection && (element = this.createSelectionProxyElement()) != null) {
            context.setElement(element);
        }
        return context;
    }

    public static boolean hasXmlContextBeenCreated(Context ideContext) {
        XMLSourceNode node = JDevXmlContext._getXMLSourceNode(ideContext);
        if (node != null) {
            return node.hasXmlContextBeenCreated();
        }
        return false;
    }

    public boolean isUserEditable() {
        return super.isUserEditable() && !this.getIdeDocument().getAttributes().isSet(ElementAttributes.NON_EDITABLE);
    }

    public void showErrorMessage(String message, String title, Throwable t, Component parent) {
        if (!IdeUtil.isHeadless()) {
            super.showErrorMessage(message, title, t, parent);
        } else {
            _LOGGER.log(Level.WARNING, message);
        }
    }

    protected DomModel createSourceDomModel(XmlModel xmlModel) {
        DomModelPluginFactory pluginFactory = this.getIdeDocument().createDomModelPluginFactory(this, xmlModel);
        DomModel dom = DomModelFactory.createDomModel((DomModelContext)this, (DomModelPluginFactory)pluginFactory, (WhitespaceHandler)xmlModel.getWhitespaceHandler());
        return dom;
    }

    protected void initActions() {
        super.initActions();
        this.addAction((Action)((Object)new XmlGoToPropertiesAction(this.getTranslatedString("GO_TO_PROPERTIES_ACTION"))));
        this.addAction((Action)((Object)new SurroundAction()));
        this.addAction((Action)((Object)new ExplorerShowAsTopAction(this.getTranslatedString("EXPLORER.SHOW_AS_TOP"))));
        this.addAction((Action)((Object)new ExplorerShowRootAction(this.getTranslatedString("EXPLORER.SHOW_ROOT"))));
        this.addAction((Action)((Object)new ExplorerCollapseAllAction(this.getTranslatedString("EXPLORER.COLLAPSE_ALL_BELOW"))));
        this.addAction((Action)((Object)new ExplorerExpandAllAction(this.getTranslatedString("EXPLORER.EXPAND_ALL_BELOW"))));
    }

    public URL getURLForRelativePath(String relativePath) {
        URL resolvedURL = null;
        if (relativePath != null) {
            URL context = this.getIdeDocument().getURL();
            try {
                resolvedURL = new URL(context, relativePath);
                resolvedURL = URLFactory.copyURL((URL)resolvedURL);
            }
            catch (MalformedURLException e) {
                resolvedURL = null;
            }
        }
        return resolvedURL;
    }

    public String getRelativePathForURL(URL absoluteURL) {
        return URLFileSystem.toRelativeSpec((URL)absoluteURL, (URL)this.getIdeDocument().getURL());
    }

    public XmlModel getRelatedXmlModel(URL url) {
        try {
            Node node = NodeFactory.find((URL)url);
            if (node == null && URLFileSystem.exists((URL)url)) {
                node = NodeFactory.findOrCreate((URL)url);
            }
            if (node instanceof XMLSourceNode) {
                Context ideContext = this.createContext();
                ideContext.setNode(node);
                JDevXmlContext context = JDevXmlContext.getXmlContext(ideContext);
                if (context != null) {
                    return context.getModel();
                }
            }
        }
        catch (IllegalAccessException iae) {
            _LOGGER.log(Level.INFO, "IllegalAccessException encountered during getRelatedXmlModel", iae);
        }
        catch (InstantiationException ie) {
            _LOGGER.log(Level.INFO, "InstantiationException encountered during getRelatedXmlModel", ie);
        }
        catch (RuntimeException e) {
            _LOGGER.log(Level.INFO, "RuntimeException encountered during getRelatedXmlModel", e);
        }
        return null;
    }

    public XmlContextReference getXmlContextReference() {
        return new JDevXmlContextReference(this.createContext(false));
    }

    public IssueList getIssueList() {
        Object issueList = (IssueList)this._lastCurrentAuditIssueList.get();
        if (issueList == null) {
            issueList = new IssueListenerAttachingIssueList(this, super.getIssueList());
        } else if (issueList.isStale()) {
            issueList = super.getIssueList();
        }
        return issueList;
    }

    public XmlGui getActiveGui() {
        return this._activeGui;
    }

    public void guiReceivedEventHook(XmlGui gui, InputEvent event) {
        super.guiReceivedEventHook(gui, event);
        this.acquireActiveGui(gui);
    }

    public void acquireActiveGui(XmlGui newActiveGui) {
        _LOGGER.log(Level.FINER, "JDevXmlContext ActiveGui: acquire {0}", newActiveGui);
        XmlGui oldActiveGui = this._activeGui;
        this._activeGui = this.setActiveGui(newActiveGui, oldActiveGui);
        this.firePropertyChange("activeGui", oldActiveGui, this._activeGui);
    }

    public void releaseActiveGui(XmlGui deactivatingGui) {
        _LOGGER.log(Level.FINER, "JDevXmlContext ActiveGui: release {0}", deactivatingGui);
        XmlGui oldActiveGui = this._activeGui;
        if (oldActiveGui == deactivatingGui) {
            this._activeGui = this.setActiveGui(null, oldActiveGui);
            this.firePropertyChange("activeGui", oldActiveGui, this._activeGui);
        }
    }

    public static void showContextMenu(JDevViewHostedGui gui, MouseEvent event) {
        ContextMenu menu;
        View jdevView;
        if (gui != null && (jdevView = gui.getOwningJDevView()) != null && (menu = jdevView.getContextMenu()) != null) {
            menu.show(jdevView.getContext((EventObject)event));
        }
    }

    public XMLSourceNode getIdeDocument() {
        return this._ideNode;
    }

    public final Project getProject() {
        this._inferProjectWorkspaceIfNeeded();
        return this._project;
    }

    public final Workspace getWorkspace() {
        this._inferProjectWorkspaceIfNeeded();
        return this._workspace;
    }

    public final void reestablishContext(Context ideContext) {
        Project newProject = ideContext.getProject();
        Workspace newWorkspace = ideContext.getWorkspace();
        if (newProject == null) {
            newProject = this._project;
        }
        if (newWorkspace == null) {
            newWorkspace = this._workspace;
        }
        JDevXmlContext._setProjectWorkspace(this, newProject, newWorkspace, !ideContext.getBoolean("Context.INTENTIONAL_NULL"));
    }

    public Set getCurrentTechnologyKeys() {
        if (this._techKeys == null) {
            Project p = this.getProject();
            this._techKeys = this._getTechKeys(p);
        }
        return this._techKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeImpl() {
        Object object = this._softlyPinnedRelatedJDevXmlContextsLock;
        synchronized (object) {
            this._softlyPinnedRelatedJDevXmlContexts.clear();
        }
        this._detachFromProject();
        super.disposeImpl();
    }

    public Locale getLocale() {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        return mainWindow != null ? LocaleUtils.getDefaultableLocale((Component)mainWindow) : Locale.getDefault();
    }

    public Component getRootDocumentUIComponent() {
        return Ide.getMainWindow();
    }

    public Element createSelectionProxyElement() {
        if (this.getModel() == null || !this.getModel().isFullyInstantiated()) {
            return null;
        }
        return new XmlSelectionElement(this);
    }

    public TransactionToken createTransactionToken() {
        return TransactionMediator.getInstance().createToken();
    }

    public String toString() {
        return "JDevXmlContext@" + System.identityHashCode((Object)this) + "(" + this._ideNode + ", " + this._project + ", " + this._workspace + ")";
    }

    protected void modelAttachmentComplete() {
        super.modelAttachmentComplete();
        this.addUndoableEditListener(new JDevUndoHandler());
    }

    protected ResourceBundle createBundle() {
        return PaternalResourceBundle.getOrCreateCachedBundle((ResourceBundle)this.createBundle("oracle.bali.xml.gui.jdev.resource.JDevBundle"), (ResourceBundle)super.createBundle());
    }

    protected GrammarProvider createGrammarProvider() {
        return this.getIdeDocument().createGrammarProvider(this);
    }

    protected GrammarResolver createGrammarResolver() {
        return this.getIdeDocument().createGrammarResolver(this, this.getGrammarProvider());
    }

    protected VersionManager createVersionManager() {
        XMLSourceNode node = this.getIdeDocument();
        if (node instanceof VersionManagerCreator) {
            return ((VersionManagerCreator)node).createVersionManager((XmlContext)this);
        }
        return null;
    }

    protected List<BeanBaseRegistry> createBeanRegistries() {
        return this.getIdeDocument().createBeanRegistries(this);
    }

    protected AnnotationModel createAnnotationModel() {
        return this.getIdeDocument().createAnnotationModel(this);
    }

    protected AnnotationGrammar createAnnotationGrammar() {
        return this.getIdeDocument().createAnnotationGrammar(this);
    }

    protected AnnotationMetadataResolver createAnnotationMetadataResolver() {
        return this.getIdeDocument().createAnnotationMetadataResolver(this, this.createAnnotationMetadataProvider());
    }

    protected MetadataProvider createAnnotationMetadataProvider() {
        return this.getIdeDocument().createAnnotationMetadataProvider(this);
    }

    protected void deliverSetupEventAtXmlContextCreation() {
        _sSetupHookDataListener.registerPendingSetupHooks();
        super.deliverSetupEventAtXmlContextCreation();
    }

    protected void deliverSetupEventToHooksAddedAfterCreation() {
        _sSetupHookDataListener.registerPendingSetupHooks();
        super.deliverSetupEventToHooksAddedAfterCreation();
    }

    protected List<XmlViewFactory> getViewFactories() {
        LinkedList<XmlViewFactory> factories = new LinkedList<XmlViewFactory>();
        factories.addAll(super.getViewFactories());
        if (this._viewFactory == null) {
            this._viewFactory = new DeclarativeViewFactory(this);
        }
        factories.add(0, this._viewFactory);
        return factories;
    }

    protected List<XmlGuiFactory> getGuiFactories() {
        LinkedList<XmlGuiFactory> factories = new LinkedList<XmlGuiFactory>();
        factories.addAll(super.getGuiFactories());
        if (this._guiFactory == null) {
            this._guiFactory = new DeclarativeGuiFactory(this);
        }
        factories.add(0, this._guiFactory);
        return factories;
    }

    public DocumentScanner createDocumentScanner() {
        DocumentScannerFactory f = this.getIdeDocument().getDocumentScannerFactory(this.createContext(), this);
        return f.createDocumentScanner();
    }

    public Action createModelAction(String command, AbstractModel model) {
        if ("gotosource".equals(command)) {
            GotoSourceAction action = new GotoSourceAction(this.getTranslatedString("GO_TO_SOURCE_ACTION"));
            action.setModel(model);
            return action;
        }
        if (!DependencyUtils.DISABLE_XDF && "gotodeclaration".equals(command)) {
            XdfGoToDeclarationAction action = new XdfGoToDeclarationAction(this.getTranslatedString("GO_TO_DECLARATION_ACTION"));
            action.setModel(model);
            return action;
        }
        return super.createModelAction(command, model);
    }

    protected XmlPreferenceManager createPreferenceManager(String preferenceManagerName) {
        return JDevXmlPreferenceManager.getPreferenceManagerByName(preferenceManagerName);
    }

    protected void initOperations() {
        super.initOperations();
        this.getOperationManager().registerOperationFactory((OperationFactory)new JDevOperationFactory());
    }

    protected void postMenuPopulationHook(JMenu menu) {
        menu.putClientProperty("menu-is-sorted", Boolean.TRUE);
        if (Boolean.TRUE.equals(menu.getClientProperty(MENU_PROPERTY_REQUEST_AUTO_MNEUMONICS))) {
            this._recursivelySolve(menu);
        }
    }

    protected Object getServiceImpl(Object selector) {
        if ("oracle.bali.xml.model.services.VersionControlService".equals(selector)) {
            return JDevVersionControlService.getInstance();
        }
        return super.getServiceImpl(selector);
    }

    private void _setAuditIssueList(AuditIssueList issueList) {
        LOG.trace("setting issues of {0} to {1}", (Object)this, (Object)issueList);
        this._lastCurrentAuditIssueList.set(issueList);
        if (issueList != null && !issueList.isStale()) {
            this.fireIssueListChange();
        }
    }

    private void _recursivelySolve(JMenu menu) {
        MnemonicSolver solver = new MnemonicSolver(menu);
        solver.solve();
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component child = menu.getComponent(i);
            if (!(child instanceof JMenu)) continue;
            this._recursivelySolve((JMenu)child);
        }
    }

    private void _detachFromProject() {
        this._projectObserver = null;
    }

    private void _inferProjectWorkspaceIfNeeded() {
        if (this._guessingAllowed && (this._project == null || this._workspace == null)) {
            JDevXmlContext._setProjectWorkspace(this, this._project, this._workspace, this._guessingAllowed);
        }
    }

    private static void _setProjectWorkspace(JDevXmlContext context, Project project, Workspace workspace, boolean guessingOk) {
        context._guessingAllowed = guessingOk;
        if (guessingOk) {
            if (project == null && (project = JDevXmlContext._guessProject(context)) != null && workspace != null && !workspace.containsChild((Element)project)) {
                workspace = null;
            }
            if (workspace == null && project != null) {
                workspace = JDevXmlContext._guessWorkspace(context, project);
            }
        }
        context._setProjectAndAttachDetach(project, workspace != null);
        if (context._workspace != workspace) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "{0}: Workspace updated from {1} to {2}", new Object[]{context, context._workspace, workspace});
            }
            context._workspace = workspace;
        }
    }

    private static Project _guessProject(JDevXmlContext context) {
        Project guessedProject = null;
        Project activeProject = Ide.getActiveProject();
        if (activeProject != null && activeProject.containsChild((Element)context.getIdeDocument())) {
            guessedProject = activeProject;
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "{0}: JDevXmlContext forced to guess project (null project provided)", new Object[]{context});
        }
        return guessedProject;
    }

    private static Workspace _guessWorkspace(JDevXmlContext context, Project project) {
        Workspace guessedWorkspace = null;
        if (project != null) {
            Workspace activeWorkspace = Ide.getActiveWorkspace();
            if (activeWorkspace != null && activeWorkspace.containsChild((Element)project)) {
                guessedWorkspace = activeWorkspace;
            } else {
                Workspaces workspaces = Ide.getWorkspaces();
                if (workspaces != null) {
                    Iterator wsItor = workspaces.getChildren();
                    while (wsItor.hasNext()) {
                        Workspace ws;
                        Object next = wsItor.next();
                        if (!(next instanceof Workspace) || !(ws = (Workspace)next).containsChild((Element)project)) continue;
                        guessedWorkspace = ws;
                        break;
                    }
                }
            }
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "{0}: JDevXmlContext forced to guess workspace (null workspace provided)", new Object[]{context});
        }
        return guessedWorkspace;
    }

    private void _setProjectAndAttachDetach(Project newProject, boolean openProject) {
        if (newProject != this._project) {
            if (_LOGGER.isLoggable(Level.FINER)) {
                _LOGGER.log(Level.FINER, "{0}: Project updated from {1} to {2}", new Object[]{this, this._project, newProject});
            }
            Project old = this._project;
            this._detachFromProject();
            this._project = newProject;
            if (this._project != null) {
                ProjectObserver projectObserver = this._projectObserver = new ProjectObserver();
                Project project = this._project;
                if (projectObserver != null && project != null) {
                    project.attach((Observer)WeakListenerProxy.create(Observer.class, (Object)projectObserver, Project.class, (Object)project, (String)"detach"));
                }
            }
            this.firePropertyChange(PROPERTY_PROJECT, old, this._project);
        }
    }

    private Set _getTechKeys(Project p) {
        TechnologyScope scope;
        if (p != null && (scope = TechnologyScopeConfiguration.getInstance((PropertyStorage)p).getTechnologyScope()) != null && !scope.isEmpty()) {
            String[] keys = scope.getTechnologyKeys();
            int length = keys == null ? 0 : keys.length;
            HashSet<String> set = new HashSet<String>(length);
            for (int i = 0; i < length; ++i) {
                set.add(keys[i]);
            }
            return set;
        }
        return Collections.EMPTY_SET;
    }

    private static XMLSourceNode _getXMLSourceNode(Context ideContext) {
        Node node;
        if (ideContext != null && (node = ideContext.getNode()) instanceof XMLSourceNode) {
            return (XMLSourceNode)node;
        }
        return null;
    }

    protected void addAction(Action action) {
        if (this.getIdeDocument().supportsXmlContextAction(action)) {
            super.addAction(action);
        }
    }

    public final URL getURL() {
        return this.getIdeDocument().getURL();
    }

    public boolean supportsFeature(String feature) {
        if ("XMLEF_FEATURE.TRANSLATION_VALIDATION".equals(feature)) {
            return false;
        }
        return super.supportsFeature(feature);
    }

    public JDevXmlContext getAndSoftlyPinRelatedJDevXmlContext(Context relatedNodeIdeContext) {
        JDevXmlContext relatedXmlContext = JDevXmlContext.getXmlContext(relatedNodeIdeContext);
        this.softlyPinRelatedJDevXmlContext(relatedXmlContext);
        return relatedXmlContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void softlyPinRelatedJDevXmlContext(JDevXmlContext relatedXmlContext) {
        if (relatedXmlContext != null) {
            Object object = this._softlyPinnedRelatedJDevXmlContextsLock;
            synchronized (object) {
                boolean insertReferenceForThisContext = true;
                Iterator iter = this._softlyPinnedRelatedJDevXmlContexts.iterator();
                while (iter.hasNext()) {
                    SoftReference ref = (SoftReference)iter.next();
                    JDevXmlContext pinnedContext = (JDevXmlContext)((Object)ref.get());
                    if (pinnedContext == null || pinnedContext.isDisposed()) {
                        iter.remove();
                        continue;
                    }
                    if (pinnedContext != relatedXmlContext) continue;
                    insertReferenceForThisContext = false;
                }
                if (insertReferenceForThisContext) {
                    this._softlyPinnedRelatedJDevXmlContexts.add(new SoftReference<JDevXmlContext>(relatedXmlContext));
                }
            }
        }
    }

    private class ContextNodeListener
    extends NodeListener {
        private ContextNodeListener() {
        }

        public void nodeWillClose(NodeEvent e) {
            if (JDevXmlContext.this._nodeListener != null) {
                JDevXmlContext.this._nodeListener = null;
                _LOGGER.log(Level.FINER, "Disposing context due to nodeWillClose; context={0}", (Object)JDevXmlContext.this);
                JDevXmlContext.this.dispose();
            }
        }
    }

    private static class IssueListenerAttachingIssueList
    extends AbstractDelegatingIssueList {
        private final JDevXmlContext _xmlContext;
        private final IssueList _xmlModelInternalIssueList;

        public IssueListenerAttachingIssueList(JDevXmlContext xmlContext, IssueList xmlModelInternalIssueList) {
            this._xmlContext = xmlContext;
            this._xmlModelInternalIssueList = xmlModelInternalIssueList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IssueList getDelegateImpl() {
            AuditIssueList auditIssueList;
            Object delegate = this._xmlModelInternalIssueList;
            if (!this._xmlContext._issueListenerAttached) {
                Object object = this._xmlContext._issueListenerMonitor;
                synchronized (object) {
                    if (!this._xmlContext._issueListenerAttached) {
                        if (this._xmlContext.getWorkspace() != null) {
                            IssueList initialList = StatusManager.getStatusManager().addIssueListener(this._xmlContext.getURL(), this._xmlContext.getProject(), this._xmlContext.getWorkspace(), (IssueListener)_ISSUE_LISTENER, null);
                            this._xmlContext._lastCurrentAuditIssueList.set(new AuditIssueList(initialList));
                        }
                        this._xmlContext._issueListenerAttached = true;
                    }
                }
            }
            if ((auditIssueList = this._xmlContext._lastCurrentAuditIssueList.get()) != null && !auditIssueList.isStale()) {
                delegate = auditIssueList;
            }
            return delegate;
        }
    }

    private class JDevUndoHandler
    implements UndoableEditListener,
    PropertyChangeListener {
        public JDevUndoHandler() {
            JDevXmlContext.this.addPropertyChangeListener(this);
            this._resetTimestamp();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent event) {
            EditWrap wrapped = new EditWrap(event.getEdit());
            TransactionMediator.getInstance().addEdit(JDevXmlContext.this.getTransactionToken(), (Node)JDevXmlContext.this.getIdeDocument(), (UndoableEdit)((Object)wrapped));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activeGui".equals(evt.getPropertyName())) {
                this._resetTimestamp();
            }
        }

        private void _resetTimestamp() {
            JDevXmlContext.this._activeGuiTimestamp = System.currentTimeMillis();
        }
    }

    private static class DeclarativeSetupHookDataListener
    implements HookDataListener<DeclarativeSetupHookData> {
        private volatile boolean _attached = false;
        private ConcurrentLinkedQueue<DeclarativeSetupHookData> _pendingHookDataQueue = new ConcurrentLinkedQueue();

        private DeclarativeSetupHookDataListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerPendingSetupHooks() {
            if (!this._attached || !this._pendingHookDataQueue.isEmpty()) {
                DeclarativeSetupHookDataListener declarativeSetupHookDataListener = this;
                synchronized (declarativeSetupHookDataListener) {
                    if (!this._attached) {
                        DeclarativeSetupHookSupport.getInstance().addHookDataListener(this);
                        this._attached = true;
                    }
                    DeclarativeSetupHookData hookData = this._pendingHookDataQueue.poll();
                    while (hookData != null) {
                        XmlContextSetupHook hook = hookData.createSetupHookInstance();
                        if (hook != null) {
                            XmlContext.registerSetupHook((XmlContextSetupHook)hook);
                        }
                        hookData = this._pendingHookDataQueue.poll();
                    }
                }
            }
        }

        @Override
        public void hookDataAdded(DeclarativeSetupHookData hookData) {
            this._pendingHookDataQueue.add(hookData);
        }
    }

    private static class AuditIssueList
    extends AbstractDelegatingIssueList {
        private IssueList _auditIssueList;
        private List<Issue> _wrappedIssues;

        public AuditIssueList(IssueList auditIssueList) {
            this._auditIssueList = auditIssueList;
            int size = this._auditIssueList.size();
            this._wrappedIssues = new ArrayList<Issue>(size);
            for (int i = 0; i < size; ++i) {
                this._wrappedIssues.add(new AuditIssueWrapper(this._auditIssueList.getIssueAt(i)));
            }
        }

        public int size() {
            return this._wrappedIssues.size();
        }

        public Issue getIssueAt(int index) {
            return this._wrappedIssues.get(index);
        }

        public Iterator<Issue> iterator() {
            return this._wrappedIssues.iterator();
        }

        protected IssueList getDelegateImpl() {
            return this._auditIssueList;
        }
    }

    private class ProjectObserver
    implements Observer {
        private ProjectObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() == UpdateMessage.PROPERTY_SET && change.containsProperty("technologyScope")) {
                JDevXmlContext.this._techKeys = JDevXmlContext.this._getTechKeys(JDevXmlContext.this.getProject());
            }
        }
    }

    private static class ContextIssueListener
    implements IssueListener {
        private ContextIssueListener() {
        }

        public void statusChanged(URL file, Project project, Workspace workspace, final IssueList issues) {
            XMLSourceNode xmlSourceNode = (XMLSourceNode)((Object)ModelUtil.as((Object)NodeFactory.find((URL)file), XMLSourceNode.class));
            if (xmlSourceNode == null) {
                return;
            }
            final Context ideContext = Context.newIdeContext((Node)xmlSourceNode);
            ideContext.setProject(project);
            ideContext.setWorkspace(workspace);
            if (JDevXmlContext.hasXmlContextBeenCreated(ideContext)) {
                xmlSourceNode.runUnderWriteLock(new Runnable(){

                    @Override
                    public void run() {
                        JDevXmlContext jdevXmlContext;
                        if (JDevXmlContext.hasXmlContextBeenCreated(ideContext) && (jdevXmlContext = XMLSourceNode.getXmlContext(ideContext)) != null) {
                            jdevXmlContext._setAuditIssueList(new AuditIssueList(issues));
                        }
                    }
                });
            }
        }
    }

    private static class AuditIssueWrapper
    implements Issue {
        private Issue _delegate;

        public AuditIssueWrapper(Issue delegate) {
            this._delegate = delegate;
        }

        public Object getConstruct() {
            return this._delegate.getConstruct();
        }

        public String getMessage() {
            return this._delegate.getMessage();
        }

        public String getHtmlMessage() {
            return this._delegate.getHtmlMessage();
        }

        public Severity getSeverity() {
            return this._delegate.getSeverity();
        }

        public int getOffset() {
            return this._delegate.getOffset();
        }

        public int getLength() {
            return this._delegate.getLength();
        }

        public boolean hasTransforms() {
            return this._delegate.hasTransforms();
        }

        public List<? extends Action> getTransforms() {
            return this._delegate.getTransforms();
        }

        public String toString() {
            return "XmlStatusIssueWrapper:" + this._delegate.toString();
        }
    }

    private static class EditWrap
    extends UndoableEditWrapper {
        private final UndoableEdit _realEdit;
        private final long _editTimeStamp = System.currentTimeMillis();

        public EditWrap(UndoableEdit realEdit) {
            this._realEdit = realEdit;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            JDevXmlContext context = this._getContext();
            if (context == null) {
                return false;
            }
            if (context._activeGuiTimestamp > this._editTimeStamp) {
                return false;
            }
            if (anEdit.getClass() == ((Object)((Object)this)).getClass()) {
                anEdit = ((EditWrap)((Object)anEdit))._realEdit;
            }
            return super.addEdit(anEdit);
        }

        public String toString() {
            return "EditWrap(" + this.getBaseEdit() + ")";
        }

        protected UndoableEdit getBaseEdit() {
            return this._realEdit;
        }

        private JDevXmlContext _getContext() {
            DomModelContext context;
            DomModel domModel;
            if (this._realEdit instanceof DomModelHolder && (domModel = ((DomModelHolder)this._realEdit).getDomModel()) != null && (context = domModel.getContext()) instanceof JDevXmlContext) {
                return (JDevXmlContext)context;
            }
            return null;
        }
    }
}

