/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.wizard;

import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.xml.addin.wizard.SchemaBasedModelListener;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;

public final class SchemaBasedModel {
    private final ListenerManager _lManager = new ListenerManager();
    private int _depth;
    private Grammar _grammar;
    private ElementDef _rootElement;
    private String _filename;
    private URL _dirURL;
    private boolean _reqElems;
    private boolean _useSchemas;
    private GrammarProvider _grammars;
    private String _encoding;

    public URL getDirectoryURL() {
        return this._dirURL;
    }

    public void setDirectoryURL(URL dirURL) {
        this._dirURL = dirURL;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        boolean needsFiringEvent = false;
        if (this._filename == null || !this._filename.equals(filename)) {
            needsFiringEvent = true;
        }
        this._filename = filename;
        if (needsFiringEvent) {
            this.fireFilenameChangedEvent();
        }
    }

    public boolean getUsePredefinedSchemas() {
        return this._useSchemas;
    }

    public void setUsePredefinedSchemas(boolean useSchemas) {
        boolean needsFiringEvent = false;
        if (this._useSchemas != useSchemas) {
            needsFiringEvent = true;
        }
        this._useSchemas = useSchemas;
        if (needsFiringEvent) {
            this.fireUsePredefinedSchemasChangedEvent();
        }
    }

    public GrammarProvider getGrammars() {
        return this._grammars;
    }

    public void setGrammars(GrammarProvider grammars) {
        boolean needsFiringEvent = false;
        if (this._grammars != grammars) {
            needsFiringEvent = true;
        }
        this._grammars = grammars;
        if (needsFiringEvent) {
            this.fireGrammarsChangedEvent();
        }
    }

    public int getDepth() {
        return this._depth;
    }

    public void setDepth(int depth) {
        this._depth = depth;
    }

    public ElementDef getDocumentRoot() {
        return this._rootElement;
    }

    public void setDocumentRoot(ElementDef elemDef) {
        this._rootElement = elemDef;
    }

    public Grammar getGrammar() {
        return this._grammar;
    }

    public void setGrammar(Grammar grammar) {
        this._grammar = grammar;
    }

    public boolean getRequiredElements() {
        return this._reqElems;
    }

    public void setRequiredElements(boolean reqElements) {
        this._reqElems = reqElements;
    }

    public String getEncoding() {
        if (this._encoding == null) {
            this._encoding = "UTF-8";
        }
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void addListener(SchemaBasedModelListener l) {
        this._lManager.addListener((EventListener)l);
    }

    public void removeListener(SchemaBasedModelListener l) {
        this._lManager.removeListener((EventListener)l);
    }

    protected void fireFilenameChangedEvent() {
        Enumeration listeners = this._lManager.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                SchemaBasedModelListener l = (SchemaBasedModelListener)listeners.nextElement();
                l.filenameChanged();
            }
        }
    }

    protected void fireUsePredefinedSchemasChangedEvent() {
        Enumeration listeners = this._lManager.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                SchemaBasedModelListener l = (SchemaBasedModelListener)listeners.nextElement();
                l.usePredefinedSchemasChanged();
            }
        }
    }

    protected void fireGrammarsChangedEvent() {
        Enumeration listeners = this._lManager.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                SchemaBasedModelListener l = (SchemaBasedModelListener)listeners.nextElement();
                l.grammarsChanged();
            }
        }
    }
}

