/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.CurrentScreenBuffer;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.PreviousLinesBuffer;
import oracle.dbtools.raptor.timesten.grid.shell.swing.TimesTenShellComponent;

public class TimestenEmulator {
    private static Logger logger = Logger.getLogger(TimestenEmulator.class.getName());
    private boolean runningCommand = false;
    private InputStream inputStream;
    private int availableCharacters;
    private int currentBufferPossition;
    private TimesTenShellComponent terminalPanel;
    private int x;
    private int y;
    private byte[] b2 = new byte[2];
    private byte[] b1 = new byte[1];
    private int columnPosition;
    private int rowPosition = 0;
    private final int NEW_LINE = 10;
    private final int BELL = 7;
    private final int BACKSPACE = 8;
    private final int TAB = 9;
    private final int VERTICAL_TAB = 11;
    private final int NEW_PAGE = 12;
    private final int CARRIAGE_RETURN = 13;
    private final int ESC = 27;
    private final int DELETE = 127;
    private final int SHIFT_IN = 15;
    private final int SHIFT_OUT = 14;
    private final int EMPTY_BYTE = 0;
    private final int LEFT = 8;
    private final int DOWN = 10;
    private CurrentScreenBuffer screenBuffer;
    byte[] buffer = new byte[1024];
    private List<Runnable> runOnCloseList;
    private int region_y2;
    private int region_y1;
    private OutputStream outputStream;
    private PreviousLinesBuffer previousLinesBuffer;

    public TimestenEmulator(TimesTenShellComponent timesTenShellComponent, InputStream inputStream, OutputStream outputStream, CurrentScreenBuffer currentScreenBuffer, PreviousLinesBuffer previousLinesBuffer) {
        this.terminalPanel = timesTenShellComponent;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.screenBuffer = currentScreenBuffer;
        this.previousLinesBuffer = previousLinesBuffer;
        this.starReading();
        this.runOnCloseList = new LinkedList<Runnable>();
    }

    public void addRunOnClose(Runnable runnable) {
        this.runOnCloseList.add(runnable);
    }

    private void starReading() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                TimestenEmulator.this.startStuff();
            }
        };
        thread.start();
    }

    private void loadBuffer() throws IOException {
        this.availableCharacters = 0;
        this.currentBufferPossition = 0;
        this.availableCharacters = this.inputStream.read(this.buffer, this.currentBufferPossition, this.buffer.length - this.currentBufferPossition);
        if (this.availableCharacters < 0) {
            this.availableCharacters = 0;
            for (Runnable runnable : this.runOnCloseList) {
                runnable.run();
            }
            throw new IOException("Stream has been closed.");
        }
    }

    private byte getNextByte() throws IOException {
        if (this.availableCharacters == 0) {
            this.loadBuffer();
        }
        byte by = this.buffer[this.currentBufferPossition];
        ++this.currentBufferPossition;
        --this.availableCharacters;
        return by;
    }

    int getASCII(int n) throws IOException {
        if (this.availableCharacters == 0) {
            this.loadBuffer();
        }
        if (n > this.availableCharacters) {
            n = this.availableCharacters;
        }
        int n2 = n;
        while (n > 0) {
            byte by;
            if (32 <= (by = this.buffer[this.currentBufferPossition++]) && by <= 127) {
                --this.availableCharacters;
                --n;
                continue;
            }
            --this.currentBufferPossition;
            break;
        }
        return n2 - n;
    }

    protected void cursor_down() {
        this.terminalPanel.drawCursor();
        this.calculateColumnAndRowPosition();
        this.screenBuffer.newLine(this.rowPosition);
        this.y += this.terminalPanel.getCharHeight();
        this.setCursorPosition(this.x, this.y);
        this.calculateSpace();
    }

    private void carriageReturn() {
        this.terminalPanel.cleanArea(this.x, this.y, this.terminalPanel.getCharWidth(), this.terminalPanel.getCharHeight());
        this.terminalPanel.redraw(this.x, this.y - this.terminalPanel.getCharHeight(), this.terminalPanel.getCharWidth(), this.terminalPanel.getCharHeight());
        this.x = 0;
    }

    public void calculateSpace() {
        if (this.x >= this.terminalPanel.getCharWidth() * this.terminalPanel.getColumns()) {
            this.x = 0;
            this.y += this.terminalPanel.getCharHeight();
        }
        if (this.y > this.region_y2 * this.terminalPanel.getCharHeight()) {
            while (this.y > this.region_y2 * this.terminalPanel.getCharHeight()) {
                this.y -= this.terminalPanel.getCharHeight();
                this.screenBuffer.scrollUp(1);
                this.previousLinesBuffer.appendLine(this.screenBuffer.getFirstLine());
            }
            int n = this.terminalPanel.getCharWidth();
            int n2 = this.terminalPanel.getCharHeight();
            this.terminalPanel.drawCursor();
            this.terminalPanel.scrollArea(0, this.region_y1 * n2, this.terminalPanel.getTerminalWidth(), (this.region_y2 - this.region_y1) * n2, 0, -n2);
            this.terminalPanel.cleanArea(0, this.y - n2, this.terminalPanel.getTerminalWidth(), this.y);
            this.terminalPanel.redraw(0, 0, this.terminalPanel.getTerminalWidth(), this.region_y2 * n);
            this.setCursorPosition(this.x, this.y);
        }
    }

    public void reset() {
        this.region_y1 = 0;
        this.region_y2 = this.terminalPanel.getRows();
    }

    protected void arrowLeft() {
        this.terminalPanel.drawCursor();
        this.x -= this.terminalPanel.getCharWidth();
        if (this.x < 0) {
            this.y -= this.terminalPanel.getCharHeight();
            this.x = this.terminalPanel.getTerminalWidth() - this.terminalPanel.getCharWidth();
        }
        this.setCursorPosition(this.x, this.y);
    }

    protected void arrowDown() {
        this.terminalPanel.drawCursor();
        this.y += this.terminalPanel.getCharHeight();
        this.setCursorPosition(this.x, this.y);
        this.calculateSpace();
    }

    protected void change_scroll_region(int n, int n2) {
        this.region_y1 = n;
        this.region_y2 = n2;
    }

    protected void parm_down_cursor(int n) {
        this.terminalPanel.drawCursor();
        this.y += n * this.terminalPanel.getCharHeight();
        this.setCursorPosition(this.x, this.y);
    }

    protected void parm_up_cursor(int n) {
        this.terminalPanel.drawCursor();
        this.y -= n * this.terminalPanel.getCharHeight();
        this.setCursorPosition(this.x, this.y);
        this.previousLinesBuffer.removeLines(n);
    }

    protected void parm_left_cursor(int n) {
        this.terminalPanel.drawCursor();
        this.x -= n * this.terminalPanel.getCharWidth();
        this.setCursorPosition(this.x, this.y);
    }

    protected void parm_right_cursor(int n) {
        this.terminalPanel.drawCursor();
        this.x += n * this.terminalPanel.getCharWidth();
        this.setCursorPosition(this.x, this.y);
    }

    protected void scroll_reverse() {
        int n = this.terminalPanel.getCharWidth();
        int n2 = this.terminalPanel.getCharHeight();
        int n3 = this.terminalPanel.getCharWidth() * this.terminalPanel.getColumns();
        int n4 = this.terminalPanel.getCharHeight() * this.terminalPanel.getRows();
        this.terminalPanel.drawCursor();
        this.terminalPanel.scrollArea(0, (this.region_y1 - 1) * n2, n3, (this.region_y2 - this.region_y1) * n2, 0, n2);
        this.terminalPanel.cleanArea(this.x, this.y - n2, n3, this.y);
        this.terminalPanel.redraw(0, 0, n3, n4 - n2);
        this.screenBuffer.scrollDown(Math.abs(this.region_y2 - this.region_y1) / n2);
        this.terminalPanel.drawCursor();
    }

    protected void scroll_forward() {
        int n = this.terminalPanel.getCharWidth();
        int n2 = this.terminalPanel.getCharHeight();
        int n3 = this.terminalPanel.getCharWidth() * this.terminalPanel.getColumns();
        int n4 = this.terminalPanel.getCharHeight() * this.terminalPanel.getRows();
        this.terminalPanel.drawCursor();
        this.terminalPanel.scrollArea(0, (this.region_y1 - 1) * n2, n3, (this.region_y2 - this.region_y1 + 1) * n2, 0, -n2);
        this.terminalPanel.cleanArea(0, this.region_y2 * n2 - n2, n3, this.region_y2 * n2);
        this.terminalPanel.redraw(0, (this.region_y1 - 1) * n2, n3, (this.region_y2 - this.region_y1 + 1) * n2);
        this.screenBuffer.scrollUp(Math.abs(this.region_y2 - this.region_y1) / n2);
        this.terminalPanel.drawCursor();
    }

    void pushChar(byte by) {
        ++this.availableCharacters;
        this.buffer[--this.currentBufferPossition] = by;
    }

    protected void cursor_address(int n, int n2) {
        this.terminalPanel.drawCursor();
        this.x = (n2 - 1) * this.terminalPanel.getCharWidth();
        this.y = n * this.terminalPanel.getCharHeight();
        this.setCursorPosition(this.x, this.y);
    }

    protected void cleanEndOfLine() {
        int n = this.terminalPanel.getCharHeight();
        int n2 = this.terminalPanel.getCharWidth();
        this.terminalPanel.drawCursor();
        this.terminalPanel.cleanArea(this.x, this.y - n, this.terminalPanel.getTerminalWidth(), n);
        this.terminalPanel.redraw(this.x, this.y - n, this.terminalPanel.getTerminalWidth() - this.x, n);
        this.calculateColumnAndRowPosition();
        this.screenBuffer.cleanRestOfLine(this.rowPosition, this.columnPosition);
        this.terminalPanel.drawCursor();
    }

    protected void clr_bol() {
        int n = this.terminalPanel.getCharHeight();
        int n2 = this.terminalPanel.getCharWidth();
        this.terminalPanel.drawCursor();
        this.terminalPanel.cleanArea(0, this.y - n, this.x, this.y);
        this.terminalPanel.redraw(0, this.y - n, this.x, n);
        this.terminalPanel.drawCursor();
    }

    protected void clearAllScreen() {
        int n = this.terminalPanel.getCharHeight();
        int n2 = this.terminalPanel.getCharWidth();
        this.terminalPanel.drawCursor();
        this.terminalPanel.cleanArea(this.x, this.y - n, this.terminalPanel.getTerminalWidth(), this.terminalPanel.getTerminalHeight());
        this.terminalPanel.redraw(this.x, this.y - n, this.terminalPanel.getTerminalWidth() - this.x, this.terminalPanel.getTerminalHeight() - this.y + n);
        this.screenBuffer.clearBuffer();
        this.terminalPanel.drawCursor();
    }

    protected void tab() {
        this.terminalPanel.drawCursor();
        this.x = (this.x / this.terminalPanel.getCharWidth() / 8 + 1) * 8 * this.terminalPanel.getCharWidth();
        if (this.x >= this.terminalPanel.getTerminalWidth()) {
            this.x = 0;
            this.y += this.terminalPanel.getCharHeight();
        }
        this.setCursorPosition(this.x, this.y);
    }

    protected void draw_text() throws IOException {
        int n;
        int n2;
        this.calculateSpace();
        int n3 = this.x;
        int n4 = this.y;
        byte by = this.getNextByte();
        this.terminalPanel.drawCursor();
        if ((by & 0x80) != 0) {
            this.terminalPanel.cleanArea(this.x, this.y - this.terminalPanel.getCharHeight(), this.x + this.terminalPanel.getCharWidth() * 2, this.y);
            this.b2[0] = by;
            this.b2[1] = this.getNextByte();
            String string = new String(this.b2, 0, 2, "UTF8");
            this.terminalPanel.drawText(string, this.x, this.y);
            this.calculateColumnAndRowPosition();
            this.screenBuffer.insertString(string, this.rowPosition, this.columnPosition);
            this.x += this.terminalPanel.getCharWidth();
            this.x += this.terminalPanel.getCharWidth();
            n2 = this.terminalPanel.getCharWidth() * 2;
            n = this.terminalPanel.getCharHeight();
        } else {
            this.pushChar(by);
            int n5 = this.terminalPanel.getColumns() - this.x / this.terminalPanel.getCharWidth();
            int n6 = this.getASCII(n5);
            if (n6 != 0) {
                this.terminalPanel.cleanArea(this.x, this.y - this.terminalPanel.getCharHeight(), this.x + n6 * this.terminalPanel.getCharWidth(), this.terminalPanel.getCharHeight());
                this.terminalPanel.drawBytes(this.buffer, this.currentBufferPossition - n6, n6, this.x, this.y);
                this.calculateColumnAndRowPosition();
                try {
                    this.screenBuffer.insertByteArray(this.buffer, this.currentBufferPossition - n6, n6, this.rowPosition, this.columnPosition);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else {
                n6 = 1;
                this.terminalPanel.cleanArea(this.x, this.y - this.terminalPanel.getCharHeight(), this.x + n6 * this.terminalPanel.getCharWidth(), this.y);
                this.b1[0] = this.getNextByte();
                this.terminalPanel.drawBytes(this.b1, 0, n6, this.x, this.y);
                this.calculateColumnAndRowPosition();
                this.screenBuffer.insertByteArray(this.b1, 0, n6, this.rowPosition, this.columnPosition);
            }
            this.x += this.terminalPanel.getCharWidth() * n6;
            n2 = this.terminalPanel.getCharWidth() * n6;
            n = this.terminalPanel.getCharHeight();
        }
        this.terminalPanel.redraw(n3, n4 - this.terminalPanel.getCharHeight(), n2, n);
        this.setCursorPosition(this.x, this.y);
    }

    public void startStuff() {
        this.reset();
        int[] nArray = new int[10];
        int n = 0;
        this.x = 0;
        this.y = this.terminalPanel.getCharHeight();
        try {
            block13: while (true) {
                int n2;
                if ((n2 = this.getNextByte()) == 0) {
                    continue;
                }
                if (n2 == 27) {
                    n2 = this.getNextByte();
                    if (n2 == 77) {
                        this.scroll_reverse();
                        continue;
                    }
                    if (n2 == 68) {
                        this.scroll_forward();
                        continue;
                    }
                    if (n2 == 55) {
                        this.save_cursor();
                        continue;
                    }
                    if (n2 == 40) {
                        n2 = this.getNextByte();
                        if (n2 == 66) {
                            n2 = this.getNextByte();
                            if (n2 == 27) {
                                n2 = this.getNextByte();
                                if (n2 == 41) {
                                    n2 = this.getNextByte();
                                    if (n2 == 48) {
                                        this.ena_acs();
                                        continue;
                                    }
                                    this.pushChar((byte)48);
                                } else {
                                    this.pushChar((byte)41);
                                }
                            } else {
                                this.pushChar((byte)27);
                            }
                        } else {
                            this.pushChar((byte)66);
                        }
                    }
                    if (n2 == 62) {
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        n2 = this.getNextByte();
                        this.reset_2string();
                        continue;
                    }
                    if (n2 != 91) {
                        System.out.print("@11: " + new Character((char)n2) + "[" + Integer.toHexString(n2 & 0xFF) + "]");
                        this.pushChar((byte)n2);
                        continue;
                    }
                    n = 0;
                    nArray[n] = 0;
                    int n3 = 0;
                    while (true) {
                        if ((n2 = this.getNextByte()) == 59) {
                            if (n3 <= 0) continue;
                            nArray[++n] = 0;
                            n3 = 0;
                            continue;
                        }
                        if (48 > n2 || n2 > 57) break;
                        nArray[n] = nArray[n] * 10 + (n2 - 48);
                        ++n3;
                    }
                    this.pushChar((byte)n2);
                    n2 = this.getNextByte();
                    if (n2 == 109) {
                        if (n3 == 0 && n == 0) {
                            n2 = this.getNextByte();
                            if (n2 == 15) {
                                this.exit_attribute_mode();
                                continue;
                            }
                            this.exit_underline_mode();
                            this.resetAllAttributes();
                            this.pushChar((byte)n2);
                            continue;
                        }
                        int n4 = 0;
                        while (true) {
                            if (n4 > n) continue block13;
                            switch (nArray[n4]) {
                                case 0: {
                                    this.resetAllAttributes();
                                    break;
                                }
                                case 1: {
                                    this.enter_bold_mode();
                                    break;
                                }
                                case 2: {
                                    System.out.println("DIM");
                                    break;
                                }
                                case 4: {
                                    this.enter_underline_mode();
                                    break;
                                }
                                case 5: {
                                    System.out.println("BLink");
                                    break;
                                }
                                case 8: {
                                    System.out.println("HIDDEN");
                                    break;
                                }
                                case 7: {
                                    this.setReverseMode(true);
                                    break;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.terminalPanel.setTerminalColor(nArray[n4]);
                                    break;
                                }
                            }
                            ++n4;
                        }
                    }
                    if (n2 == 114) {
                        this.change_scroll_region(nArray[0], nArray[1]);
                        continue;
                    }
                    if (n2 == 72) {
                        if (n3 == 0 && n == 0) {
                            nArray[1] = 1;
                            nArray[0] = 1;
                        }
                        this.cursor_address(nArray[0], nArray[1]);
                        continue;
                    }
                    if (n2 == 66) {
                        this.parm_down_cursor(nArray[0]);
                        continue;
                    }
                    if (n2 == 68) {
                        this.parm_left_cursor(nArray[0]);
                        continue;
                    }
                    if (n2 == 67) {
                        if (n3 == 0 && n == 0) {
                            nArray[0] = 1;
                        }
                        this.parm_right_cursor(nArray[0]);
                        continue;
                    }
                    if (n2 == 75) {
                        if (n3 == 0 && n == 0) {
                            this.cleanEndOfLine();
                            continue;
                        }
                        this.clr_bol();
                        continue;
                    }
                    if (n2 == 74) {
                        this.clearAllScreen();
                        continue;
                    }
                    if (n2 == 65) {
                        if (n3 == 0 && n == 0) {
                            nArray[0] = 1;
                        }
                        this.parm_up_cursor(nArray[0]);
                        continue;
                    }
                    if (n2 == 63) {
                        n2 = this.getNextByte();
                        if (n2 == 49) {
                            n2 = this.getNextByte();
                            if (n2 == 108 || n2 == 104 ? (n2 = this.getNextByte()) == 27 && ((n2 = this.getNextByte()) == 62 || n2 == 61) : n2 == 104 && (n2 = this.getNextByte()) == 27 && (n2 = (int)this.getNextByte()) == 61) {
                                continue;
                            }
                        } else if (n2 == 55) {
                            n2 = this.getNextByte();
                            if (n2 == 104 || n2 == 108) continue;
                            this.pushChar((byte)n2);
                            n2 = 55;
                        }
                    }
                    if (n2 == 104) continue;
                    System.out.println("unknown " + Integer.toHexString(n2 & 0xFF) + " " + new Character((char)n2) + ", " + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ",intargi=" + n);
                    continue;
                }
                if (n2 == 7) continue;
                if (n2 == 9) {
                    this.tab();
                    continue;
                }
                if (n2 == 15 || n2 == 14) continue;
                if (n2 == 13) {
                    this.carriageReturn();
                    continue;
                }
                if (n2 == 8) {
                    this.arrowLeft();
                    continue;
                }
                if (n2 == 10) {
                    this.cursor_down();
                    continue;
                }
                if (n2 == 10) continue;
                this.pushChar((byte)n2);
                this.draw_text();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Shell has close the stream ", iOException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    protected void enter_underline_mode() {
        this.terminalPanel.setUnderline(true);
    }

    protected void setReverseMode(boolean bl) {
        this.terminalPanel.setReverse(bl);
    }

    protected void resetAllAttributes() {
        this.terminalPanel.resetAllAttributes();
    }

    protected void exit_underline_mode() {
        this.terminalPanel.setUnderline(false);
    }

    private void save_cursor() {
    }

    private void ena_acs() {
    }

    private void reset_2string() {
    }

    private void exit_attribute_mode() {
        this.terminalPanel.resetAllAttributes();
    }

    private void enter_bold_mode() {
        this.terminalPanel.setBold();
    }

    public synchronized void executeStatement(String string) {
        try {
            this.outputStream.write(string.getBytes());
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setCursorPosition(int n, int n2) {
        this.terminalPanel.setCursor(n, n2);
        this.terminalPanel.drawCursor();
    }

    private void calculateColumnAndRowPosition() {
        this.columnPosition = this.x / this.terminalPanel.getCharWidth();
        this.rowPosition = (this.y - this.terminalPanel.getCharHeight()) / this.terminalPanel.getCharHeight();
    }
}

