/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import javax.swing.Icon;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public class AbstractNode
extends DefaultContainer {
    private String shortLabel;
    private String longLabel;
    private boolean mayHaveChildren;
    private Icon icon;
    private static final Icon warningIcon = OracleIcons.getIcon((String)"overlay/warning.png");
    protected OverlayIcon overlayWarningIcon;
    protected boolean showOverlayIcon;
    private static final AbstractNode NODE_DOESNT_EXIST = new AbstractNode();
    private NodeType type;
    private AbstractNode parentNode;

    public AbstractNode(String string, boolean bl, Icon icon, NodeType nodeType) {
        this(string, string, bl, icon, false, nodeType, null);
    }

    public AbstractNode(String string, boolean bl, Icon icon, NodeType nodeType, AbstractNode abstractNode) {
        this(string, string, bl, icon, false, nodeType, abstractNode);
    }

    public AbstractNode(String string, boolean bl, Icon icon, boolean bl2, NodeType nodeType) {
        this(string, string, bl, icon, bl2, nodeType, null);
    }

    public AbstractNode(String string, String string2, boolean bl, Icon icon, boolean bl2, NodeType nodeType, AbstractNode abstractNode) {
        this.shortLabel = string;
        this.longLabel = string2;
        this.mayHaveChildren = bl;
        this.icon = icon;
        this.showOverlayIcon = bl2;
        this.type = nodeType;
        this.parentNode = abstractNode;
        this.overlayWarningIcon = new OverlayIcon(icon, warningIcon);
    }

    public AbstractNode() {
    }

    public boolean mayHaveChildren() {
        return this.mayHaveChildren;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    public String getLongLabel() {
        return this.longLabel;
    }

    public Icon getIcon() {
        return this.showOverlayIcon ? this.overlayWarningIcon : this.icon;
    }

    public boolean isMayHaveChildren() {
        return this.mayHaveChildren;
    }

    public void setMayHaveChildren(boolean bl) {
        this.mayHaveChildren = bl;
    }

    public void setShortLabel(String string) {
        this.shortLabel = string;
    }

    public void setLongLabel(String string) {
        this.longLabel = string;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setType(NodeType nodeType) {
        this.type = nodeType;
    }

    public AbstractNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(AbstractNode abstractNode) {
        this.parentNode = abstractNode;
    }

    public void setShowOverlayIcon(boolean bl) {
        this.showOverlayIcon = bl;
    }

    protected boolean hasNode(String string) {
        return !((Object)((Object)this.getNode(string))).equals((Object)NODE_DOESNT_EXIST);
    }

    public AbstractNode getNode(String string) {
        for (Object e : this._children) {
            AbstractNode abstractNode = (AbstractNode)((Object)e);
            if (!abstractNode.getShortLabel().equals(string)) continue;
            return abstractNode;
        }
        return NODE_DOESNT_EXIST;
    }

    public void addChild(AbstractNode abstractNode) {
        if (!this.hasNode(abstractNode.getShortLabel())) {
            this.add((Element)abstractNode, true);
        }
    }

    public void removeChild(AbstractNode abstractNode) {
        if (this.hasNode(abstractNode.getShortLabel())) {
            this.remove((Element)abstractNode, true);
        }
    }

    public void removeChild(String string) {
        if (this.hasNode(string)) {
            this.remove((Element)this.getNode(string), true);
        }
    }

    public boolean isGridNode() {
        return this.type == NodeType.GRID_NODE;
    }

    public boolean isDatabaseNode() {
        return this.type == NodeType.DB_NODE;
    }

    public boolean isDatabaseFolderNode() {
        return this.type == NodeType.DB_FOLDER_NODE;
    }

    public boolean isDBDefNode() {
        return this.type == NodeType.DB_DEF_NODE;
    }

    public boolean isConnectableNode() {
        return this.type == NodeType.CONN_NODE;
    }

    public boolean isConnectableFolderNode() {
        return this.type == NodeType.DIR_CONN_FOLDER_NODE || this.type == NodeType.CS_CONN_FOLDER_NODE;
    }

    public boolean isDirConnectableFolderNode() {
        return this.type == NodeType.DIR_CONN_FOLDER_NODE;
    }

    public boolean isCSConnectableFolderNode() {
        return this.type == NodeType.CS_CONN_FOLDER_NODE;
    }

    public boolean isDBDefFolderNode() {
        return this.type == NodeType.DBDEF_FOLDER_NODE;
    }

    public boolean isInstanceFolderNode() {
        return this.type == NodeType.INSTANCE_FOLDER_NODE;
    }

    public boolean isInstanceNode() {
        return this.type == NodeType.INSTANCE_NODE;
    }

    public boolean isHostNode() {
        return this.type == NodeType.HOST_NODE;
    }

    public boolean isFolderNode() {
        return this.isHostFolderNode() || this.isConnectableFolderNode() || this.isDatabaseFolderNode() || this.isPGFolderNode() || this.isInstallationFolderNode() || this.isInstanceFolderNode() || this.type == NodeType.DBDEF_FOLDER_NODE || this.type == NodeType.MODEL_FOLDER_NODE || this.type == NodeType.BACKUP_FOLDER_NODE || this.type == NodeType.EXPORT_FOLDER_NODE || this.type == NodeType.REPOSITORY_FOLDER_NODE;
    }

    public boolean isHostFolderNode() {
        return this.type == NodeType.MGMT_HOST_FOLDER_NODE || this.type == NodeType.DATA_HOST_FOLDER_NODE;
    }

    public boolean isMgmtHostFolderNode() {
        return this.type == NodeType.MGMT_HOST_FOLDER_NODE;
    }

    public boolean isDataHostFolderNode() {
        return this.type == NodeType.DATA_HOST_FOLDER_NODE;
    }

    public boolean isInstallationNode() {
        return this.type == NodeType.INSTALL_NODE;
    }

    public boolean isInstallationFolderNode() {
        return this.type == NodeType.INSTALL_FOLDER_NODE;
    }

    public boolean isPGFolderNode() {
        return this.type == NodeType.PG_FOLDER_NODE;
    }

    public boolean isPGNode() {
        return this.type == NodeType.PG_NODE;
    }

    public boolean isMgmtInstanceNode() {
        return this.type == NodeType.MGMT_INSTANCE_NODE;
    }

    public boolean isShellNode() {
        return this.type == NodeType.SHELL_NODE;
    }

    public boolean isMembershipConfigNode() {
        return this.type == NodeType.MEMBERSHIP_CONFIG_NODE;
    }

    public boolean isInstanceConfigNode() {
        return this.type == NodeType.INSTANCE_CONFIG_NODE;
    }

    public boolean isSQLNetNode() {
        return this.type == NodeType.SQLNET_NODE;
    }

    public boolean isTNSNamesNode() {
        return this.type == NodeType.TNSNAMES_NODE;
    }

    public boolean isRepositoryNode() {
        return this.type == NodeType.REPOSITORY_NODE;
    }

    public boolean isRepositoryFolderNode() {
        return this.type == NodeType.REPOSITORY_FOLDER_NODE;
    }

    public boolean isBackupNode() {
        return this.type == NodeType.BACKUP_NODE;
    }

    public boolean isExportNode() {
        return this.type == NodeType.EXPORT_NODE;
    }

    public boolean isConfigObjectNode() {
        return this.type == NodeType.MEMBERSHIP_CONFIG_NODE || this.type == NodeType.INSTANCE_CONFIG_NODE || this.type == NodeType.SQLNET_NODE || this.type == NodeType.TNSNAMES_NODE;
    }

    public boolean isInstStatusNode() {
        return this.type == NodeType.INST_STATUS_NODE;
    }

    public static enum NodeType {
        GRID_NODE,
        MODEL_FOLDER_NODE,
        SHELL_NODE,
        PG_FOLDER_NODE,
        DBDEF_FOLDER_NODE,
        PG_NODE,
        MGMT_HOST_FOLDER_NODE,
        DATA_HOST_FOLDER_NODE,
        HOST_NODE,
        INSTALL_FOLDER_NODE,
        INSTALL_NODE,
        INSTANCE_FOLDER_NODE,
        INSTANCE_NODE,
        MGMT_INSTANCE_NODE,
        DB_FOLDER_NODE,
        DB_NODE,
        DB_DEF_NODE,
        CS_CONN_FOLDER_NODE,
        DIR_CONN_FOLDER_NODE,
        CONN_NODE,
        MEMBERSHIP_CONFIG_NODE,
        INSTANCE_CONFIG_NODE,
        SQLNET_NODE,
        TNSNAMES_NODE,
        INST_STATUS_NODE,
        REPOSITORY_FOLDER_NODE,
        REPOSITORY_NODE,
        BACKUP_FOLDER_NODE,
        EXPORT_FOLDER_NODE,
        BACKUP_NODE,
        EXPORT_NODE;

    }
}

