/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.editors.RepositoryBackupEditor;
import oracle.dbtools.raptor.timesten.grid.editors.SummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.help.HelpInfo;

public class RepositoryEditor
extends TTBaseEditor {
    private SummaryPanel _summaryPanel;
    private RepositoryObject currentRepository;
    static List<String> REPOSITORY_SUMMARY = new ArrayList<String>();
    private static Logger logger;

    public RepositoryEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new SummaryPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.REPOSITORY_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        AbstractNode abstractNode = (AbstractNode)this.context.getNode();
        this.currentRepository = this.currentGrid.getRepository(abstractNode.getShortLabel());
        this.updateContentHelper();
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = REPOSITORY_SUMMARY.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        arrayList.set(0, this.currentRepository.getName());
        arrayList.set(1, this.currentRepository.getLocation());
        arrayList.set(2, this.currentRepository.getMethod().getValue());
        arrayList.set(3, this.currentRepository.getAddress());
        return arrayList;
    }

    private void updateContentHelper() {
        ArrayList<String> arrayList = new ArrayList<String>(REPOSITORY_SUMMARY);
        List<String> list = this.getValues();
        if (this.currentRepository.getMethod() != RepositoryObject.Method.SCP) {
            list.remove(list.size() - 1);
            arrayList.remove(arrayList.size() - 1);
        }
        this.context.setProperty("SummaryAttr", arrayList);
        this.context.setProperty("SummaryVals", list);
        this._summaryPanel.loadContent(this.context);
    }

    static {
        REPOSITORY_SUMMARY.add(Messages.getString("TimesTen.common.name"));
        REPOSITORY_SUMMARY.add(Messages.getString("TimesTenGrid.location"));
        REPOSITORY_SUMMARY.add(Messages.getString("TimesTenGrid.RepositoryMethod"));
        REPOSITORY_SUMMARY.add(Messages.getString("TimesTenGrid.RepositoryAddress"));
        logger = Logger.getLogger(RepositoryBackupEditor.class.getName());
    }
}

