/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.util.Arrays;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisParam;

public class AnalysisData {
    int result;
    String status;
    TableInfo tableInfo;
    int warningCount;
    String[] warnings;
    int columnCount;
    ColumnData[] columnData;
    boolean skipped;
    private static final int COL_DATA_LENGTH = 24;

    public AnalysisData(int n, String string, String string2, int n2, String[] stringArray, int n3, String[] stringArray2) {
        this.result = n;
        this.status = string;
        if (string2 != null) {
            this.tableInfo = new TableInfo(string2);
        }
        this.warningCount = n2;
        this.warnings = stringArray;
        this.setSkipped();
        this.columnCount = n3;
        if (n3 > 0 && stringArray2 != null) {
            this.columnData = new ColumnData[n3];
            for (int i = 0; i < n3; ++i) {
                this.columnData[i] = new ColumnData(stringArray2[i]);
            }
        }
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    private void setSkipped() {
        if (this.warningCount > 0) {
            for (String string : this.warnings) {
                if (!string.contains("Warning: Skipping table")) continue;
                this.skipped = true;
            }
        } else {
            this.skipped = false;
        }
    }

    public int getResult() {
        return this.result;
    }

    public String getStatus() {
        return this.status;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public String[] getWarnings() {
        return this.warnings;
    }

    public String getWarningStr() {
        if (this.warnings != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.warnings) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public ColumnData[] getColumnData() {
        return this.columnData;
    }

    public String getColumnDataStr() {
        StringBuilder stringBuilder = new StringBuilder("Column Data");
        stringBuilder.append(" - ");
        stringBuilder.append(String.valueOf(this.columnCount) + " column(s)");
        for (ColumnData columnData : this.columnData) {
            stringBuilder.append("\n");
            stringBuilder.append("****");
            stringBuilder.append("Column Name");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getColumnName());
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Skipped?");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getSkipped());
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Nullable?");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getNullable());
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Length Semantics");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getLengthSemantics());
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Data Type");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getOracleDataType());
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Precision");
            stringBuilder.append("=");
            if (columnData.getOraclePrecision() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOraclePrecision()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Scale");
            stringBuilder.append("=");
            if (columnData.getOracleScale() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOracleScale()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Maximum Precision");
            stringBuilder.append("=");
            if (columnData.getOracleMaximumPrecision() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOracleMaximumPrecision()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Maximum Scale");
            stringBuilder.append("=");
            if (columnData.getOracleMaximumScale() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOracleMaximumScale()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Data Length");
            stringBuilder.append("=");
            if (columnData.getOracleDataLength() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOracleDataLength()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Char Length");
            stringBuilder.append("=");
            if (columnData.getOracleCharLength() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOracleCharLength()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Maximum Char Length");
            stringBuilder.append("=");
            if (columnData.getOracleMaximumCharLength() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getOracleMaximumCharLength()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Data Type");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getTTDataType());
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Precision");
            stringBuilder.append("=");
            if (columnData.getTTPrecision() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getTTPrecision()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Scale");
            stringBuilder.append("=");
            if (columnData.getTTScale() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getTTScale()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Data Length");
            stringBuilder.append("=");
            if (columnData.getTTDataLength() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getTTDataLength()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Char Length");
            stringBuilder.append("=");
            if (columnData.getTTCharLength() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getTTCharLength()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Compression Pointer Size");
            stringBuilder.append("=");
            if (columnData.getTTCompressionPointerSize() != -999999999) {
                stringBuilder.append(String.valueOf(columnData.getTTCompressionPointerSize()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Number of Distict Values");
            stringBuilder.append("=");
            if (columnData.getNumberOfDistinctValues() != -999999999L) {
                stringBuilder.append(String.valueOf(columnData.getNumberOfDistinctValues()));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Out of Line Flag");
            stringBuilder.append("=");
            stringBuilder.append(columnData.getOutOfLineFlag());
        }
        return stringBuilder.toString();
    }

    private String[] properCommaSplit(String string) {
        Object[] objectArray = new String[24];
        Arrays.fill(objectArray, "");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') {
                stringBuilder.append(string.charAt(i));
                if (string.charAt(i) != '\"') continue;
                bl = !bl;
                continue;
            }
            if (bl) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            objectArray[n++] = stringBuilder.toString();
            stringBuilder = new StringBuilder();
        }
        if (stringBuilder.length() > 0 && n < 24) {
            objectArray[n] = stringBuilder.toString();
        }
        return objectArray;
    }

    class TableInfo {
        private long rc = -999999999L;
        private String c = "";
        private long ombpr = -999999999L;
        private long ttibpr = -999999999L;
        private long ttmoolbpr = -999999999L;
        private long eus = -999999999L;
        private long ecs = -999999999L;

        public TableInfo(String string) {
            String[] stringArray = string.split(",", 7);
            if (!stringArray[0].equals("")) {
                this.rc = Long.parseLong(stringArray[0]);
            }
            this.c = stringArray[1].replace("\"", "");
            if (!stringArray[2].equals("")) {
                this.ombpr = Long.parseLong(stringArray[2]);
            }
            if (!stringArray[3].equals("")) {
                this.ttibpr = Long.parseLong(stringArray[3]);
            }
            if (!stringArray[4].equals("")) {
                this.ttmoolbpr = Long.parseLong(stringArray[4]);
            }
            if (!stringArray[5].equals("")) {
                this.eus = Long.parseLong(stringArray[5]);
            }
            if (!stringArray[6].equals("")) {
                this.ecs = Long.parseLong(stringArray[6]);
            }
        }

        public long getRowCount() {
            return this.rc;
        }

        public String getCompressed() {
            return this.c;
        }

        public long getOracleMaxBytesPerRow() {
            return this.ombpr;
        }

        public long getTTInlineBytesPerRow() {
            return this.ttibpr;
        }

        public long getTTMaxOutOfLineBytesPerRow() {
            return this.ttmoolbpr;
        }

        public long getEstimatedUncompressedSize() {
            return this.eus;
        }

        public long getEstimatedCompressedSize() {
            return this.ecs;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Table Information");
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Row Count");
            stringBuilder.append("=");
            if (this.rc != -999999999L) {
                stringBuilder.append(String.valueOf(this.rc));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Compressed?");
            stringBuilder.append("=");
            stringBuilder.append(this.c);
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Oracle Maximum Bytes per Row");
            stringBuilder.append("=");
            if (this.ombpr != -999999999L) {
                stringBuilder.append(String.valueOf(this.ombpr));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Inline Bytes per Row");
            stringBuilder.append("=");
            if (this.ttibpr != -999999999L) {
                stringBuilder.append(String.valueOf(this.ttibpr));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("TimesTen Maximum Out of Line Bytes per Row");
            stringBuilder.append("=");
            if (this.ttmoolbpr != -999999999L) {
                stringBuilder.append(String.valueOf(this.ttmoolbpr));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Estimated Uncompressed Size");
            stringBuilder.append("=");
            if (this.eus != -999999999L) {
                stringBuilder.append(String.valueOf(this.eus));
            }
            stringBuilder.append("\n");
            stringBuilder.append("    ");
            stringBuilder.append("Estimated Compressed Size");
            stringBuilder.append("=");
            if (this.ecs != -999999999L) {
                stringBuilder.append(String.valueOf(this.ecs));
            }
            return stringBuilder.toString();
        }
    }

    class ColumnData {
        private String cn = "";
        private String s = "";
        private String n = "";
        private String ls = "";
        private int otc = -999999999;
        private String odt = "";
        private int op = -999999999;
        private int os = -999999999;
        private int omp = -999999999;
        private int oms = -999999999;
        private int odl = -999999999;
        private int ocl = -999999999;
        private int omcl = -999999999;
        private int tttc = -999999999;
        private String ttdt = "";
        private int ttp = -999999999;
        private int tts = -999999999;
        private int ttdl = -999999999;
        private int ttcl = -999999999;
        private int ttcps = -999999999;
        private long nodv = -999999999L;
        private String oolf = "";

        public ColumnData(String string) {
            String[] stringArray = AnalysisData.this.properCommaSplit(string);
            this.cn = stringArray[0];
            this.s = stringArray[1].replace("\"", "");
            this.n = stringArray[2].replace("\"", "");
            this.ls = stringArray[3].replace("\"", "");
            if (!stringArray[4].isEmpty()) {
                this.otc = Integer.parseInt(stringArray[4]);
            }
            this.odt = stringArray[5].replace("\"", "");
            if (this.s.equalsIgnoreCase("Y")) {
                return;
            }
            if (!stringArray[6].isEmpty()) {
                this.op = Integer.parseInt(stringArray[6]);
            }
            if (!stringArray[7].isEmpty()) {
                this.os = Integer.parseInt(stringArray[7]);
            }
            if (!stringArray[8].isEmpty()) {
                this.omp = Integer.parseInt(stringArray[8]);
            }
            if (!stringArray[9].isEmpty()) {
                this.oms = Integer.parseInt(stringArray[9]);
            }
            if (!stringArray[11].isEmpty()) {
                this.odl = Integer.parseInt(stringArray[11]);
            }
            if (!stringArray[12].isEmpty()) {
                this.ocl = Integer.parseInt(stringArray[12]);
            }
            if (!stringArray[13].isEmpty()) {
                this.omcl = Integer.parseInt(stringArray[13]);
            }
            if (!stringArray[14].isEmpty()) {
                this.tttc = Integer.parseInt(stringArray[14]);
            }
            this.ttdt = stringArray[15].replace("\"", "");
            if (!stringArray[16].equals("")) {
                this.ttp = Integer.parseInt(stringArray[16]);
            }
            if (!stringArray[17].isEmpty()) {
                this.tts = Integer.parseInt(stringArray[17]);
            }
            if (!stringArray[18].isEmpty()) {
                this.ttdl = Integer.parseInt(stringArray[18]);
            }
            if (!stringArray[19].isEmpty()) {
                this.ttcl = Integer.parseInt(stringArray[19]);
            }
            if (!stringArray[20].isEmpty()) {
                this.ttcps = Integer.parseInt(stringArray[20]);
            }
            if (!stringArray[22].isEmpty()) {
                this.nodv = Long.parseLong(stringArray[22]);
            }
            this.oolf = stringArray[23].replace("\"", "");
        }

        public boolean shouldBeMapped(AnalysisParam analysisParam) {
            switch (this.otc) {
                case 17: 
                case 18: 
                case 19: {
                    if (analysisParam.getRawMapping() != 0) break;
                    return false;
                }
                case 14: {
                    if (analysisParam.getLOBMapping() != 0 || this.tttc != 2) break;
                    this.tttc = 12;
                    this.ttdt = "CLOB";
                    break;
                }
                case 15: {
                    if (analysisParam.getLOBMapping() != 0 || this.tttc != 3) break;
                    this.tttc = 13;
                    this.ttdt = "NCLOB";
                    break;
                }
                case 16: {
                    if (analysisParam.getLOBMapping() != 0 || this.tttc != 19) break;
                    this.tttc = 14;
                    this.ttdt = "BLOB";
                }
            }
            return true;
        }

        public String getColumnName() {
            return this.cn;
        }

        public String getSkipped() {
            return this.s;
        }

        public String getNullable() {
            return this.n;
        }

        public String getLengthSemantics() {
            return this.ls;
        }

        public int getOracleTypeCode() {
            return this.otc;
        }

        public String getOracleDataType() {
            return this.odt;
        }

        public int getOraclePrecision() {
            return this.op;
        }

        public int getOracleScale() {
            return this.os;
        }

        public int getOracleMaximumPrecision() {
            return this.omp;
        }

        public int getOracleMaximumScale() {
            return this.oms;
        }

        public int getOracleDataLength() {
            return this.odl;
        }

        public int getOracleCharLength() {
            return this.ocl;
        }

        public int getOracleMaximumCharLength() {
            return this.omcl;
        }

        public int getTTTypeCode() {
            return this.tttc;
        }

        public String getTTDataType() {
            return this.ttdt;
        }

        public int getTTPrecision() {
            return this.ttp;
        }

        public int getTTScale() {
            return this.tts;
        }

        public int getTTDataLength() {
            return this.ttdl;
        }

        public int getTTCharLength() {
            return this.ttcl;
        }

        public int getTTCompressionPointerSize() {
            return this.ttcps;
        }

        public long getNumberOfDistinctValues() {
            return this.nodv;
        }

        public String getOutOfLineFlag() {
            return this.oolf;
        }
    }
}

