/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.ClassUtil;
import oracle.jdevimpl.vcs.generic.changelist.ExtendedDisplayProperty;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;

public final class CLUtil {
    protected static ChangeListEventQueue createEventQueue(VCSProfile profile, ChangeList changeList, ChangeListInfo changeListInfo) {
        try {
            Class<ChangeListEventQueue> queueClass = changeListInfo.getEventQueueClass();
            if (queueClass != null) {
                Constructor<ChangeListEventQueue> c = queueClass.getConstructor(ChangeList.class);
                return ClassUtil.newInstance(c, changeList);
            }
            return new DefaultEventQueue(changeList);
        }
        catch (ClassNotFoundException cnfe) {
            profile.getLogger().log(Level.SEVERE, "unable to load change list event queue class", cnfe);
            return new DefaultEventQueue(changeList);
        }
        catch (NoSuchMethodException nsme) {
            profile.getLogger().log(Level.SEVERE, "invalid change list event queue class", nsme);
            return new DefaultEventQueue(changeList);
        }
        catch (Exception e) {
            profile.getLogger().log(Level.SEVERE, "unable to instantiate change list event queue class", e);
            return new DefaultEventQueue(changeList);
        }
    }

    protected static VCSStatus[] toStatusArray(VCSProfile profile, Collection statusReferences) {
        ArrayList<VCSStatus> statuses = new ArrayList<VCSStatus>(statusReferences.size() * 2);
        Iterator it = statusReferences.iterator();
        while (it.hasNext()) {
            statuses.add(profile.getStatusInstance((String)it.next()));
        }
        return statuses.toArray(new VCSStatus[statuses.size()]);
    }

    protected static ExtendedDisplayProperty[] createDisplayProperties(Collection propertyBeans) throws ClassNotFoundException {
        ArrayList<ExtendedDisplayProperty> props = new ArrayList<ExtendedDisplayProperty>(propertyBeans.size() * 2);
        for (ChangeListInfo.CLDisplayPropertyInfo propInfo : propertyBeans) {
            props.add(new ExtendedDisplayProperty(propInfo.getID(), propInfo.getShortLabel(), propInfo.getType(), propInfo.getPrototype()));
        }
        return props.toArray(new ExtendedDisplayProperty[props.size()]);
    }

    private static final class DefaultEventQueue
    extends ChangeListEventQueue {
        private DefaultEventQueue(ChangeList changeList) {
            super(changeList);
        }
    }
}

