/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versionhistory;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryURLHelper;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryViewer;

public class VersionHistoryUtil {
    public static final void openHistoryViewer(URL url, String leftRevision, String rightRevision) throws IllegalAccessException, InstantiationException {
        HistoryEntrySelector left = null;
        HistoryEntrySelector right = null;
        URL versionHistoryUrl = VersionHistoryURLHelper.newHistoryURL(url);
        Node versionHistoryNode = NodeFactory.findOrCreate(VersionHistoryNode.class, (URL)versionHistoryUrl);
        Boolean open = versionHistoryNode.isOpen();
        Context detailedContext = Context.newIdeContext();
        detailedContext.setNode(versionHistoryNode);
        detailedContext.setElement((Element)versionHistoryNode);
        if (leftRevision != null) {
            left = new HistoryEntrySelector(leftRevision);
            HistoryContext.setHistoryEntrySelectorLHS((Context)detailedContext, (HistoryEntrySelector)left);
        }
        if (rightRevision != null) {
            right = new HistoryEntrySelector(rightRevision);
            HistoryContext.setHistoryEntrySelectorRHS((Context)detailedContext, (HistoryEntrySelector)right);
        }
        Editor editor = EditorManager.getEditorManager().openEditorInFrame(VersionHistoryViewer.class, detailedContext);
        if (open.booleanValue() && editor instanceof VersionHistoryViewer) {
            ((VersionHistoryViewer)editor).updateSelection(left, right);
        }
    }
}

