/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLFilter;
import oracle.ide.quickdiff.QuickDiffReference;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheUtil;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

public abstract class VCSQuickDiffReferenceProvider
extends QuickDiffReferenceProvider {
    private final VCSExtension _extension;

    protected VCSQuickDiffReferenceProvider(VCSExtension extension) {
        this._extension = extension;
    }

    public final float getMenuSection() {
        return 1.0f;
    }

    public final boolean isAvailable(URL url) {
        if (!super.isAvailable(url)) {
            return false;
        }
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        return extension != null && extension.getId().equals(this._extension.getId()) && VCSManager.getVCSManager().isVersioned(url) && this.isAvailableImpl(url);
    }

    protected boolean isAvailableImpl(URL url) {
        return true;
    }

    public final QuickDiffReference createReference(final URL url) {
        return new QuickDiffReference(url){
            private Observer _statusCacheObserver;
            {
                super(arg0);
                final String urlExternalForm = url.toExternalForm();
                if (VCSQuickDiffReferenceProvider.this._extension.getStatusCache() != null) {
                    this._statusCacheObserver = new Observer(){

                        @Override
                        public void update(Observable o, Object arg) {
                            URL[] urls;
                            for (URL url2 : urls = (URL[])arg) {
                                if (!url2.toExternalForm().equals(urlExternalForm)) continue;
                                this.doNotifyObservers();
                                break;
                            }
                        }
                    };
                    VCSQuickDiffReferenceProvider.this._extension.getStatusCache().addObserver(this._statusCacheObserver);
                }
                if (VCSQuickDiffReferenceProvider.this._extension.getPolicyStatusCache() != null) {
                    this._statusCacheObserver = new Observer(){

                        @Override
                        public void update(Observable o, Object arg) {
                            StatusCacheEvent e = (StatusCacheEvent)arg;
                            URLFilter filter = StatusCacheUtil.createDepthFilter(e.getURLs(), e.getDepth());
                            if (filter.accept(url)) {
                                this.doNotifyObservers();
                            }
                        }
                    };
                    VCSQuickDiffReferenceProvider.this._extension.getPolicyStatusCache().addObserver(this._statusCacheObserver);
                }
            }

            protected final NodeListener createNodeListener() {
                return new NodeListener(){

                    public void nodeReverted(NodeEvent ne) {
                        this.doNotifyObservers();
                    }

                    public void nodeClosed(NodeEvent ne) {
                        this.dispose();
                    }
                };
            }

            public final InputStream openInputStream() throws IOException {
                return VCSQuickDiffReferenceProvider.this.openInputStream(url);
            }

            public final void dispose() {
                super.dispose();
                if (this._statusCacheObserver != null && VCSQuickDiffReferenceProvider.this._extension.getStatusCache() != null) {
                    VCSQuickDiffReferenceProvider.this._extension.getStatusCache().deleteObserver(this._statusCacheObserver);
                }
                if (this._statusCacheObserver != null && VCSQuickDiffReferenceProvider.this._extension.getPolicyStatusCache() != null) {
                    VCSQuickDiffReferenceProvider.this._extension.getPolicyStatusCache().deleteObserver(this._statusCacheObserver);
                }
            }
        };
    }

    protected abstract InputStream openInputStream(URL var1) throws IOException;
}

