/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.composite.CompositeFileElementEvent;
import oracle.ide.composite.CompositeFileElementListener;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheUtil;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class VCSIconOverlayTracker
extends IconOverlayTracker
implements Observer,
VCSEBComponent {
    private static final String VCS_OVERLAY_TYPE_ID = "VCS";
    private static IconOverlay CONFUSED_COMPOSITE_OVERLAY;
    private Observer _controlCacheObserver;
    private final CompositeFileElementListener _compositeListener = new CompositeFileElementListener(){

        public void compositeStateChanged(final CompositeFileElementEvent cfee) {
            if (EventQueue.isDispatchThread()) {
                this._compositeStateChanged(cfee);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    this._compositeStateChanged(cfee);
                }
            });
        }

        private final void _compositeStateChanged(CompositeFileElementEvent cfee) {
            Element[] compositeElements = cfee.getCompositeElements();
            for (int i = 0; i < compositeElements.length; ++i) {
                VCSIconOverlayTracker.this.validateOverlay(compositeElements[i]);
            }
            VCSIconOverlayTracker.this.repaintOverlays();
        }
    };
    private VCSOverlayItemProducer _overlayItemProducer;
    private URLFilter _filter;
    private String _vcsId;

    private static final IconOverlay getConfusedCompositeOverlay() {
        if (CONFUSED_COMPOSITE_OVERLAY == null) {
            CONFUSED_COMPOSITE_OVERLAY = new IconOverlay(OracleIcons.getIcon((String)"extras/overlay_composite.png"), null, VCSArb.get("TOOLTIP_CONFUSED_COMPOSITE"));
        }
        return CONFUSED_COMPOSITE_OVERLAY;
    }

    public VCSIconOverlayTracker() {
    }

    @Deprecated
    protected VCSIconOverlayTracker(int batchSize, VCSOverlayItemProducer overlayItemProducer, URLFilter filter, String vcsId) {
        super(VCSIconOverlayTracker.createInfoTypeID(vcsId), IconOverlayCache.getInstance(), batchSize);
        this.setOverlayItemProducer(overlayItemProducer);
        this.setURLFilter(filter);
        this.setSystemId(vcsId);
    }

    public static final String createInfoTypeID(String vcsId) {
        return "VCS." + vcsId;
    }

    protected void configure() {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile(this.getExtensionID());
        if (profile == null) {
            return;
        }
        this.setOverlayItemProducer(profile.getOverlayItemProducer());
        this.setURLFilter(profile.getURLFilter());
        this.setSystemId(this.getExtensionID());
    }

    private final VCSOverlayItemProducer _getOverlayItemProducer() {
        return this._overlayItemProducer;
    }

    private final URLFilter _getURLFilter() {
        return this._filter;
    }

    private final String _getSystemId() {
        return this._vcsId;
    }

    public final void setOverlayItemProducer(VCSOverlayItemProducer overlayItemProducer) {
        this._overlayItemProducer = overlayItemProducer;
    }

    public final void setURLFilter(URLFilter filter) {
        this._filter = filter;
    }

    public final void setSystemId(String vcsId) {
        this._vcsId = vcsId;
    }

    public final VCSOverlayItemProducer getOverlayItemProducer() {
        return this._overlayItemProducer;
    }

    @Override
    public void update(Observable o, Object arg) {
        URL[] urls;
        Depth depth = Depth.EMPTY;
        if (arg instanceof URL[]) {
            urls = (URL[])arg;
        } else {
            StatusCacheEvent sce = (StatusCacheEvent)arg;
            urls = sce.getURLs();
            depth = sce.getDepth();
        }
        URLFilter filter = StatusCacheUtil.createDepthFilter(urls, depth);
        Element[] elements = this.getValidElements();
        for (int i = 0; i < elements.length; ++i) {
            URL url = VCSModelUtils.getLocatableURL(elements[i]);
            if (url == null) continue;
            url = URLFactory.replaceRefPart((URL)url, null);
            if (!filter.accept(url = URLFactory.replaceQueryPart((URL)url, null))) continue;
            this.validateOverlay(elements[i]);
        }
        Element[] compositeElements = CompositeFileElementRegistry.getCachedCompositeElements((URL[])urls, (oracle.ide.composite.Depth)VCSModelUtils.getCompositeDepthForCacheDepth(depth));
        for (int i = 0; i < compositeElements.length; ++i) {
            this.validateOverlay(compositeElements[i]);
        }
        this.repaintOverlays();
    }

    @Override
    public void handleMessage(VCSEBMessage message) {
        if (!(message instanceof VCSNodeUpdate)) {
            return;
        }
        VCSNodeUpdate nodeUpdate = (VCSNodeUpdate)message;
        if (nodeUpdate.getWhat() == VCSNodeUpdate.RENAMED) {
            this.validateOverlay((Element)nodeUpdate.getNode());
            this.repaintOverlays();
            return;
        }
    }

    protected void startTrackingImpl() {
        if (this._controlCacheObserver == null) {
            this._controlCacheObserver = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    if (arg != null && !arg.equals(VCSIconOverlayTracker.this._getSystemId())) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            VCSIconOverlayTracker.this.validateOverlays();
                            VCSIconOverlayTracker.this.repaintOverlays();
                        }
                    });
                }
            };
        }
        VCSControlCache.getInstance().addObserver(this._controlCacheObserver);
        if (this._getOverlayItemProducer() != null) {
            this._getOverlayItemProducer().getObservable().addObserver(this);
        }
        CompositeFileElementRegistry.addCompositeListener((CompositeFileElementListener)this._compositeListener);
        VCSEventBus.addToBus(this);
    }

    protected void stopTrackingImpl() {
        if (this._getOverlayItemProducer() != null) {
            this._getOverlayItemProducer().getObservable().deleteObserver(this);
        }
        CompositeFileElementRegistry.removeCompositeListener((CompositeFileElementListener)this._compositeListener);
        VCSEventBus.removeFromBus(this);
        VCSControlCache.getInstance().deleteObserver(this._controlCacheObserver);
    }

    protected boolean isControlled(Element element) {
        if (CompositeFileElementRegistry.isCompositeElement((Element)element)) {
            URL[] compositeFileUrls = this.getCompositeFileURLs(element);
            if (compositeFileUrls == null) {
                return false;
            }
            for (URL url : compositeFileUrls) {
                if (!this.isControlled(url)) continue;
                return true;
            }
            return false;
        }
        return this.isControlled(VCSModelUtils.getLocatableURL(element));
    }

    protected IconOverlay[] getOverlays(Element[] elements) {
        try {
            IconOverlay[] overlays = new IconOverlay[elements.length];
            BitSet compositeElementBits = new BitSet(elements.length);
            ArrayList<Element> singularElements = new ArrayList<Element>();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof Locatable) || this.trueComposite(elements[i])) {
                    overlays[i] = this.getCompositeElementOverlay(elements[i]);
                    compositeElementBits.set(i);
                    continue;
                }
                singularElements.add(elements[i]);
            }
            URL[] urls = VCSModelUtils.convertNodesToURLs(singularElements.toArray(new Locatable[0]));
            VCSOverlayItem[] overlayItems = new VCSOverlayItem[urls.length];
            this.resolveJarFileURLs(urls);
            BitSet controlledUrlBits = new BitSet(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                if (overlayItems[i] != null || !VCSControlCache.getInstance().isControlled(urls[i], this._getSystemId())) continue;
                controlledUrlBits.set(i);
            }
            if (!controlledUrlBits.isEmpty()) {
                ArrayList<URL> controlledUrls = new ArrayList<URL>();
                for (int i = 0; i < urls.length; ++i) {
                    if (!controlledUrlBits.get(i)) continue;
                    controlledUrls.add(urls[i]);
                }
                VCSOverlayItem[] controlledOverlayItems = this._getOverlayItemProducer().getOverlayItems(controlledUrls.toArray(new URL[0]));
                int j = 0;
                for (int i = 0; i < urls.length; ++i) {
                    if (!controlledUrlBits.get(i)) continue;
                    overlayItems[i] = controlledOverlayItems[j++];
                }
            }
            int j = 0;
            for (int i = 0; i < elements.length; ++i) {
                if (compositeElementBits.get(i)) continue;
                overlays[i] = overlayItems[j] != null ? overlayItems[j].getOverlay() : null;
                ++j;
            }
            return overlays;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IconOverlay getCompositeElementOverlay(URL[] urls) throws Exception {
        VCSOverlayItem[] overlayItems = this._getOverlayItemProducer().getOverlayItems(urls);
        VCSOverlayItem overlayItem0 = overlayItems[0];
        for (int i = 1; i < overlayItems.length; ++i) {
            if (overlayItems[i].getStatus().equals(overlayItem0.getStatus())) continue;
            return VCSIconOverlayTracker.getConfusedCompositeOverlay();
        }
        return overlayItem0.getOverlay();
    }

    private boolean isControlled(URL url) {
        if (JarUtil.isJarURL((URL)url) && JarUtil.getJarEntry((URL)url) != null && !JarUtil.getJarEntry((URL)url).equals("")) {
            return false;
        }
        if (this._getURLFilter() == null && FeedbackManager.isOn()) {
            FeedbackManager.reportException((String)"VCSIconOverlayTracker URLFilter is null", (Throwable)new NullPointerException());
        }
        return url != null && this._getURLFilter().accept(url) && VCSControlCache.getInstance().isControlled(url, this._getSystemId());
    }

    private boolean trueComposite(Element elm) {
        if (CompositeFileElementRegistry.isCompositeElement((Element)elm)) {
            URL[] urls = CompositeFileElementRegistry.getCompositeFileURLs((Element)elm);
            if (urls == null || urls.length == 0) {
                return false;
            }
            if (urls.length > 1) {
                return true;
            }
            if (!URLFileSystem.equals((URL)urls[0], (URL)((Locatable)elm).getURL())) {
                return true;
            }
        }
        return false;
    }

    private IconOverlay getCompositeElementOverlay(Element element) throws Exception {
        URL[] compositeFileUrls = this.getCompositeFileURLs(element);
        if (compositeFileUrls == null) {
            return null;
        }
        ArrayList<URL> controlledUrls = new ArrayList<URL>();
        for (int i = 0; i < compositeFileUrls.length; ++i) {
            if (!this.isControlled(compositeFileUrls[i]) || URLFileSystem.isDirectoryPath((URL)compositeFileUrls[i]) && !URLFileSystem.exists((URL)compositeFileUrls[i])) continue;
            controlledUrls.add(compositeFileUrls[i]);
        }
        if (controlledUrls.size() <= 0) {
            return null;
        }
        return this.getCompositeElementOverlay(controlledUrls.toArray(new URL[0]));
    }

    private final URL[] getCompositeFileURLs(Element element) {
        URL[] compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)element);
        if (compositeFileUrls == null) {
            return null;
        }
        this.resolveJarFileURLs(compositeFileUrls);
        if (compositeFileUrls.length <= 0) {
            URL url = VCSModelUtils.getLocatableURL(element);
            if (url == null) {
                return null;
            }
            compositeFileUrls = new URL[]{url};
        }
        return compositeFileUrls;
    }

    private final void resolveJarFileURLs(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            if (!JarUtil.isJarURL((URL)urls[i]) || JarUtil.getJarEntry((URL)urls[i]) == null || !JarUtil.getJarEntry((URL)urls[i]).equals("")) continue;
            urls[i] = JarUtil.getJarFileURL((URL)urls[i]);
        }
    }
}

