/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import oracle.dbtools.data.model.Column;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.ui.ColumnPanel;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.TraversableContext;

public class OSCHIColumnPanel
extends ColumnPanel {
    private static final long serialVersionUID = 1L;
    private DataType[] DATATYPES_HIVE = new DataType[]{DataType.VARCHAR2, DataType.NUMBER, DataType.INTEGER, DataType.FLOAT, DataType.CHAR, DataType.DATE, DataType.TIMESTAMP, DataType.NCHAR, DataType.NVARCHAR2};
    private HadoopProperties _hProps;
    TraversableContext _ctx;

    protected void setupColumnDetails(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        if (((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getObjectName() == null && ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("HIVE_TABLE"))) {
            super.setupColumnDetails(traversableContext, this.DATATYPES_HIVE);
        } else {
            super.setupColumnDetails(traversableContext);
        }
        this.setNullVisible(false);
        this.setDefaultVisible(false);
        this.setCommentVisible(false);
        if (((DBObject)this._iProps.get(ImportKeys.DBOBJECT)).getObjectName() == null && ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("HIVE_TABLE"))) {
            this.setNameEnabled(false);
        }
        this.addColumnChangeListener((ColumnChangeListener)this);
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        if (((DBObject)this._hProps.get(ImportKeys.DBOBJECT)).getObjectName() == null && ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("HIVE_TABLE"))) {
            super.setPrecisionProfile(true, false, false);
        } else {
            this.setPrecisionProfile(true, false, true);
        }
        super.onEntry(traversableContext);
    }

    protected void updateExpectedTransition() {
        this.getContext().getWizardCallbacks().wizardUpdateExpectedTransition(this.getTransition());
    }

    private Object getTransition() {
        if (((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("HIVE_TABLE")) && this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED).booleanValue()) {
            return "E";
        }
        return "F";
    }

    public void columnChanged(ColumnChangeEvent columnChangeEvent) {
        super.columnChanged(columnChangeEvent);
        Column column = columnChangeEvent.getColumn();
        ColumnChangeEvent.Type type = columnChangeEvent.getType();
        switch (type) {
            case DATATYPE: {
                String string = column.getType();
                if (string.equals("DOUBLE") || string.equals("FLOAT") || string.equals("NUMBER") || string.equals("TIMESTAMP") || string.equals("TIMESTAMPTZ") || string.equals("TIMESTAMPLTZ")) {
                    this.setPrecisionScaleVisible(false);
                    break;
                }
                this.setPrecisionScaleVisible(true);
                break;
            }
        }
    }
}

