/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.awt.Container;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.controls.SpringUtilities;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.TriStateBoolean;

public class HadoopPartitionPanel
extends JPanel {
    protected String _conn;
    protected BasicDBObject _dbo;
    protected DefaultMutableTreeNode _root;
    private static final long serialVersionUID = 1L;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private ArrayList<String> _selectedObjs = null;
    private TreeCellCheckedListener _listener = null;
    private ExtractObject _extractObject;
    private ExtractListModel _listModel;
    private boolean _init = false;

    public HadoopPartitionPanel(ExtractObject extractObject, ArrayList<String> arrayList) {
        this._extractObject = extractObject;
        this._listModel = this._extractObject.getListModel();
        this.setSelectedObjects(arrayList);
        if (this._listModel.isTypeDBO()) {
            this._dbo = extractObject.getDBObject();
            this.showPanel(this._dbo.getConnectionName());
        }
    }

    public void showPanel(String string) {
        this._conn = string;
        this.draw();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablecolumnselect_html");
    }

    public void draw() {
        this.setLayout(new SpringLayout());
        this._root = this.createCheck(HadoopWizArb.getString("ALL"), true, true);
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.setSize(200, 200);
        this.addToTree();
        this.add(new JLabel(HadoopWizArb.getString("PARTITIONS")));
        this.add(new JScrollPane((Component)this._tree));
        SpringUtilities.makeCompactGrid((Container)this, (int)2, (int)1, (int)0, (int)0, (int)2, (int)2);
    }

    public void redrawTree(String string, boolean bl) {
        if (!this._init) {
            String string2;
            int n;
            this._init = true;
            TriStateBoolean triStateBoolean = this.getRootState();
            TriStateBoolean triStateBoolean2 = null;
            HashMap<String, TriStateBoolean> hashMap = new HashMap<String, TriStateBoolean>();
            for (n = 0; n < this._root.getChildCount(); ++n) {
                string2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getText();
                triStateBoolean2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getCheckBoxState();
                hashMap.put(string2, triStateBoolean2);
            }
            this.removeAll();
            this.draw();
            this._tree.validate();
            this._tree.repaint();
            ((JTreeCellData)this._root.getUserObject()).setCheckBoxState(triStateBoolean);
            for (n = 0; n < this._root.getChildCount(); ++n) {
                string2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getText();
                triStateBoolean2 = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).getCheckBoxState();
                if (hashMap.get(string2) == null || !((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).isEnabled()) continue;
                ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(n)).getUserObject()).setCheckBoxState((TriStateBoolean)hashMap.get(string2));
            }
            if (this._listener != null) {
                this._listener.cellChecked(null);
                this.addTreeCellCheckedListener(this._listener);
            }
            this._tree.validate();
            this._tree.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToTree() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.put("OWNER", this._dbo.getSchemaName());
        hashMap.put("NAME", this._dbo.getObjectName());
        if (Connections.getInstance().lock(this._conn)) {
            try {
                boolean bl = ExtractReconciler.isConnDba((Connection)Connections.getInstance().getConnection(this._conn));
                String string = "select partition_name from " + (bl ? "dba_tab_partitions" : "all_tab_partitions") + " where table_owner = :OWNER  and table_name = :NAME ";
                resultSet = DBUtil.getInstance((String)this._conn).executeQuery(string, hashMap);
                while (resultSet.next()) {
                    this._root.add((MutableTreeNode)this.createCheck(resultSet.getString(1), true, true));
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this._conn);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this._conn);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this._conn);
        }
    }

    public TriStateBoolean getRootState() {
        return ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
    }

    public ArrayList<String> getSelectedPartitions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        TriStateBoolean triStateBoolean = ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
        for (int i = 0; i < this._root.getChildCount(); ++i) {
            String string = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getText();
            triStateBoolean = ((JTreeCellData)((JMutableTreeNode)this._root.getChildAt(i)).getUserObject()).getCheckBoxState();
            if (triStateBoolean == TriStateBoolean.TRUE) {
                arrayList.add(string);
                continue;
            }
            bl = false;
        }
        if (bl) {
            arrayList.clear();
            arrayList.add("*");
        }
        return arrayList;
    }

    public boolean allColumnsSelected() {
        return !((JTreeCellData)this._root.getUserObject()).getCheckBoxState().isTriState();
    }

    protected JMutableTreeNode createCheck(String string, boolean bl, boolean bl2) {
        JTreeCellData jTreeCellData = new JTreeCellData(string);
        jTreeCellData.setCheckBoxEnabled(bl2);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setHasCheckBox(bl2);
        if (bl2) {
            jTreeCellData.setCheckBoxState(bl ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
        }
        return new JMutableTreeNode(jTreeCellData);
    }

    private void setSelectedObjects(ArrayList<String> arrayList) {
        if (arrayList.equals(null) || arrayList.isEmpty()) {
            this._selectedObjs = new ArrayList();
            this._selectedObjs.add(HadoopWizArb.getString("ALL"));
        } else {
            this._selectedObjs = arrayList;
        }
    }

    public void setTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._listener = treeCellCheckedListener;
    }

    public void addTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._tree.addTreeCellCheckedListener(treeCellCheckedListener);
    }

    public int getColCount() {
        return this._root.getChildCount();
    }
}

