/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetGroup;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetSection;
import oracle.ideimpl.palette2.MyComponentsFavoritesSection;
import oracle.ideimpl.palette2.MyComponentsGroup;
import oracle.ideimpl.palette2.MyComponentsPageModel;
import oracle.ideimpl.palette2.MyComponentsRecentlyUsedSection;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class MyComponentsPages
extends PalettePages {
    public static final int PAGEID = 1;
    public static final int GROUP_FAVORITES = 2;
    public static final int GROUP_CODESNIPPETS = 3;
    public static final int GROUP_RECENTLYUSED = 4;
    public static final int SECTION_FAVORITES = 5;
    public static final int SECTION_CODESNIPPETS = 6;
    public static final int SECTION_RECENTLYUSED = 7;
    private static String nsURI = "http:// xmlns.oracle.com/jdeveloper/1013/extension";
    private static String rootName = "palette2";
    private URL urlHashIO;
    private Context currentContext;
    private static final String pageId = MyComponentsPages.class.getName();
    private boolean beingInitialized = false;
    private List<PalettePagesListener> palettePagesListeners = new ArrayList<PalettePagesListener>();
    private List<PalettePage> palettePages = new ArrayList<PalettePage>();
    boolean loadingData = false;
    boolean isRemovingOrRenaimgSection_fixFor6111145 = false;

    private MyComponentsPages(Context context) {
        URL extDir = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.ide.palette2");
        this.urlHashIO = URLFactory.newFileURL((String)(extDir.getPath() + "MyComponents.xml"));
        this.initialize(context);
    }

    public static MyComponentsPages getInstance(Context context) {
        return new MyComponentsPages(context);
    }

    public static String getIdentifier(int typeId, String name) {
        Object result = pageId;
        switch (typeId) {
            case 1: {
                break;
            }
            case 2: {
                result = (String)result + ".Favorites";
                break;
            }
            case 3: {
                result = (String)result + ".CodeSnippets";
                break;
            }
            case 4: {
                result = (String)result + ".RecentlyUsed";
                break;
            }
            case 5: {
                result = (String)result + ".Favorites.Section." + (name != null ? name : "");
                break;
            }
            case 6: {
                result = (String)result + ".CodeSnippets.Section." + (name != null ? name : "");
                break;
            }
            case 7: {
                result = (String)result + ".RecentlyUsed.Section.";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public synchronized void initialize(Context context) {
        if (ModelUtil.areEqual((Object)context, (Object)this.currentContext)) {
            return;
        }
        this.palettePages.clear();
        this.currentContext = context;
        this.beingInitialized = true;
        this.createDefaultMyComponentsPage();
        this.loadData();
        this.beingInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadData() {
        if (this.loadingData) {
            return;
        }
        this.loadingData = true;
        try {
            HashStructure hash = null;
            HashStructureIO hashIO = new HashStructureIO(null, null);
            hash = (HashStructure)hashIO.load(this.urlHashIO);
            if (hash != null) {
                MyComponentsPageModel pageModel = MyComponentsPageModel.getInstance(hash);
                Collection<MyComponentsCodeSnippetSection> pSnippetSections = pageModel.getCodeSnippets(this.currentContext);
                for (MyComponentsCodeSnippetSection myComponentsCodeSnippetSection : pSnippetSections) {
                    this.addSection(11, myComponentsCodeSnippetSection, false);
                }
                if (!this.beingInitialized) {
                    Collection<MyComponentsFavoritesSection> pFavoriteSections = pageModel.getFavorites(this.currentContext);
                    for (MyComponentsFavoritesSection favoriteSection : pFavoriteSections) {
                        this.addSection(7, favoriteSection, false);
                    }
                    Collection<MyComponentsRecentlyUsedSection> collection = pageModel.getRecentlyUsed(this.currentContext);
                    for (MyComponentsRecentlyUsedSection recentlyUsedSection : collection) {
                        this.addSection(9, recentlyUsedSection, false);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.loadingData = false;
        }
    }

    @Override
    public Collection<PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    @Override
    public PaletteItem getItem(String providerId, String itemId) {
        if (providerId == null || providerId.length() == 0 || itemId == null || itemId.length() == 0) {
            return null;
        }
        if (!MyComponentsCodeSnippetItem.PROVIDER_ID.equals(providerId)) {
            return null;
        }
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(11))) continue;
                for (PaletteSection paletteSection : paletteGroup.getSections()) {
                    PaletteAugmentedSection defSection = (PaletteAugmentedSection)paletteSection;
                    PaletteItem item = defSection.getItem(itemId);
                    if (item == null) continue;
                    return item;
                }
            }
        }
        return null;
    }

    @Override
    public void addPalettePagesListener(PalettePagesListener listener) {
        if (!this.palettePagesListeners.contains(listener)) {
            this.palettePagesListeners.add(listener);
        }
    }

    @Override
    public void removePalettePagesListener(PalettePagesListener listener) {
        this.palettePagesListeners.remove(listener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.currentContext = null;
    }

    private void addPage(PalettePage page) {
        this.palettePages.add(page);
    }

    private void createDefaultMyComponentsPage() {
        String name = PaletteArb.getString(5);
        String description = PaletteArb.getString(6);
        String icon = null;
        String groupId = null;
        String groupEditor = null;
        String projectConfig = null;
        List<String> showForTypes = null;
        List<String> techScope = null;
        String type = null;
        MyComponentsPalettePage palettePage = new MyComponentsPalettePage(name, description, icon, pageId);
        name = PaletteArb.getString(7);
        description = PaletteArb.getString(8);
        type = "favorites";
        groupId = MyComponentsPages.getIdentifier(2, null);
        palettePage.addGroup(new MyComponentsGroup(name, description, icon, groupId, groupEditor, projectConfig, showForTypes, techScope, type, this));
        name = PaletteArb.getString(11);
        description = PaletteArb.getString(12);
        type = "snippets";
        groupId = MyComponentsPages.getIdentifier(3, null);
        palettePage.addGroup(new MyComponentsCodeSnippetGroup(name, description, icon, groupId, groupEditor, projectConfig, showForTypes, techScope, type, this));
        name = PaletteArb.getString(9);
        description = PaletteArb.getString(10);
        groupId = MyComponentsPages.getIdentifier(4, null);
        palettePage.addGroup(new MyComponentsGroup(name, description, icon, groupId, groupEditor, projectConfig, showForTypes, techScope, type, this));
        this.addPage(palettePage);
    }

    public void addSection(int comp, PaletteAugmentedSection section, boolean persist) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(comp))) continue;
                MyComponentsGroup group = (MyComponentsGroup)paletteGroup;
                group.addSection(section);
                break;
            }
            if (persist) {
                this.persistSection(comp);
                this.firePageUpdated();
            }
        }
    }

    public void renameSection(int comp, String oldName, String newName) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(comp))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    if (!this.areEqual(oldName, paletteSection.getName())) continue;
                    PaletteAugmentedSection section = (PaletteAugmentedSection)paletteSection;
                    section.setName(newName);
                    if (section instanceof MyComponentsFavoritesSection || section instanceof MyComponentsCodeSnippetSection) {
                        Object identifier = pageId;
                        identifier = section instanceof MyComponentsFavoritesSection ? (String)identifier + ".Favorites.Section." : (String)identifier + ".CodeSnippets.Section.";
                        identifier = (String)identifier + (newName != null ? newName : "");
                        section.setData("sectiomId", identifier);
                    }
                    this.isRemovingOrRenaimgSection_fixFor6111145 = true;
                    this.persistSection(comp);
                    this.isRemovingOrRenaimgSection_fixFor6111145 = false;
                    this.firePageUpdated();
                    break block0;
                }
            }
        }
    }

    public void removeSection(int comp, String sectionName) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(comp))) continue;
                MyComponentsGroup group = (MyComponentsGroup)paletteGroup;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    if (!this.areEqual(sectionName, paletteSection.getName())) continue;
                    group.removeSection(paletteSection);
                    this.isRemovingOrRenaimgSection_fixFor6111145 = true;
                    this.persistSection(comp);
                    this.isRemovingOrRenaimgSection_fixFor6111145 = false;
                    this.firePageUpdated();
                    break block0;
                }
            }
        }
    }

    public void removeItem(int comp, PaletteItem pItem) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(comp))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    PaletteAugmentedSection defSection = (PaletteAugmentedSection)paletteSection;
                    if (defSection.getItem(pItem.getItemId()) == null) continue;
                    defSection.removeItem(pItem);
                    this.persistSection(comp);
                    this.firePageUpdated();
                    break block0;
                }
            }
        }
    }

    public void removeItem(int comp, PaletteItem pItem, String sectionName) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(comp))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    PaletteAugmentedSection defSection;
                    if (!this.areEqual(sectionName, paletteSection.getName()) || !(defSection = (PaletteAugmentedSection)paletteSection).removeItem(pItem)) continue;
                    this.persistSection(comp);
                    this.firePageUpdated();
                    break block0;
                }
            }
        }
    }

    public void purgeItem(PaletteItem pItem) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage == null) {
            return;
        }
        Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
        if (paletteGroups == null) {
            return;
        }
        boolean persist = false;
        block0: for (PaletteGroup paletteGroup : paletteGroups) {
            Collection<PaletteSection> paletteSections = paletteGroup.getSections();
            for (PaletteSection paletteSection : paletteSections) {
                PaletteAugmentedSection defSection = (PaletteAugmentedSection)paletteSection;
                if (!defSection.removeItem(pItem)) continue;
                persist = true;
                this.firePageUpdated();
                continue block0;
            }
        }
        if (persist) {
            this.persistAll();
        }
    }

    private boolean areEqual(String name1, String name2) {
        boolean ret = false;
        if (name1 == null) {
            if (name2 == null) {
                ret = true;
            }
        } else if (name2 != null && name1.equalsIgnoreCase(name2)) {
            ret = true;
        }
        return ret;
    }

    public void addToFavorites(PaletteItem paletteItem, String pageName, String groupName, String sectionName, boolean persist) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                Iterator<PaletteSection> iterator;
                if (!paletteGroup.getName().equals(PaletteArb.getString(7))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                if (paletteSections.isEmpty()) {
                    String sectionIdFavorites = MyComponentsPages.getIdentifier(5, sectionName);
                    MyComponentsFavoritesSection favoriteSect = new MyComponentsFavoritesSection(sectionName, sectionIdFavorites);
                    MyComponentsGroup paletteGroupFavorites = (MyComponentsGroup)paletteGroup;
                    paletteGroupFavorites.addSection(favoriteSect);
                    favoriteSect.addItem(paletteItem, pageName, groupName);
                    break;
                }
                if (sectionName == null && (iterator = paletteSections.iterator()).hasNext()) {
                    PaletteSection paletteSection = iterator.next();
                    sectionName = paletteSection.getName();
                }
                for (PaletteSection paletteSection : paletteSections) {
                    if (!this.areEqual(sectionName, paletteSection.getName())) continue;
                    MyComponentsFavoritesSection paletteFavoritesSection = (MyComponentsFavoritesSection)paletteSection;
                    paletteFavoritesSection.addItem(paletteItem, pageName, groupName);
                    break block0;
                }
            }
        }
        if (persist) {
            this.persistFavorites();
        }
        this.firePageUpdated();
    }

    public void insertFavorites(PaletteItem paletteItem, String pageName, String groupName, String sectionName, String beforeItemId, Boolean persist) {
        if (beforeItemId == null) {
            this.addToFavorites(paletteItem, pageName, groupName, sectionName, persist);
            return;
        }
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(7))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                if (paletteSections.isEmpty()) {
                    String sectionIdFavorites = MyComponentsPages.getIdentifier(5, sectionName);
                    MyComponentsFavoritesSection favoritesSect = new MyComponentsFavoritesSection(sectionName, sectionIdFavorites);
                    MyComponentsGroup group = (MyComponentsGroup)paletteGroup;
                    group.addSection(favoritesSect);
                    favoritesSect.addItem(paletteItem);
                    break;
                }
                for (PaletteSection paletteSection : paletteSections) {
                    if (!this.areEqual(sectionName, paletteSection.getName())) continue;
                    MyComponentsFavoritesSection section = (MyComponentsFavoritesSection)paletteSection;
                    section.insertItem(paletteItem, pageName, groupName, beforeItemId);
                    break block0;
                }
            }
        }
        if (persist.booleanValue()) {
            this.persistFavorites();
        }
        this.firePageUpdated();
    }

    public void insertCodeSnippet(PaletteItem paletteItem, String sectionName, String beforeItemId, Boolean persist) {
        if (beforeItemId == null) {
            this.appendCodeSnippet(paletteItem, sectionName, persist);
            return;
        }
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            block0: for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(11))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                if (paletteSections.isEmpty()) {
                    String sectionIdCodeSnippet = MyComponentsPages.getIdentifier(6, sectionName);
                    MyComponentsCodeSnippetSection codeSnippetSect = new MyComponentsCodeSnippetSection(sectionName, sectionIdCodeSnippet);
                    MyComponentsGroup paletteGroupCodeSnippets = (MyComponentsGroup)paletteGroup;
                    paletteGroupCodeSnippets.addSection(codeSnippetSect);
                    codeSnippetSect.addItem(paletteItem);
                    break;
                }
                for (PaletteSection paletteSection : paletteSections) {
                    if (!this.areEqual(sectionName, paletteSection.getName())) continue;
                    MyComponentsCodeSnippetSection section = (MyComponentsCodeSnippetSection)paletteSection;
                    section.insertItem(paletteItem, beforeItemId);
                    break block0;
                }
            }
        }
        if (persist.booleanValue()) {
            this.persistSnippets();
        }
        this.firePageUpdated();
    }

    public void appendCodeSnippet(PaletteItem paletteItem, String sectionName, Boolean persist) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(11))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                boolean added = false;
                if (!paletteSections.isEmpty()) {
                    for (PaletteSection paletteSection : paletteSections) {
                        if (!this.areEqual(sectionName, paletteSection.getName())) continue;
                        MyComponentsCodeSnippetSection paletteSnippetSection = (MyComponentsCodeSnippetSection)paletteSection;
                        paletteSnippetSection.addItem(paletteItem);
                        added = true;
                        break;
                    }
                }
                if (added) break;
                String sectionIdCodeSnippet = MyComponentsPages.getIdentifier(6, sectionName);
                MyComponentsCodeSnippetSection codeSnippetSect = new MyComponentsCodeSnippetSection(sectionName, sectionIdCodeSnippet);
                MyComponentsGroup paletteGroupCodeSnippets = (MyComponentsGroup)paletteGroup;
                paletteGroupCodeSnippets.addSection(codeSnippetSect);
                codeSnippetSect.addItem(paletteItem);
                break;
            }
        }
        if (persist.booleanValue()) {
            this.persistSnippets();
        }
        this.firePageUpdated();
    }

    public void updateCodeSnippet(String name, String iconUrl, String snippet) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(11))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    Collection<PaletteItem> paletteItems = paletteSection.getItems();
                    for (PaletteItem paletteItem : paletteItems) {
                        if (!paletteItem.getName().equals(name)) continue;
                        MyComponentsCodeSnippetItem pI = (MyComponentsCodeSnippetItem)paletteItem;
                        pI.updateCodeSnippet(iconUrl, snippet);
                        this.persistSnippets();
                        this.firePageUpdated();
                        return;
                    }
                }
            }
        }
    }

    public void addToRecentlyUsed(PaletteItem paletteItem, String pageName, String groupName, Boolean persist) {
        String currentPageName;
        PaletteWindowImpl pw;
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(9))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    MyComponentsRecentlyUsedSection paletteRecentlyUsedSection = (MyComponentsRecentlyUsedSection)paletteSection;
                    paletteRecentlyUsedSection.addItem(paletteItem, pageName, groupName);
                }
            }
        }
        if (persist.booleanValue()) {
            this.persistRecentlyUsed();
        }
        if ((pw = (PaletteWindowImpl)PaletteWindowImpl.getInstance()) != null && (currentPageName = pw.getSelectedPageName()) != null) {
            this.firePageUpdated();
        }
    }

    public void clearRecentlyUsed(Boolean persist) {
        DefaultPalettePage palettePage = (DefaultPalettePage)this.palettePages.get(0);
        if (palettePage != null) {
            Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
            for (PaletteGroup paletteGroup : paletteGroups) {
                if (!paletteGroup.getName().equals(PaletteArb.getString(9))) continue;
                Collection<PaletteSection> paletteSections = paletteGroup.getSections();
                for (PaletteSection paletteSection : paletteSections) {
                    MyComponentsRecentlyUsedSection paletteRecentlyUsedSection = (MyComponentsRecentlyUsedSection)paletteSection;
                    paletteRecentlyUsedSection.removeAllItems();
                }
            }
        }
        if (persist.booleanValue()) {
            this.persistRecentlyUsed();
        }
        this.firePageUpdated();
    }

    private void firePageUpdated() {
        PalettePage palettePage = this.palettePages.get(0);
        HashSet<PalettePage> set = new HashSet<PalettePage>(1);
        set.add(palettePage);
        for (PalettePagesListener pagesListener : this.palettePagesListeners) {
            pagesListener.palettePagesChanged(null, null, set);
        }
    }

    private void persistSection(int sectionId) {
        switch (sectionId) {
            case 11: {
                this.persistSnippets();
                break;
            }
            case 7: {
                this.persistFavorites();
                break;
            }
            case 9: {
                this.persistRecentlyUsed();
                break;
            }
        }
    }

    private void persistAll() {
        this.persistSection(11);
        this.persistSection(7);
        this.persistSection(9);
    }

    private void persistFavorites() {
        HashStructure hash = HashStructure.newInstance();
        MyComponentsPageModel pageModel = MyComponentsPageModel.getInstance(hash);
        pageModel.persistFavorites(this.currentContext, nsURI, rootName, this.urlHashIO, this.palettePages.get(0));
    }

    private void persistSnippets() {
        HashStructure hash = HashStructure.newInstance();
        MyComponentsPageModel pageModel = MyComponentsPageModel.getInstance(hash);
        pageModel.persistCodeSnippets(this.currentContext, nsURI, rootName, this.urlHashIO, this.palettePages.get(0));
    }

    private void persistRecentlyUsed() {
        HashStructure hash = HashStructure.newInstance();
        MyComponentsPageModel pageModel = MyComponentsPageModel.getInstance(hash);
        pageModel.persistRecentlyUsed(this.currentContext, nsURI, rootName, this.urlHashIO, this.palettePages.get(0));
    }

    private String getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return suffix.substring(period + 1);
        }
        return "";
    }

    class MyComponentsPalettePage
    extends DefaultPalettePage {
        MyComponentsPalettePage(String name, String desc, String icon, String pageId) {
            super(name, desc, icon, pageId);
        }

        @Override
        public Collection<PaletteGroup> getGroups() {
            if (!MyComponentsPages.this.isRemovingOrRenaimgSection_fixFor6111145) {
                MyComponentsPages.this.loadData();
            }
            return super.getGroups();
        }

        @Override
        public String getPageKey() {
            return this.getClass().getName();
        }
    }
}

