/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.text.MessageFormat;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockable2;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractPaletteDockable
extends DockableWindow
implements PaletteDockable2 {
    private static final HelpInfo HELP_INFO = new HelpInfo("f1_idecomponentpalette_html");
    private static final String LAYOUT_KEY_FMT = "{1}.{2}";
    private String _viewName;
    private PaletteGroup paletteGroup;
    private String _cachedName;
    private PaletteGroupUI groupWindow;
    private final String layoutKey;

    @Deprecated
    private AbstractPaletteDockable(String viewName) {
        super("PALETTEFACTORY." + viewName);
        this._viewName = viewName;
        this.layoutKey = MessageFormat.format(LAYOUT_KEY_FMT, "PALETTEFACTORY", viewName, "layout");
    }

    protected AbstractPaletteDockable(ViewId viewId) {
        super(viewId.getId());
        this._viewName = viewId.getName();
        this.layoutKey = MessageFormat.format(LAYOUT_KEY_FMT, viewId.getType(), viewId.getName(), "layout");
    }

    public void clear() {
        this.paletteGroup = null;
        this.groupWindow = null;
    }

    public String getTabName() {
        return this._cachedName;
    }

    public Component getGUI() {
        return this.getGroupUI();
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
        this.paletteGroup = paletteGroup;
        this._cachedName = paletteGroup.getName();
        if (this._cachedName == null || this._cachedName.length() == 0) {
            this._cachedName = this._viewName != null && this._viewName.length() > 0 ? this._viewName : PaletteArb.getString(1);
        }
        if (this.groupWindow != null) {
            this.groupWindow.setData(paletteGroup);
        }
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Controller getController() {
        return PaletteControllerUI.getInstance();
    }

    @Override
    public void toggleViewState() {
        if (this.getViewState().equals("list")) {
            this.setViewState("icon");
        } else {
            this.setViewState("list");
        }
    }

    public ContextMenu getContextMenu() {
        return PaletteControllerUI.getInstance().getContextMenu();
    }

    @Override
    public void setViewState(String vwState) {
        Ide.getDTCache().putString(this.layoutKey, vwState);
        this.groupWindow.toggleView(vwState);
    }

    public void saveLayout(PropertyAccess p) {
        p.setProperty("NAME", this._cachedName);
        p.setProperty("VIEWSTATE", this.getViewState());
    }

    public int getDefaultVisibility(Layout layout) {
        return 32;
    }

    public HelpInfo getHelpInfo() {
        return HELP_INFO;
    }

    @Override
    public String getViewState() {
        String layout;
        String viewState = Ide.getDTCache().getString(this.layoutKey);
        if (null != viewState) {
            return viewState;
        }
        if (null != this.paletteGroup && ModelUtil.hasLength((String)(layout = this.paletteGroup.getLayout()))) {
            return layout;
        }
        return this.getDefaultLayout();
    }

    protected String getDefaultLayout() {
        return "icon-bottom-label";
    }

    public void loadLayout(PropertyAccess p) {
        this._cachedName = p.getProperty("NAME", "");
        this.setViewState(p.getProperty("VIEWSTATE", ""));
    }

    public String getViewName() {
        return this._viewName;
    }

    public PaletteGroupUI getGroupUI() {
        if (this.groupWindow == null) {
            this.groupWindow = this.initGroupUI();
            this.groupWindow.setUseLargeIcons(this.getUseLargeIcons());
            if (this.paletteGroup != null) {
                this.groupWindow.setData(this.paletteGroup);
            }
        }
        return this.groupWindow;
    }

    protected abstract PaletteGroupUI initGroupUI();

    @Override
    public void setUseLargeIcons(boolean useLargeIcons) {
        PaletteGroupUI groupUI = this.getGroupUI();
        groupUI.setUseLargeIcons(useLargeIcons);
    }

    @Override
    public boolean getUseLargeIcons() {
        PaletteWindow window = PaletteManager.getPaletteManager().getPaletteWindow();
        return null != window ? window.getUseLargeIcons() : true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ":" + this.getId();
    }
}

