/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.util;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import oracle.dbtools.connections.api.Connections;

public class ConnectionManagementUtil {
    private final NameValidator defaultValidator = new NameValidatorImpl();
    private final DirectoryMapper defaultMapper = new DirectoryMapperImpl();

    public static ConnectionManagementUtil instance() {
        return Holder.INSTANCE;
    }

    public NameValidator getDefaultValidator() {
        return this.defaultValidator;
    }

    public DirectoryMapper getDefaultMapper() {
        return this.defaultMapper;
    }

    public boolean validateConnectionName(CharSequence name) {
        return this.defaultValidator.test(name);
    }

    public String mapDirectoryName(CharSequence connectionName) {
        return (String)this.defaultMapper.apply(connectionName);
    }

    public String mapDirectoryName(Connections.Identifier identifier) {
        return (String)this.defaultMapper.apply(identifier.toString());
    }

    private static class DirectoryMapperImpl
    implements DirectoryMapper {
        private static final String UNSUPPORTED_CHARS = "[\\/:;]";
        private static final String REPLACEMENT_STRING = "_";
        private final Pattern unsupported = Pattern.compile("[\\/:;]");

        DirectoryMapperImpl() {
        }

        @Override
        public String apply(CharSequence s) {
            return this.unsupported.matcher(s).replaceAll(REPLACEMENT_STRING);
        }
    }

    public static interface DirectoryMapper
    extends Function<CharSequence, String> {
    }

    private static class NameValidatorImpl
    implements NameValidator {
        private static final String ALLOWED = "[\\P{Cc}\\P{Cn}\\P{Cs}&&[^\\p{Zl}\\p{Zp}\\t\\u00A0\\u1680\\u2000-\\u200A\\u202F\\u205F\\u3000`\"'\\\\]]+";
        private static final int MAX_LENGTH = 256;
        private final Pattern allowed = Pattern.compile("[\\P{Cc}\\P{Cn}\\P{Cs}&&[^\\p{Zl}\\p{Zp}\\t\\u00A0\\u1680\\u2000-\\u200A\\u202F\\u205F\\u3000`\"'\\\\]]+");

        NameValidatorImpl() {
        }

        @Override
        public boolean test(CharSequence text) {
            return this.allowed.matcher(NameValidatorImpl.normalize(text)).matches() && text.length() < 256;
        }

        static String normalize(CharSequence text) {
            return text.toString().trim();
        }
    }

    public static interface NameValidator
    extends Predicate<CharSequence> {
    }

    private static class Holder {
        private static final ConnectionManagementUtil INSTANCE = new ConnectionManagementUtil();

        private Holder() {
        }
    }
}

