/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers.ora;

import java.text.MessageFormat;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ora.BaseOracleConnectionHelper;
import oracle.dbtools.jdbc.configurators.BasicConfiguration;
import oracle.dbtools.jdbc.configurators.ConfigurationException;

public class BasicOracleConnectionHelper
extends BaseOracleConnectionHelper {
    BasicOracleConnectionHelper(ConnectionHelperContext ctx) {
        super(ctx);
    }

    @Override
    public String getURL() {
        ConfigurationProperties dbtoolsProperties = this.definition.getDbtoolsProperties();
        return BasicOracleConnectionHelper.hasLength(dbtoolsProperties.getProperty("serviceName")) ? super.getURL() : MessageFormat.format("jdbc:oracle:{0}:@{1}", "thin", this.getConnectionSpec());
    }

    @Override
    public String getConnectionSpec() {
        ConfigurationProperties dbtoolsProperties = this.definition.getDbtoolsProperties();
        String host = dbtoolsProperties.getProperty("host");
        String port = dbtoolsProperties.getProperty("port");
        String serviceName = dbtoolsProperties.getProperty("serviceName");
        String sid = dbtoolsProperties.getProperty("sid");
        return BasicOracleConnectionHelper.hasLength(serviceName) ? this.getConnectionSpecWithServiceName(host, port, serviceName) : this.getConnectionSpecWithSID(host, port, sid);
    }

    private BasicConfiguration createBasicConfiguration() throws ConfigurationException {
        String serviceName;
        String host;
        BasicConfiguration.Builder basicBuilder = BasicConfiguration.builder();
        ConfigurationProperties dbtoolsProperties = this.definition.getDbtoolsProperties();
        String port = dbtoolsProperties.getProperty("port");
        if (BasicOracleConnectionHelper.hasLength(port)) {
            basicBuilder.port(port);
        }
        if (BasicOracleConnectionHelper.hasLength(host = dbtoolsProperties.getProperty("host"))) {
            basicBuilder.hostname(host);
        }
        if (BasicOracleConnectionHelper.hasLength(serviceName = dbtoolsProperties.getProperty("serviceName"))) {
            basicBuilder.servicename(serviceName);
        }
        return basicBuilder.build();
    }
}

