/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers.ora;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ora.BaseOracleConnectionHelper;
import oracle.dbtools.jdbc.tns.TNSEntry;
import oracle.dbtools.jdbc.tns.TNSNames;
import oracle.jdbc.datasource.OracleDataSource;

public class AdvancedOracleConnectionHelper
extends BaseOracleConnectionHelper {
    public static final String TNS_URL_FORMAT = "jdbc:oracle:{0}:@{1}";
    public static final String TNS_DESCRIPTOR = "TNS Descriptor";

    AdvancedOracleConnectionHelper(ConnectionHelperContext ctx) {
        super(ctx);
    }

    @Override
    public String getConnectionSpec() {
        String url;
        String spec = AdvancedOracleConnectionHelper.getDbtoolsProperty(this.definition, "connectionString");
        if (spec == null && (url = AdvancedOracleConnectionHelper.getDbtoolsProperty(this.definition, "url")) != null) {
            int idx = url.indexOf(64);
            spec = idx >= 0 ? url.substring(idx + 1) : url;
        }
        return spec;
    }

    @Override
    public String getURL() {
        String spec = this.getConnectionSpec();
        return spec != null && spec.startsWith("jdbc") ? spec : MessageFormat.format(TNS_URL_FORMAT, this.getDriverType(), spec);
    }

    @Override
    public Collection<ConnectionHelper.DisplayEntry> getDisplayProperties() {
        Collection<ConnectionHelper.DisplayEntry> props = super.getDisplayProperties();
        Path connDir = this.definition.getConnectionDirectory();
        try {
            Path tns;
            String tnsName = this.getConnectionSpec();
            if (AdvancedOracleConnectionHelper.isPossibleTNS(tnsName) && (tns = this.getTNSFile()) != null) {
                props.add(AdvancedOracleConnectionHelper.createDisplayEntry("tnsnames.ora".toUpperCase(), tns.toString()));
                TNSEntry entry = this.getTNSEntry(tnsName, tns);
                if (entry != null) {
                    props.add(AdvancedOracleConnectionHelper.createDisplayEntry(TNS_DESCRIPTOR, tnsName + " = " + entry.getConnectionDescriptor()));
                }
            }
        }
        catch (IOException e) {
            this.logger.logError("error processing tnsnames.ora file", e);
        }
        return props;
    }

    private Path getTNSFile() throws IOException {
        try (Stream<Path> s = Files.list(this.definition.getConnectionDirectory());){
            Path path = s.filter(AdvancedOracleConnectionHelper::matchesTNS).findFirst().orElse(null);
            return path;
        }
    }

    private TNSEntry getTNSEntry(String tnsName, Path tnsfile) throws IOException {
        Path parent = tnsfile.getParent();
        try (InputStream is = Files.newInputStream(tnsfile, new OpenOption[0]);){
            TNSNames tnsNames = TNSNames.read(is);
            TNSEntry tNSEntry = tnsNames.getTNSEntry(tnsName);
            return tNSEntry;
        }
    }

    @Override
    public void configureDataSource(OracleDataSource datasource) throws SQLException {
        super.configureDataSource(datasource);
    }

    private static boolean isPossibleTNS(String spec) {
        return Pattern.matches("^[a-zA-Z0-9._]*$", spec);
    }

    private static boolean matchesTNS(Path p) {
        String fname = p.getFileName().toString();
        return "tnsnames.ora".equalsIgnoreCase(fname);
    }
}

