/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor.bookmarks;

import java.net.URL;
import java.util.Collection;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetGUI;
import oracle.dbtools.worksheet.editor.bookmarks.WorksheetBookmark;
import oracle.ide.Context;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public final class BookmarkController
implements Controller {
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = BookmarkConstants.getCmdIDToggleBookmarkNumber((int)ideAction.getCommandId());
        if (ideAction.getCommandId() == BookmarkConstants.TOGGLE_BOOKMARK_CMD_ID || n != -1) {
            View view = context.getView();
            if (view instanceof Worksheet) {
                URL uRL = context.getNode().getURL();
                int n2 = ((WorksheetGUI)((Worksheet)view).getGUI()).getEditorPane().getCaretPosition();
                int n3 = ((WorksheetGUI)((Worksheet)view).getGUI()).getEditorPane().getLineFromOffset(n2);
                this.toggleBookmark(uRL, n3 + 1, n);
                view.activate();
                return true;
            }
            if (view instanceof CodeEditorGutterView) {
                URL uRL = context.getNode().getURL();
                int n4 = CodeEditorGutter.getLineForContext((Context)context);
                this.toggleBookmark(uRL, n4, n);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        int n2 = BookmarkConstants.getCmdIDToggleBookmarkNumber((int)ideAction.getCommandId());
        BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager();
        if (n == BookmarkConstants.TOGGLE_BOOKMARK_CMD_ID || n2 != -1) {
            Worksheet worksheet = null;
            View view = context.getView();
            if (view != null) {
                if (view instanceof CodeEditor) {
                    return false;
                }
                if (view instanceof Worksheet) {
                    worksheet = (Worksheet)view;
                } else if (view instanceof CodeEditorGutterView) {
                    if (!(view.owner() instanceof Worksheet)) {
                        return false;
                    }
                    worksheet = (Worksheet)view.owner();
                }
            }
            ideAction.setEnabled(worksheet != null);
            return true;
        }
        return false;
    }

    private WorksheetBookmark getBookmark(URL uRL, int n) {
        Collection collection = BookmarkManager.getBookmarkManager().getAllBookmarks();
        for (Bookmark bookmark : collection) {
            WorksheetBookmark worksheetBookmark;
            if (!(bookmark instanceof WorksheetBookmark) || (worksheetBookmark = (WorksheetBookmark)bookmark).getLine() != n || !worksheetBookmark.getURL().equals(uRL)) continue;
            return worksheetBookmark;
        }
        return null;
    }

    private void toggleBookmark(URL uRL, int n, int n2) {
        int n3;
        BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager();
        WorksheetBookmark worksheetBookmark = this.getBookmark(uRL, n);
        int n4 = n3 = worksheetBookmark == null ? -1 : bookmarkManager.getBookmarkNumber((Bookmark)worksheetBookmark);
        if (worksheetBookmark != null && (n2 == -1 || n3 == n2)) {
            bookmarkManager.removeBookmark((Bookmark)worksheetBookmark);
            worksheetBookmark = null;
        } else if (worksheetBookmark == null) {
            worksheetBookmark = new WorksheetBookmark(uRL, n);
            bookmarkManager.addBookmark((Bookmark)worksheetBookmark);
        }
        if (worksheetBookmark != null && n2 != -1) {
            bookmarkManager.setBookmarkNumber((Bookmark)worksheetBookmark, n2);
        }
    }
}

