/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeNode;
import oracle.dbtools.worksheet.commands.autotrace.NodeRenderer;
import oracle.dbtools.worksheet.commands.autotrace.PopupAction;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class ComparisonPanel
extends AbstractPanel {
    private AutotracePanel src1;
    private AutotracePanel src2;
    private Map<Integer, Integer> nonZeroValuedRow2ActualRow = new HashMap<Integer, Integer>();
    JTextField filterWidget;
    private JTreeTable tbl1;
    private JTreeTable tbl2;
    AutotraceTreeModel mdl1;
    AutotraceTreeModel mdl2;

    public ComparisonPanel(AutotracePanel autotracePanel, AutotracePanel autotracePanel2) {
        super(autotracePanel.getID() != null && autotracePanel2.getID() != null ? autotracePanel.getID() + autotracePanel2.getID() : null, "Compare " + autotracePanel.getTabLabel() + " with " + autotracePanel2.getTabLabel());
        this.src1 = autotracePanel;
        this.src2 = autotracePanel2;
        int n = -1;
        for (int n2 : autotracePanel.mystatsData.values.keySet()) {
            if (oracle.dbtools.raptor.SerializedData.getInstance().abbrevStat && autotracePanel.mystatsData.values.get(n2) == 0L && autotracePanel2.mystatsData.values.get(n2) == 0L) continue;
            this.nonZeroValuedRow2ActualRow.put(++n, n2);
        }
        this.init();
    }

    private void init() {
        JComponent jComponent;
        JComponent jComponent2;
        this.mdl1 = ComparisonPanel.newAutotraceModel(this.src1, this.src2.getATMdl());
        this.mdl2 = ComparisonPanel.newAutotraceModel(this.src2, this.src1.getATMdl());
        this.tbl1 = this.init(this.mdl1);
        this.tbl2 = this.init(this.mdl2);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)this.tbl1, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tbl2, gridBagConstraints);
        jPanel.setAlignmentX(0.0f);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        Color color = this.tbl1.getBackground();
        jPanel.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.tbl1.getTableHeader());
        jPanel2.add(this.tbl2.getTableHeader());
        this.add((Component)jPanel2, "North");
        if (this.src1.isExplainPlan || this.src2.isExplainPlan) {
            this.add((Component)jScrollPane, "Center");
        } else {
            jComponent2 = new JTable(this.buildComparisonModel());
            jComponent = new JScrollPane(jComponent2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 3));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel4.add("V$STATNAME Name", new JLabel(OracleIcons.getIcon((String)"filter.png")));
            jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
            this.filterWidget = new JTextField(20);
            this.filterWidget.addKeyListener(new KeyAdapter((JTable)jComponent2){
                final /* synthetic */ JTable val$cmpstats;
                {
                    this.val$cmpstats = jTable;
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    ComparisonPanel.this.nonZeroValuedRow2ActualRow = null;
                    this.val$cmpstats.revalidate();
                }
            });
            jPanel4.add(this.filterWidget);
            jPanel3.add(jPanel4);
            jPanel3.add(jComponent);
            JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel3);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(SerializedData.getInstance().dividerLocation);
            this.add((Component)jSplitPane, "Center");
        }
        this.initToolbar();
        jComponent2 = new JCheckBox(Messages.getString("ComparisonPanel.CascadeDiff"));
        jComponent2.setToolTipText(Messages.getString("ComparisonPanel.CascadeDiffTooltip"));
        ((AbstractButton)jComponent2).addActionListener(new ActionListener(){
            final /* synthetic */ JCheckBox val$cascade;
            {
                this.val$cascade = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((AutotraceTreeNode)ComparisonPanel.this.src1.getATMdl().getRoot()).cascadeDiff = this.val$cascade.isSelected();
                ((AutotraceTreeNode)ComparisonPanel.this.src2.getATMdl().getRoot()).cascadeDiff = this.val$cascade.isSelected();
                ComparisonPanel.this.mdl1.cloneTreeAndMarkDiffs();
                ComparisonPanel.this.mdl2.cloneTreeAndMarkDiffs();
                ComparisonPanel.this.mdl1.reload(ComparisonPanel.this.tbl1.getTree());
                ComparisonPanel.this.mdl2.reload(ComparisonPanel.this.tbl2.getTree());
            }
        });
        this._toolbar.add((Component)jComponent2);
        jComponent = new JCheckBox(Messages.getString("ComparisonPanel.IgnorePred"));
        jComponent.setToolTipText(Messages.getString("ComparisonPanel.IgnorePredTooltip"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){
            final /* synthetic */ JCheckBox val$ignore;
            {
                this.val$ignore = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((AutotraceTreeNode)ComparisonPanel.this.src1.getATMdl().getRoot()).ignorePredicates = this.val$ignore.isSelected();
                ((AutotraceTreeNode)ComparisonPanel.this.src2.getATMdl().getRoot()).ignorePredicates = this.val$ignore.isSelected();
                ComparisonPanel.this.mdl1.cloneTreeAndMarkDiffs();
                ComparisonPanel.this.mdl2.cloneTreeAndMarkDiffs();
                ComparisonPanel.this.mdl1.reload(ComparisonPanel.this.tbl1.getTree());
                ComparisonPanel.this.mdl2.reload(ComparisonPanel.this.tbl2.getTree());
            }
        });
        this._toolbar.add((Component)jComponent);
        this.tbl1.addMouseListener((MouseListener)new PopupAction(this.tbl1, this.mdl1, this.tbl2, this.mdl2));
        this.tbl2.addMouseListener((MouseListener)new PopupAction(this.tbl1, this.mdl1, this.tbl2, this.mdl2));
    }

    private JTreeTable init(AutotraceTreeModel autotraceTreeModel) {
        JTreeTable jTreeTable = new JTreeTable((TreeTableModel)autotraceTreeModel);
        jTreeTable.setAutoResizeMode(0);
        jTreeTable.setCellSelectionEnabled(false);
        jTreeTable.setColumnSelectionAllowed(false);
        jTreeTable.setRowSelectionAllowed(false);
        autotraceTreeModel.reload(jTreeTable.getTree());
        for (int i = 1; i < jTreeTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = jTreeTable.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(this.src1.cellRenderer);
        }
        JTree jTree = jTreeTable.getTree();
        jTree.setCellRenderer(new NodeRenderer(jTreeTable));
        jTree.setShowsRootHandles(true);
        SerializedData.initColumnWidths(jTreeTable);
        return jTreeTable;
    }

    private static AutotraceTreeModel newAutotraceModel(AutotracePanel autotracePanel, AutotraceTreeModel autotraceTreeModel) {
        AutotraceTreeModel autotraceTreeModel2 = new AutotraceTreeModel(autotracePanel, autotraceTreeModel){

            @Override
            public List<String> displayedColumns() {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("OPERATION");
                return arrayList;
            }
        };
        return autotraceTreeModel2;
    }

    private TableModel buildComparisonModel() {
        return new AbstractTableModel(){

            public int nonFilteredNonZeroValuedRowsCount() {
                if (ComparisonPanel.this.nonZeroValuedRow2ActualRow == null) {
                    this.calculateNonZeroValuedRow2ActualRow();
                }
                return ComparisonPanel.this.nonZeroValuedRow2ActualRow.size();
            }

            public void calculateNonZeroValuedRow2ActualRow() {
                ComparisonPanel.this.nonZeroValuedRow2ActualRow = new HashMap<Integer, Integer>();
                int n = -1;
                for (int n2 : ComparisonPanel.this.src1.mystatsData.values.keySet()) {
                    if (oracle.dbtools.raptor.SerializedData.getInstance().abbrevStat && ComparisonPanel.this.src1.mystatsData.values.get(n2) == 0L || !ComparisonPanel.this.src1.mystatsData.names.get(n2).contains(ComparisonPanel.this.filterWidget.getText())) continue;
                    ComparisonPanel.this.nonZeroValuedRow2ActualRow.put(++n, n2);
                }
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return "V$STATNAME Name";
                }
                if (n == 1) {
                    return "V$MYSTAT Value " + ComparisonPanel.this.src1.getTabLabel();
                }
                return "V$MYSTAT Value " + ComparisonPanel.this.src2.getTabLabel();
            }

            @Override
            public int getRowCount() {
                return this.nonFilteredNonZeroValuedRowsCount();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                Long l = null;
                Integer n3 = ComparisonPanel.this.nonZeroValuedRow2ActualRow.get(n);
                if (n2 == 0) {
                    return AutotracePanel.colorize(ComparisonPanel.this.src1.mystatsData.names.get(n3), ComparisonPanel.this.filterWidget.getText());
                }
                l = n2 == 1 ? ComparisonPanel.this.src1.mystatsData.values.get(n3) : ComparisonPanel.this.src2.mystatsData.values.get(n3);
                return this.colorize(l, n3);
            }

            private Object colorize(Object object, int n) {
                if (ComparisonPanel.this.src1.mystatsData.values.get(n).equals(ComparisonPanel.this.src2.mystatsData.values.get(n))) {
                    return object;
                }
                return "<html><font color=red>" + object + "</font></html>";
            }
        };
    }

    @Override
    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        return new JMenuItem[0];
    }
}

