/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.newscriptrunner.Clearable;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Utility;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.CommandsResources;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractWorksheetResultPanel
extends JPanel
implements WorksheetResultPanel,
Clearable {
    protected int SAVE_CMD_ID = 11;
    protected static final int PRINT_CMD_ID = 16;
    protected int CLEAR_CMD_ID = 20;
    protected static final int PIN_CMD_ID = 68;
    protected static final int DELETE_GRID_SETTINGS_ID = Ide.findOrCreateCmdID((String)"Results.DeleteGridSettings");
    protected static final int SQL_ID = Ide.findOrCreateCmdID((String)"Results.SQL");
    protected static final int RUN_OUTPUT_CMD_ID = Ide.findOrCreateCmdID((String)"worksheet.run_output_as_script");
    protected int NULL_CMD_ID = -123456;
    protected static URL m_lastSaveURL = null;
    protected IStatusMessageConsumer _statusMessageConsumer = null;
    protected String _lastStatusMessage = "";
    protected JPanel _mainPanel = null;
    protected Toolbar _toolbar = null;
    protected JPanel _resultsPanel = null;
    protected boolean m_isPinned = false;
    protected ToggleToolButton _pinToggle;
    private WorksheetContext m_ctx;
    public static final String ACCEL_FILE = "oracle/dbtools/worksheet/accelerators.xml";
    private boolean updatingKeyMap;
    private ChangeListener myKeystrokeChangeListener;

    public AbstractWorksheetResultPanel() {
        this.setLayout(new GridBagLayout());
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._mainPanel, gridBagConstraints);
        this.initCommands();
        this.initToolBar();
        final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this.myKeystrokeChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == keyStrokeOptions) {
                    AbstractWorksheetResultPanel.this.updateKeyMap(keyStrokeOptions);
                }
            }
        };
        keyStrokeOptions.addChangeListener(this.myKeystrokeChangeListener);
        this.updateKeyMap(keyStrokeOptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this._mainPanel.add((Component)this._toolbar, gridBagConstraints);
        this._resultsPanel = new JPanel();
        this._resultsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this._mainPanel.add((Component)this._resultsPanel, gridBagConstraints);
    }

    @Override
    public void setContext(WorksheetContext worksheetContext) {
        this.m_ctx = worksheetContext;
    }

    @Override
    public WorksheetContext getContext() {
        return this.m_ctx;
    }

    protected Toolbar getToolBar() {
        return this._toolbar;
    }

    protected void initToolBar() {
        Icon icon;
        this._toolbar = new Toolbar();
        if (68 != this.NULL_CMD_ID && this.isCloseable()) {
            icon = this.m_isPinned ? RaptorImagesArb.getIcon((String)"PINNED") : OracleIcons.getIcon((String)"pin.png");
            ToggleAction toggleAction = new ToggleAction(Messages.getString("AbstractWorksheetResultPanel.1"), icon){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    Icon icon = AbstractWorksheetResultPanel.this.m_isPinned ? OracleIcons.getIcon((String)"pin.png") : RaptorImagesArb.getIcon((String)"PINNED");
                    AbstractWorksheetResultPanel.this._pinToggle.setIcon(icon);
                    AbstractWorksheetResultPanel.this.m_isPinned = !AbstractWorksheetResultPanel.this.m_isPinned;
                    this.setState(AbstractWorksheetResultPanel.this.isPinned());
                }
            };
            toggleAction.setName(toggleAction.getValue("Name").toString());
            this.setupAcceleratorToolTip(toggleAction, 68);
            this._pinToggle = this._toolbar.addToggleButton(toggleAction);
            toggleAction.setState(this.isPinned());
            this._pinToggle.setIcon(icon);
        }
        if (this.CLEAR_CMD_ID != this.NULL_CMD_ID) {
            icon = null;
            icon = new ToggleAction(CommandsResources.get("CLEAR_LABEL"), CommandsResources.getIcon("CLEAR_ICON")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractWorksheetResultPanel.this.clear();
                }
            };
            icon.setName(icon.getValue("Name").toString());
            this.setupAcceleratorToolTip((ToggleAction)icon, this.CLEAR_CMD_ID);
            this._toolbar.add((ToggleAction)icon);
        }
        if (this.SAVE_CMD_ID != this.NULL_CMD_ID) {
            icon = null;
            icon = new ToggleAction(CommandsResources.get("SAVE_FILE"), CommandsResources.getIcon("SAVE_ICON")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractWorksheetResultPanel.this.saveOutput();
                }
            };
            icon.setName(icon.getValue("Name").toString());
            this.setupAcceleratorToolTip((ToggleAction)icon, this.SAVE_CMD_ID);
            this._toolbar.add((ToggleAction)icon);
        }
        if (16 != this.NULL_CMD_ID) {
            icon = null;
            icon = new ToggleAction(CommandsResources.get("PRINT_FILE"), CommandsResources.getIcon("PRINT_ICON")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractWorksheetResultPanel.this.printOutput();
                }
            };
            icon.setName(icon.getValue("Name").toString());
            this.setupAcceleratorToolTip((ToggleAction)icon, 16);
            this._toolbar.add((ToggleAction)icon);
        }
    }

    @Override
    public boolean isPinned() {
        return this.m_isPinned;
    }

    @Override
    public void setPinned(boolean bl) {
        if (bl != this.m_isPinned) {
            this._pinToggle.doClick();
        }
    }

    protected abstract void initCommands();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveFile(URL uRL) {
        m_lastSaveURL = uRL;
        String string = this.getEncoding();
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(uRL.getPath());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            String string2 = this.getOutputText();
            if (string2 != null) {
                outputStreamWriter.write(string2);
            }
            outputStreamWriter.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("AbstractWorksheetResultPanel.2"), (String)(uRL.getPath() + uRL.getFile()), null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        return false;
    }

    public boolean saveOutput() {
        int n = 0;
        URLFileChooser uRLFileChooser = null;
        uRLFileChooser = m_lastSaveURL != null ? new URLFileChooser(m_lastSaveURL) : new URLFileChooser();
        n = uRLFileChooser.showSaveDialog((Component)this);
        if (n == 0) {
            URL uRL = uRLFileChooser.getSelectedURL();
            return this.saveFile(uRL);
        }
        return n != 1;
    }

    public boolean printOutput() {
        return Utility.printText((String)this.getTabLabel(), (String)this.getOutputText());
    }

    protected String buildToolTip(int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(AbstractWorksheetResultPanel.getKeyStrokeContext());
        if (keyStrokeMap == null) {
            return stringBuffer.toString();
        }
        List list = keyStrokeMap.getKeyStrokesFor(n);
        if (list != null && list.size() > 0) {
            KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
            stringBuffer.append(" (");
            for (int i = 0; i < keyStrokes.getLength(); ++i) {
                KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                if (keyStroke == null) continue;
                String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("+");
                }
                stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected void setupAcceleratorToolTip(ToggleAction toggleAction, int n) {
        List list;
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(AbstractWorksheetResultPanel.getKeyStrokeContext());
        if (keyStrokeMap == null) {
            return;
        }
        List list2 = list = toggleAction instanceof IdeAction ? keyStrokeMap.getKeyStrokesFor(((IdeAction)toggleAction).getCommandId()) : keyStrokeMap.getKeyStrokesFor(n);
        if (list != null && list.size() > 0) {
            KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(" (");
            for (int i = 0; i < keyStrokes.getLength(); ++i) {
                KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                if (keyStroke == null) continue;
                String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("+");
                }
                stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                if (toggleAction instanceof IdeAction) {
                    ((IdeAction)toggleAction).putValueDirectly("AcceleratorKey", (Object)keyStroke);
                    continue;
                }
                toggleAction.putValue("AcceleratorKey", (Object)keyStroke);
            }
            stringBuffer.append(")");
            if (toggleAction instanceof IdeAction) {
                ((IdeAction)toggleAction).putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            } else {
                toggleAction.putValue("last-tooltip-suffix", (Object)stringBuffer.toString());
            }
        }
        if (toggleAction instanceof IdeAction) {
            this.getActionMap().put(((IdeAction)toggleAction).getCommandId(), (Action)toggleAction);
        } else {
            this.getActionMap().put(n, (Action)toggleAction);
        }
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        this.updateKeyMap(this, keyStrokeOptions);
    }

    private void updateKeyMap(JComponent jComponent, KeyStrokeOptions keyStrokeOptions) {
        if (!this.updatingKeyMap) {
            this.updatingKeyMap = true;
            MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)AbstractWorksheetResultPanel.getKeyStrokeContext());
            jComponent.setInputMap(1, (InputMap)multiInputMap);
            this.updatingKeyMap = false;
        }
    }

    private static KeyStrokeContext getKeyStrokeContext() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        return keyStrokeContextRegistry.getContext(ACCEL_FILE);
    }

    private static void registerKeyStrokeContext(KeyStrokeOptions keyStrokeOptions) {
        KeyStrokeContext keyStrokeContext = AbstractWorksheetResultPanel.getKeyStrokeContext();
        keyStrokeOptions.removeContext(keyStrokeContext);
        keyStrokeOptions.addContext(keyStrokeContext);
        keyStrokeOptions.solvePostponedMaps();
    }

    public abstract void clear();

    public abstract String getConnectionName();

    public abstract String getSQL();

    public abstract String getOutputText();

    public String getEncoding() {
        return IdeUtil.getIdeEncoding();
    }

    public URL getLastSaveURL() {
        return m_lastSaveURL;
    }

    public String getLastStatusMessage() {
        String string = this._lastStatusMessage;
        this._lastStatusMessage = null;
        return string;
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
        this._statusMessageConsumer = iStatusMessageConsumer;
    }

    public void publishStatusMessage(String string, Exception exception) {
        this._lastStatusMessage = string;
        if (this._statusMessageConsumer != null) {
            this._statusMessageConsumer.setStatusMessage(string, exception);
        }
    }

    public boolean isAppendable() {
        return false;
    }

    @Override
    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        return new JMenuItem[0];
    }

    static {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        AbstractWorksheetResultPanel.registerKeyStrokeContext(keyStrokeOptions);
    }
}

