/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import oracle.olap.OLAPArb;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperImpl;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.syntaxbuilder.documentation.Documentation;
import oracle.olap.syntaxbuilder.documentation.JTextPaneDocRenderer;
import oracle.olap.syntaxbuilder.editor.SyntaxChecker;
import oracle.olap.syntaxbuilder.editor.SyntaxCodeEditor;
import oracle.olap.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerHelper;
import oracle.olap.syntaxbuilder.editor.plugins.TemplateHandlerEmbedEditorPlugin;
import oracle.olap.syntaxbuilder.parsetree.ParseJTree;
import oracle.olap.syntaxbuilder.searchablelist.SearchableList;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandlerPopup;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;
import oracle.olap.syntaxbuilder.spectree.SpecJTree;

public class SyntaxBuilderPanel
extends JPanel {
    public static final Dimension treeSize = new Dimension(250, 200);
    public static final String TEMPLATE = "TEMPLATE_KEY";
    private static final int dividerSize = 8;
    private final transient ErrorDisplay errorDisplay;
    private final SyntaxCodeEditor editor;
    private final Properties props;
    private final transient Spec spec;
    private final transient TemplateHandler templateHandler;
    private SearchableList searchableList;
    private SpecJTree tree;
    private Container templateContainer;

    public SyntaxBuilderPanel(Properties properties, Spec spec, SyntaxParser syntaxParser, FetchIcon fetchIcon, ErrorDisplay errorDisplay) throws SQLException, IOException {
        this(properties, spec, syntaxParser, fetchIcon, errorDisplay, null);
    }

    public SyntaxBuilderPanel(Properties properties, Spec spec, SyntaxParser syntaxParser, FetchIcon fetchIcon, ErrorDisplay errorDisplay, InsertionHandlerHelper insertionHandlerHelper) throws SQLException, IOException {
        super(new BorderLayout());
        this.spec = spec;
        this.props = properties;
        this.errorDisplay = errorDisplay;
        InsertionHandlerEditorPlugin insertionHandlerEditorPlugin = new InsertionHandlerEditorPlugin(syntaxParser);
        insertionHandlerEditorPlugin.setInsertHelper(insertionHandlerHelper);
        insertionHandlerEditorPlugin.setSpec(spec);
        CalcSelectionEditorPlugin calcSelectionEditorPlugin = new CalcSelectionEditorPlugin(spec, syntaxParser, properties);
        boolean bl = Boolean.parseBoolean(properties.getProperty("POPUPPANEL"));
        JPanel jPanel = null;
        if (bl) {
            this.templateHandler = new TemplateHandlerPopup(insertionHandlerEditorPlugin, spec, this);
        } else {
            this.templateContainer = new TemplateContainerPanel();
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.templateContainer, "South");
            this.templateHandler = new TemplateHandlerEmbedEditorPlugin(insertionHandlerEditorPlugin, spec, this.templateContainer);
        }
        this.editor = new SyntaxCodeEditor(insertionHandlerEditorPlugin, this.templateHandler, calcSelectionEditorPlugin, syntaxParser, spec, fetchIcon, properties);
        this.editor.addCodeSelectionListener(this.templateHandler);
        if (bl) {
            jPanel = this.editor;
        } else {
            jPanel.add((Component)this.editor, "Center");
        }
        if (properties.containsKey("SYNTAX")) {
            insertionHandlerEditorPlugin.insertSyntax(new TemplateData(properties.getProperty("SYNTAX")));
        }
        Documentation documentation = null;
        if (Boolean.valueOf(properties.getProperty("VISIBLE_DOCS", Boolean.toString(true))).booleanValue()) {
            documentation = new Documentation(new JTextPaneDocRenderer(spec));
        }
        this.searchableList = null;
        if (Boolean.valueOf(properties.getProperty("VISIBLE_SYNTAXDETAIL", Boolean.toString(true))).booleanValue()) {
            this.searchableList = new SearchableList(this.templateHandler);
        }
        JComponent jComponent = null;
        ParseJTree parseJTree = null;
        if (Boolean.valueOf(properties.getProperty("VISIBLE_SYNTAXSPEC", Boolean.toString(true))).booleanValue()) {
            this.tree = new SpecJTree(spec, errorDisplay, false, Boolean.parseBoolean(properties.getProperty("SHOW_LEAVES", Boolean.toString(true))));
            parseJTree = new ParseJTree(this.editor.getParseTreeModel(), spec);
            parseJTree.setShuttleHandler(this.templateHandler);
            parseJTree.getSelectionModel().addTreeSelectionListener(this.editor);
            jComponent = this.buildTreeTabs(this.tree, parseJTree);
        }
        if (documentation != null) {
            this.editor.addCodeSelectionListener(documentation);
        }
        if (documentation != null && this.searchableList != null) {
            this.searchableList.addListSelectionListener(documentation);
        }
        if (this.tree != null && this.searchableList != null) {
            this.tree.getSelectionModel().addTreeSelectionListener(this.searchableList);
        }
        JComponent jComponent2 = null;
        jComponent2 = jComponent != null && this.searchableList != null ? this.buildLeftSplit(jComponent, this.searchableList) : (jComponent == null && this.searchableList != null ? this.searchableList : jComponent);
        JComponent jComponent3 = null;
        jComponent3 = documentation != null ? this.buildEditorTabs(documentation, jPanel) : jPanel;
        if (jComponent2 == null) {
            this.add((Component)jComponent3, "Center");
        } else {
            this.add((Component)this.buildMainSplit(jComponent2, jComponent3), "Center");
        }
    }

    public void initialize() {
        Object object;
        this.spec.initialize();
        this.templateHandler.addEditorButtons(this.spec.getButtonNodes());
        if (this.spec.getDefaultSelection() != null && this.tree != null) {
            this.tree.reload();
            object = new TreePath(this.spec.getDefaultSelection().getPath());
            if (!this.tree.isShowLeaves() && this.spec.getDefaultSelection().isLeaf()) {
                object = ((TreePath)object).getParentPath();
            }
            this.tree.setSelectionPath((TreePath)object);
            if (this.searchableList != null) {
                this.searchableList.setSelectedItem(this.spec.getDefaultSelection());
            }
        }
        if (this.searchableList != null && this.tree == null) {
            object = this.spec.getFullInsertableList();
            ArrayList<SpecTreeNode> arrayList = new ArrayList<SpecTreeNode>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TemplateGroup templateGroup;
                String string;
                SpecTreeNode specTreeNode = (SpecTreeNode)iterator.next();
                TemplateHelperImpl templateHelperImpl = (TemplateHelperImpl)specTreeNode.getTemplateHelper();
                if (templateHelperImpl != null && (string = (templateGroup = templateHelperImpl.getTemplateGroup()).getType()) != null && string.equalsIgnoreCase("default")) continue;
                arrayList.add(specTreeNode);
            }
            this.searchableList.setElements(arrayList);
            this.searchableList.setSelectedItem(this.spec.getDefaultSelection());
        }
    }

    private JTabbedPane buildEditorTabs(Documentation documentation, JPanel jPanel) {
        final JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.addTab(OLAPArb.getString("EXPRESSION_EDITOR_EDITOR_TAB_TITLE"), jPanel);
        if (documentation.getKey() == null) {
            jTabbedPane.addTab(OLAPArb.getString("EXPRESSION_EDITOR_HELP_TAB_TITLE0"), documentation);
        } else {
            jTabbedPane.addTab(OLAPArb.format("EXPRESSION_EDITOR_HELP_TAB_TITLE1", documentation.getKey()), documentation);
        }
        documentation.addPropertyChangeListener("TITLE_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jTabbedPane.setTitleAt(1, OLAPArb.format("EXPRESSION_EDITOR_HELP_TAB_TITLE1", (String)propertyChangeEvent.getNewValue()));
            }
        });
        return jTabbedPane;
    }

    private JTabbedPane buildTreeTabs(SpecJTree specJTree, ParseJTree parseJTree) {
        JScrollPane jScrollPane = new JScrollPane(specJTree);
        JScrollPane jScrollPane2 = new JScrollPane(parseJTree);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(OLAPArb.getString("EXPRESSION_EDITOR.EXPRESSIONTREE"), jScrollPane);
        jTabbedPane.add(OLAPArb.getString("EXPRESSION_EDITOR.PARSETREE"), jScrollPane2);
        return jTabbedPane;
    }

    private JComponent buildLeftSplit(JComponent jComponent, SearchableList searchableList) {
        JSplitPane jSplitPane = new JSplitPane(0, jComponent, searchableList);
        jSplitPane.setDividerSize(8);
        jSplitPane.setDividerLocation(Integer.parseInt(this.props.getProperty("LEFT_DIVIDER_POSITION", "200")));
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SyntaxBuilderPanel.this.props.setProperty("LEFT_DIVIDER_POSITION", String.valueOf(propertyChangeEvent.getNewValue()));
            }
        });
        return jSplitPane;
    }

    private JSplitPane buildMainSplit(JComponent jComponent, JComponent jComponent2) {
        jComponent.setMinimumSize(new Dimension(0, 0));
        jComponent2.setMinimumSize(new Dimension(0, 0));
        JSplitPane jSplitPane = new JSplitPane(1, jComponent, jComponent2);
        jSplitPane.setDividerSize(8);
        jSplitPane.setOneTouchExpandable(Boolean.parseBoolean(this.props.getProperty("ONETOUCH_EXPANDABLE", Boolean.toString(true))));
        int n = Integer.parseInt(this.props.getProperty("CENTER_DIVIDER_POSITION", "250"));
        jSplitPane.setDividerLocation(n);
        jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SyntaxBuilderPanel.this.props.setProperty("CENTER_DIVIDER_POSITION", String.valueOf(propertyChangeEvent.getNewValue()));
            }
        });
        return jSplitPane;
    }

    public String getSyntax() {
        return this.editor.getSyntax();
    }

    public boolean isSyntaxValid() throws SQLException, IOException {
        return this.editor.isSyntaxValid();
    }

    public void addSyntaxChecker(SyntaxChecker syntaxChecker) {
        this.editor.addSyntaxChecker(syntaxChecker);
    }

    public String getText() {
        return this.getSyntax();
    }

    public void setText(String string) {
        this.editor.insertSyntax(new TemplateData(string, TemplateData.Mode.REPLACEALL), null, false);
    }

    public Template getMatchingTemplate() throws SQLException, IOException {
        ParseNode parseNode = (ParseNode)this.editor.getParseTreeModel().getRoot();
        if (parseNode == null || parseNode.getChildCount() == 0) {
            return null;
        }
        SpecTreeNode specTreeNode = this.spec.findMatchingNode(parseNode = (ParseNode)parseNode.getFirstChild());
        if (specTreeNode == null || specTreeNode.getTemplateHelper() == null) {
            return null;
        }
        return specTreeNode.getTemplateHelper().getTemplate();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.editor.setEnabled(bl);
        this.templateContainer.setEnabled(bl);
        if (this.searchableList != null) {
            this.searchableList.setEnabled(bl);
        }
        if (this.tree != null) {
            this.tree.setEnabled(bl);
        }
    }

    public void addCodeEditorTextListener(CodeEditorTextListener codeEditorTextListener) {
        this.editor.addCodeEditorTextListener(codeEditorTextListener);
    }

    public void removeCodeEditorTextListener(CodeEditorTextListener codeEditorTextListener) {
        this.editor.removeCodeEditorTextListener(codeEditorTextListener);
    }

    private class TemplateContainerPanel
    extends JPanel {
        public TemplateContainerPanel() {
            super(new BorderLayout(0, 0));
        }

        @Override
        protected void addImpl(Component component, Object object, int n) {
            super.addImpl(component, object, n);
            boolean bl = this.isEnabled();
            this.setComponentsEnabled(this, bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setComponentsEnabled(this, bl);
        }

        private void setComponentsEnabled(Container container, boolean bl) {
            Component[] componentArray;
            for (Component component : componentArray = container.getComponents()) {
                if (component instanceof Container) {
                    this.setComponentsEnabled((Container)component, bl);
                }
                component.setEnabled(bl);
            }
        }
    }
}

