/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.db.view.GeneralBaseEditorPanel;
import oracle.olap.security.ACEAccessSettingPanel;
import oracle.olap.security.AccessControlEntry;
import oracle.olap.security.DimensionDataSecurityPanel;
import oracle.olap.security.RealmConstraint;
import oracle.olap.security.RealmConstraintInitializer;
import oracle.olap.security.UserSelectionDialog;

public class GeneralDataSecurityPanel
extends GeneralBaseEditorPanel<RealmConstraint> {
    private JLabel m_memberSelectionChoiceLabel;
    private JRadioButton m_memberSelectionRadioButton;
    private JRadioButton m_DMLSelectionRadioButton;
    private JTextField descTxtFld;
    private ACEAccessSettingPanel m_aceAccessPanel;
    private RealmConstraint realmConstraint;
    private String labelText;
    private Connection connection;
    private Window parent;
    private DimensionDataSecurityPanel securityPanel;
    private Resources resources = new OLAPResources();
    public static final String USERS = "Users";
    public static final String ROLES = "Roles";
    public static final String DSACL = "DSACL";

    public GeneralDataSecurityPanel() {
        this.layoutComponents();
        this.setDbObjectInitializer(new RealmConstraintInitializer());
    }

    public GeneralDataSecurityPanel(Connection connection, Window window, DimensionDataSecurityPanel dimensionDataSecurityPanel) {
        this.parent = window;
        this.connection = connection;
        this.securityPanel = dimensionDataSecurityPanel;
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.registerDescriptionFields();
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("GeneralDataSecurityPanel.topPanel");
        int n = this.layoutDescriptionFields(jPanel);
        this.add(jPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_memberSelectionChoiceLabel = new JLabel(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_CHOOSE_LABEL"));
        jPanel.add((Component)this.m_memberSelectionChoiceLabel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_memberSelectionRadioButton = new JRadioButton(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_MEMBER_SELECTION_LABEL"));
        this.m_DMLSelectionRadioButton = new JRadioButton(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_DML_EXPRESSION_LABEL"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_memberSelectionRadioButton);
        buttonGroup.add(this.m_DMLSelectionRadioButton);
        jPanel.add((Component)this.m_memberSelectionRadioButton, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_DMLSelectionRadioButton, new GridBagConstraints(2, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_aceAccessPanel = new ACEAccessSettingPanel((JPanel)((Object)this));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.add(jPanel2, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JButton jButton = new JButton(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_ADD_USER_BUTTON"));
        JButton jButton2 = new JButton(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_REMOVE_USER_BUTTON"));
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)jButton);
        buttonBar.add((Component)jButton2);
        jPanel2.add((Component)this.m_aceAccessPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 3, 0), 0, 0));
        jPanel2.add((Component)buttonBar, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 15, 2, new Insets(5, 0, 3, 0), 0, 0));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralDataSecurityPanel.this.m_aceAccessPanel.removeRowFromTable();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<String> list = GeneralDataSecurityPanel.this.m_aceAccessPanel.getCurrentUsersInTable();
                List<String> list2 = GeneralDataSecurityPanel.this.m_aceAccessPanel.getCurrentRolesInTable();
                List<String> list3 = GeneralDataSecurityPanel.this.m_aceAccessPanel.getCurrentDSACLsInTable();
                UserSelectionDialog userSelectionDialog = new UserSelectionDialog(GeneralDataSecurityPanel.this.connection, GeneralDataSecurityPanel.this.parent, list, list2, list3, true);
                userSelectionDialog.setVisible(true);
                List<UserSelectionDialog.UserNode> list4 = userSelectionDialog.getSelection();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (UserSelectionDialog.UserNode userNode : list4) {
                    int n = userNode.getType();
                    String string = userNode.getName();
                    if (userNode.isUserType()) {
                        arrayList.add(string);
                        continue;
                    }
                    if (n == 2) {
                        arrayList2.add(string);
                        continue;
                    }
                    if (n != 3) continue;
                    arrayList3.add(string);
                }
                GeneralDataSecurityPanel.this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList, GeneralDataSecurityPanel.USERS);
                GeneralDataSecurityPanel.this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList2, GeneralDataSecurityPanel.ROLES);
                GeneralDataSecurityPanel.this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList3, GeneralDataSecurityPanel.DSACL);
            }
        });
        this.m_memberSelectionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralDataSecurityPanel.this.realmConstraint.setRealmConditionType("MEMBER_SELECTION_TYPE");
            }
        });
        this.m_DMLSelectionRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralDataSecurityPanel.this.realmConstraint.setRealmConditionType("DML_SELECTION_TYPE");
            }
        });
        this.m_memberSelectionRadioButton.setSelected(true);
    }

    @Override
    protected int layoutDescriptionFields(JPanel jPanel) {
        int n = 0;
        JLabel jLabel = this.getDescriptionLabel();
        this.descTxtFld = this.getDescriptionFld();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 12), 0, 0));
        jPanel.add((Component)this.descTxtFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        return ++n;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.connection = oracleDatabaseImpl.getConnection();
        this.parent = window;
        this.realmConstraint = (RealmConstraint)this.getUpdatedObject();
        String string = this.realmConstraint.getDescription();
        this.descTxtFld.setText(string);
        this.updateACLRealmDetails(this.realmConstraint);
    }

    private void updateACLRealmDetails(RealmConstraint realmConstraint) {
        AccessControlEntry[] accessControlEntryArray;
        String string = realmConstraint.getRealmConditionType();
        if (string == null) {
            accessControlEntryArray = realmConstraint.getRealmCondition();
            if (accessControlEntryArray.contains("OLAP_DML_EXPRESSION")) {
                realmConstraint.setRealmConditionType("DML_SELECTION_TYPE");
            } else {
                realmConstraint.setRealmConditionType("MEMBER_SELECTION_TYPE");
            }
        }
        accessControlEntryArray = realmConstraint.getAces();
        this.m_aceAccessPanel.initialiseFieldsFast(this.connection);
        this.m_aceAccessPanel.fillGridWithPrivilegeInfo(accessControlEntryArray, 1);
        String string2 = realmConstraint.getParentObject();
        if (string2 != null && string2.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList, DSACL);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        RealmConstraint realmConstraint = (RealmConstraint)this.getUpdatedObject();
        this.setData(realmConstraint);
    }

    public void setData(RealmConstraint realmConstraint) {
        String string = realmConstraint.getName();
        List<AccessControlEntry> list = this.m_aceAccessPanel.getACEList();
        AccessControlEntry[] accessControlEntryArray = new AccessControlEntry[list.size()];
        accessControlEntryArray = list.toArray(accessControlEntryArray);
        realmConstraint.clearAces();
        for (AccessControlEntry accessControlEntry : list) {
            String string2 = accessControlEntry.getACL();
            if (string2 != null && string2.length() > 0) {
                realmConstraint.setParentObject(string2);
                continue;
            }
            accessControlEntry.setACL(string);
            realmConstraint.addAce(accessControlEntry);
        }
        realmConstraint.setACLName(string);
    }

    @Override
    public boolean isAnalyticWorkspaceRequired() {
        return false;
    }
}

