/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.olap.app.Resources;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateListHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.data.DimensionMetadataContext;

public class DimensionMemberSelectionPanel
extends JPanel
implements PropertyChangeListener {
    private Database database;
    private TemplateListHyperView templateListHyperView;
    private DimensionMetadataContext dimMetadataContext;
    private Resources resources;
    private FetchIcon fetchIcon;
    private List<PropertyChangeListener> listeners;

    public DimensionMemberSelectionPanel() {
        this.listeners = new ArrayList<PropertyChangeListener>();
    }

    public DimensionMemberSelectionPanel(DimensionMetadataContext dimensionMetadataContext, Resources resources, FetchIcon fetchIcon) throws SQLException, IOException {
        this.dimMetadataContext = dimensionMetadataContext;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.database = new DatabaseImpl();
        this.database.setConnection(dimensionMetadataContext.getDatabase().getConnection());
        this.setupTemplates(this.database);
    }

    public void setDimensionMetadataContext(DimensionMetadataContext dimensionMetadataContext) {
        this.dimMetadataContext = dimensionMetadataContext;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public void setFetchIcon(FetchIcon fetchIcon) {
        this.fetchIcon = fetchIcon;
    }

    public void setupTemplates() throws SQLException, IOException {
        if (this.dimMetadataContext != null) {
            this.database = new DatabaseImpl();
            this.database.setConnection(this.dimMetadataContext.getDatabase().getConnection());
            this.setupTemplates(this.database);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("VALUE_CHANGED") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_ADDED") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_REMOVED")) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public String getExpression() throws SQLException, IOException {
        return this.templateListHyperView.getExpression();
    }

    private void setupTemplates(Database database) throws SQLException, IOException {
        boolean bl = false;
        TemplateHyperContextImpl templateHyperContextImpl = new TemplateHyperContextImpl(this.dimMetadataContext.getDatabase().getConnection(), this.resources, this.fetchIcon, TemplateHyperContext.ResizeMode.LEGACY);
        this.dimMetadataContext.getDimension().getSchema().setLoaded(true);
        TemplateContext templateContext = new TemplateContext(database, new TemplateMetadata(this.dimMetadataContext.getDimension()));
        this.templateListHyperView = new TemplateListHyperView(templateContext, templateHyperContextImpl, DimensionMemberSelectionPanel.class, "/oracle/olap/security/dimsecuritycondition.xml");
        this.templateListHyperView.addPropertyChangeListener(this);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridLayout());
        this.add(this.templateListHyperView.getPanel());
    }
}

