/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.Frame;
import java.sql.Connection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractDropMeasureAction;
import oracle.olap.actions.DropMeasureAction;
import oracle.olap.actions.DropMeasureHelper;
import oracle.olap.actions.DropOLAPChildObjectDialog;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.panels.CubeMeasureTableEditorPanel;
import oracle.olap.db.view.OLAPBaseChildTablePanel;
import oracle.olap.util.CubeMeasureDependencyCheck;

public class CubeMeasureTablePanel<C extends CubeMeasure, P extends Cube>
extends OLAPBaseChildTablePanel<C, P> {
    private final int MEASURE_NAME_COLUMN = 0;
    private final int DEFAULT_MEASURE_COLUMN = 4;
    private static final String HELP_ID = "olap_drop_object";
    MyCellEditor myCellEditor;
    private CubeMeasureDependencyCheck dependencyCheck;

    public CubeMeasureTablePanel() {
        super("CubeMeasureTablePanel");
        this.init();
    }

    public CubeMeasureTablePanel(String string) {
        super(string);
        this.init();
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        JSplitPane jSplitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerLocation(275);
        return jSplitPane;
    }

    @Override
    protected void init() {
        this.setNameColumnIndex(0);
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("measures", OLAPArb.getString("CUBE_MEASURES"));
    }

    protected String getChildProperty() {
        return "measures";
    }

    protected Class getChildClass() {
        return CubeMeasure.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return new CubeMeasureTableEditorPanel();
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.myCellEditor = new MyCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        int n = this.getNameColumnIndex();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(this.myCellEditor);
        int n2 = this.getDescriptionColumnIndex();
        TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
        tableColumn2.setCellEditor(this.myCellEditor);
        int n3 = this.getShortLabelColumnIndex();
        TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
        tableColumn3.setCellEditor(this.myCellEditor);
        int n4 = this.getLongLabelColumnIndex();
        TableColumn tableColumn4 = tableColumnModel.getColumn(n4);
        tableColumn4.setCellEditor(this.myCellEditor);
        DefaultMeasureCellRenderer defaultMeasureCellRenderer = new DefaultMeasureCellRenderer();
        TableColumn tableColumn5 = tableColumnModel.getColumn(4);
        tableColumn5.setCellRenderer(defaultMeasureCellRenderer);
        if (this.isEditing()) {
            Connection connection = ((Database)this.getProvider()).getConnection();
            this.dependencyCheck = new CubeMeasureDependencyCheck(connection, ((Cube)this.getUpdatedObject()).getSchema().getName(), ((Cube)this.getUpdatedObject()).getAnalyticWorkspace());
        }
    }

    @Override
    protected void initialiseTableComponents() {
        super.initialiseTableComponents();
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                CubeMeasureTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((CubeMeasure)c).isDefault();
            }

            public boolean isCellEditable(C c) {
                return !((CubeMeasure)c).isDefault();
            }
        };
        this.addColumn(4, OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"), Boolean.class, nonPropertyColumnLogic);
    }

    @Override
    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        int n3 = componentWrapperTableModel.getRowCount();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        CubeMeasure cubeMeasure = (CubeMeasure)rowInfo.getRowObject();
        switch (n2) {
            case 4: {
                Boolean bl = (Boolean)object;
                cubeMeasure.setDefault(bl);
                if (bl.booleanValue()) {
                    for (int i = 0; i < n3; ++i) {
                        if (i == n) continue;
                        componentWrapperTableModel.setValueAt((Object)Boolean.FALSE, i, n2);
                    }
                    componentWrapperTableModel.fireTableRowsUpdated(0, n3 - 1);
                }
                GenericTable genericTable = this.getWrapperTable();
                genericTable.repaint();
                break;
            }
            default: {
                super.setRowPropertyValue(object, n, n2);
            }
        }
    }

    @Override
    public C newChild() {
        CubeMeasure cubeMeasure = (CubeMeasure)super.newChild();
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        int n = componentWrapperTableModel.getRowCount();
        if (n == 0) {
            cubeMeasure.setDefault(true);
        }
        cubeMeasure.setDataType("NUMBER");
        cubeMeasure.setMeasureAllowAutoDataTypeChange(true);
        cubeMeasure.generateDescriptions();
        ((Cube)this.getUpdatedObject()).addMeasure(cubeMeasure);
        return (C)cubeMeasure;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        if (this.isEditing()) {
            ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
            ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
            CubeMeasure cubeMeasure = (CubeMeasure)rowInfo.getRowObject();
            String string = cubeMeasure.getName();
            List<Measure> list = this.dependencyCheck.getMeasureDependencies(((Cube)this.getUpdatedObject()).getName(), string);
            if (list.isEmpty()) {
                return true;
            }
            DropMeasureAction dropMeasureAction = new DropMeasureAction();
            DropMeasureHelper dropMeasureHelper = new DropMeasureHelper(OLAPArb.format("DROP_MEASURE_TITLE", string), string, ((Cube)this.getUpdatedObject()).getName(), ((Cube)this.getUpdatedObject()).getSchema().getName(), dropMeasureAction, true, list);
            JPanel jPanel = ((AbstractDropMeasureAction)dropMeasureAction).getDropMeasurePanel(string, list, null);
            DropOLAPChildObjectDialog dropOLAPChildObjectDialog = new DropOLAPChildObjectDialog((Frame)Ide.getMainWindow(), dropMeasureHelper.getTitle(), jPanel, dropMeasureHelper, HELP_ID);
            dropOLAPChildObjectDialog.setModal(true);
            dropOLAPChildObjectDialog.setVisible(true);
            if (dropOLAPChildObjectDialog.getUserSelection() == 0) {
                return false;
            }
        }
        return true;
    }

    class MyCellEditor
    extends OLAPBaseChildTablePanel.MyBaseCellEditor {
        public MyCellEditor() {
            super(CubeMeasureTablePanel.this);
        }

        @Override
        public boolean stopCellEditing() {
            int n = CubeMeasureTablePanel.this.getNameColumnIndex();
            if (this.column == n) {
                boolean bl = true;
                String string = null;
                Cube cube = ((CubeMeasure)this.abstractChildObjectWithDesc).getCube();
                String string2 = this.abstractChildObjectWithDesc.getName();
                String string3 = this.cellTextField.getText();
                try {
                    CubeMeasureTablePanel.this.prov.validateName("MEASURE", string3);
                }
                catch (InvalidNameException invalidNameException) {
                    string = invalidNameException.getMessage();
                    bl = false;
                }
                if (bl) {
                    String string4 = CubeMeasureTablePanel.this.prov.getInternalName(string3);
                    if (cube.findMeasure(string4) != null && !string4.equals(string2)) {
                        string = OLAPArb.format("CUBE_MEASURE_ERROR_DUPLICATE_NAME", string4);
                        bl = false;
                    } else if (cube.findMeasure(string2) != null && !string4.equals(string2)) {
                        cube.propagateRenameToExpressions(string2, string4, true);
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)OLAPArb.get("CUBE_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string2);
                    return bl;
                }
                CubeMeasureTablePanel.this.upcaseNameFlag = true;
            }
            return super.stopCellEditing();
        }
    }

    private class DefaultMeasureCellRenderer
    extends DefaultTableCellRenderer {
        DefaultMeasureCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setToolTipText(OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"));
            if (object != null) {
                if (object == Boolean.TRUE) {
                    jLabel.setIcon(OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_SUCCESS"));
                    jLabel.setText(null);
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(null);
                }
            }
            JLabel jLabel2 = jLabel;
            return jLabel2;
        }
    }
}

