/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.graphic.IlvPolygon;
import ilog.views.interactor.IlvMakePolyPointsInteractor;
import ilog.views.interactor.IlvPolyPointsObjectFactory;
import java.awt.Graphics;

public class IlvMakePolygonInteractor
extends IlvMakePolyPointsInteractor
implements IlvPolyPointsObjectFactory {
    private int a = 4;
    private static final int b = 2;
    private static final int c = 4;

    public IlvMakePolygonInteractor() {
        this.setObjectFactory(this);
    }

    @Override
    public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
        IlvPolygon ilvPolygon = new IlvPolygon(ilvPointArray);
        ilvPolygon.setFillOn(this.isFillOn());
        ilvPolygon.setStrokeOn(this.isStrokeOn());
        return ilvPolygon;
    }

    @Override
    protected void drawGhost(Graphics graphics) {
        if (this.isOpaqueMode()) {
            super.drawGhost(graphics);
        } else {
            int n = this.count();
            if (n == 2) {
                IlvPoint[] ilvPointArray = this.getPoints(true);
                graphics.drawLine((int)Math.floor(ilvPointArray[0].x), (int)Math.floor(ilvPointArray[0].y), (int)Math.floor(ilvPointArray[1].x), (int)Math.floor(ilvPointArray[1].y));
            } else if (n > 2) {
                if (this.isFillOn()) {
                    IlvGraphicUtil.FillPolygon(graphics, this.getPoints(true), n, null);
                } else {
                    IlvGraphicUtil.DrawPolygon(graphics, this.getPoints(true), n, null);
                }
            }
        }
    }

    public boolean isFillOn() {
        return (this.a & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.a = bl ? (this.a |= 4) : (this.a &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.a & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.a = bl ? (this.a |= 2) : (this.a &= 0xFFFFFFFD);
    }
}

