/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.IlvTextDocument;
import ilog.views.appframe.swing.IlvPanelView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IlvTextView
extends IlvPanelView {
    JEditorPane a = null;
    public static final String PASTE_COMMAND = "Paste";
    public static final String CUT_COMMAND = "Cut";
    public static final String COPY_COMMAND = "Copy";
    public static final String SELECT_ALL_COMMAND = "SelectAll";

    @Override
    public void initializeView(IlvDocument ilvDocument) {
        this.setEnabled(ilvDocument != null);
        this.a();
        this.a.setEditable(ilvDocument != null);
        if (ilvDocument == null) {
            this.a.setDocument(new PlainDocument());
            return;
        }
        this.a.setDocument(this.getTextDocument());
        this.validate();
    }

    protected Document getTextDocument() {
        if (this.getDocument() instanceof IlvTextDocument) {
            return ((IlvTextDocument)this.getDocument()).getTextDocument();
        }
        return null;
    }

    JEditorPane a() {
        if (this.a != null) {
            return this.a;
        }
        this.a = this.createEditorPane();
        this.addEditorPane(this.a);
        return this.a;
    }

    protected void addEditorPane(JEditorPane jEditorPane) {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, "Center");
        this.initializeEditorPane(this.a);
        jScrollPane.getViewport().add(this.a);
    }

    protected JEditorPane createEditorPane() {
        return new JEditorPane();
    }

    protected void initializeEditorPane(JEditorPane jEditorPane) {
        jEditorPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                IlvApplication ilvApplication = IlvTextView.this.getApplication();
                if (ilvApplication != null) {
                    ilvApplication.updateAction(IlvTextView.CUT_COMMAND);
                    ilvApplication.updateAction(IlvTextView.COPY_COMMAND);
                    ilvApplication.updateAction(IlvTextView.PASTE_COMMAND);
                }
            }
        });
    }

    @Override
    public boolean isProcessingAction(String string) {
        block3: {
            block2: {
                if (string.equals(CUT_COMMAND)) break block2;
                if (string.equals(COPY_COMMAND)) break block2;
                if (string.equals(PASTE_COMMAND)) break block2;
                if (!string.equals(SELECT_ALL_COMMAND)) break block3;
            }
            return true;
        }
        return super.isProcessingAction(string);
    }

    @Override
    public boolean updateAction(Action action) {
        String string;
        block7: {
            block8: {
                string = (String)action.getValue("ActionCommandKey");
                if (string == null) break block7;
                if (string.equals(CUT_COMMAND)) break block8;
                if (!string.equals(COPY_COMMAND)) break block7;
            }
            action.setEnabled(this.a != null && this.a.getSelectionEnd() != this.a.getSelectionStart());
            return true;
        }
        if (string != null) {
            if (string.equals(PASTE_COMMAND)) {
                IlvApplication ilvApplication = this.getApplication();
                if (ilvApplication != null && !ilvApplication.isApplet()) {
                    Clipboard clipboard = this.getToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(this);
                    action.setEnabled(transferable != null);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
        }
        return super.updateAction(action);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        IlvApplication ilvApplication = this.getApplication();
        if (!ilvApplication.isApplet()) {
            if (actionEvent.getActionCommand().equals(CUT_COMMAND)) {
                this.a.cut();
                if (this.getApplication() != null) {
                    this.getApplication().updateAction(PASTE_COMMAND);
                }
                return;
            }
            if (actionEvent.getActionCommand().equals(COPY_COMMAND)) {
                this.a.copy();
                if (this.getApplication() != null) {
                    this.getApplication().updateAction(PASTE_COMMAND);
                }
                return;
            }
            if (actionEvent.getActionCommand().equals(PASTE_COMMAND)) {
                this.a.paste();
                return;
            }
        }
        if (actionEvent.getActionCommand().equals(SELECT_ALL_COMMAND)) {
            this.a.selectAll();
            return;
        }
        super.actionPerformed(actionEvent);
    }
}

