/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.importer.IImportTester;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportGenHelper;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.deployment.DbmsCloudAPI;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;

public class ImportGenDbmsCloud
implements IImportTester,
IImportGenerator {
    public static final String NAME = ImportDataFormat.METHOD_CLOUD_LOAD_NAME;
    public static final int TYPE = 5;
    private static final String AND = " AND ";
    private static final String CLOSEP = ")";
    private static final String COMMA = ",";
    private static final String CREDENTIAL_NAME = "credential_name => ";
    private static final String TAB = "\\t";
    private static final String FILE_URI_LIST = "file_uri_list => ";
    private static final String NL = "\n";
    private static final String SINGLEQ = "'";
    private static final String SPACE = " ";
    private static final String VALUE = " value ";
    private static final Version VERSION18 = new Version("18.0");
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private boolean _isValid = false;
    private boolean _isSendToWorksheet = false;
    private String _tableName;
    private String _stagingTableName;
    private String _xTableName;
    private BigDecimal _operationId;
    private Version _destVersion;
    private boolean _isBadRows = false;
    private boolean _isLogRows = false;
    private boolean _isDataRows = false;
    private ArrayList<String> _badFileNames;
    private String _xTabBad;
    private String _xTabLog;
    private int _loadMethod;
    private DbmsCloudAPI _cloudAPI;
    public static final String dbms_cloudCreateExternalTablePrefix = "{call ";
    public static final String dbms_cloudCreateExternalTableSuffix = " }";
    public static final String dbms_cloudGetXTabCount1 = "select count(*) from ";
    public static final String dbms_cloudGetXTabCount2 = " where rownum = ";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Integer getType() {
        return 5;
    }

    @Override
    public ImportGenModel getGenModel() {
        return this._iGenModel;
    }

    @Override
    public void setGenModel(ImportGenModel iGenModel) {
        this._iGenModel = iGenModel;
    }

    @Override
    public IToolRunMode getRunMode() {
        return this._iGenModel.getRunMode();
    }

    @Override
    public void setRunMode(IToolRunMode iRunMode) {
        this._iGenModel.setRunMode(iRunMode);
    }

    public boolean isCancel() {
        return this._iGenModel.isCancel();
    }

    public void isCancel(boolean value) {
        this._iGenModel.isCancel(value);
    }

    @Override
    public boolean start(ImportProperties iProps, ImportGenModel iGenModel) {
        return this.start(iProps, iGenModel, false);
    }

    @Override
    public boolean start(ImportProperties iProps, ImportGenModel iGenModel, boolean isConnClone) {
        if (iProps == null || iGenModel == null) {
            return false;
        }
        this._iProps = iProps;
        this._iGenModel = iGenModel;
        this._tableName = this._iGenModel.getTableName();
        this._stagingTableName = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        this._loadMethod = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        this._xTableName = this._loadMethod == 3 || this._loadMethod == 5 ? this._iGenModel.addUser(this._stagingTableName) : this._iGenModel.addUser(this._iGenModel.addDoubleQuote(this._tableName));
        this._isSendToWorksheet = this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET);
        this._isDataRows = false;
        this._isLogRows = false;
        this._isBadRows = false;
        this._operationId = null;
        this._isValid = this._iGenModel.isExitCodeSuccess();
        return this._isValid;
    }

    @Override
    public boolean process() {
        if (!this._isValid) {
            return false;
        }
        this._iGenModel.isCancel(this.doImport());
        String msg = this._iGenModel.getTaskFullName() + ". ";
        if (this._iGenModel.isExitCodeSuccess() && !this._iGenModel.isCancel()) {
            msg = msg + ImportResources.getString("TASK_SUCCEEDED_AND_COMMITTED");
        } else {
            msg = msg + ImportResources.getString("TASK_CANCELLED_ROLLBACK");
            msg = msg + SPACE + this._iGenModel.getExitCode().getShortMessage() + SPACE + this._iGenModel.getExitCode().getMessage();
        }
        return this._iGenModel.isExitCodeSuccess();
    }

    public boolean doImport() {
        boolean cancelled = false;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this._iGenModel.initELogger();
            this._iGenModel.eLogImportMessages();
        }
        try {
            cancelled = this._isSendToWorksheet ? this.generateScript() : this.generateExec();
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        return cancelled;
    }

    private boolean generateScript() {
        StringBuffer sql = new StringBuffer();
        sql.append("SET DEFINE OFF\n");
        if (!(this._iGenModel.isExistingTable() || this._loadMethod != 3 && this._loadMethod != 5)) {
            sql.append(this._iGenModel.getCreateTableStatementWithComments() + NL);
        }
        if (this._loadMethod == 5) {
            sql.append(this.getCloudAPI().getCopyDataStatement(this._tableName, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), (String)this._iProps.get(ImportKeys.OSS_PATH), this._iGenModel.getSchemaName(), this.getFields(), this.getFormat()));
        }
        String output = sql.toString();
        output = output.replaceAll("\\r", "");
        this._iGenModel.streamPrintln(output);
        Logger.info(this.getClass(), (String)ImportResources.getString("INFO_TO_WS"));
        return this._iGenModel.isExitCodeSuccess();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateExec() {
        boolean isCancelled = false;
        try {
            boolean isStaging = this._loadMethod == 3 || this._loadMethod == 5;
            boolean useValidate = this._iProps.getValueBoolean(ImportKeys.USE_VALIDATE);
            boolean useValidateLimit = this._iProps.getValueBoolean(ImportKeys.USE_VALIDATE_LIMIT);
            BigDecimal validateLimit = null;
            if (useValidateLimit) {
                validateLimit = new BigDecimal(this._iProps.getValueInteger(ImportKeys.VALIDATE_LIMIT));
            }
            this._iProps.getValueBoolean(ImportKeys.DROP_STAGING_TABLE);
            boolean isCopyLog = this._iProps.getValueBoolean(ImportKeys.IS_COPY_LOG);
            boolean isCopyBad = this._iProps.getValueBoolean(ImportKeys.IS_COPY_BAD);
            boolean isDropBadAndLog = this._iProps.getValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG);
            this._operationId = null;
            String operationPrefix = null;
            if (!this._iGenModel.isExistingTable() && isStaging) {
                this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_CREATE_TABLE"));
                if (!this._iGenModel.doCreateTable()) {
                    return true;
                }
                this._iGenModel.checkCanProceed();
            }
            if (this._loadMethod == 5) {
                operationPrefix = "COPY$";
                this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_COPY_DATA"));
                try {
                    String copyData = this.getCloudAPI().getCopyDataProcedure(this._tableName, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), (String)this._iProps.get(ImportKeys.OSS_PATH), this._iGenModel.getSchemaName(), this.getFields(), this.getFormat());
                    this._operationId = this.getCloudAPI().doCopy(copyData);
                    this._iGenModel.checkCanProceed();
                }
                catch (SQLException e) {
                    this._iGenModel.setExitCode(this._cloudAPI.getExitCode());
                    this._operationId = this._cloudAPI.getLastOperationId();
                    isCancelled = false;
                }
                this._isDataRows = this.getCloudAPI().isDataRows(this._tableName);
                this._iGenModel.checkCanProceed();
            } else {
                operationPrefix = "VALIDATE$";
                this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_CREATE_XTABLE"));
                String createXTab = this.getExtCreateTableStatement();
                try {
                    this.createExternalTable(createXTab);
                    this._isDataRows = this.getCloudAPI().isDataRows(this._xTableName);
                    this._iGenModel.checkCanProceed();
                }
                catch (SQLException e) {
                    this._iGenModel.streamPrintln(ImportResources.format("VAL_FAILED", e.getMessage()));
                    isCancelled = false;
                }
                if (useValidate) {
                    this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_VAL_XTABLE"));
                    try {
                        this._operationId = this.validateExternalTable(this._xTableName, this._iGenModel.getSchemaName(), validateLimit);
                        this._iGenModel.checkCanProceed();
                    }
                    catch (SQLException e) {
                        this._iGenModel.setExitCode(this._cloudAPI.getExitCode());
                        this._operationId = this._cloudAPI.getLastOperationId();
                        isCancelled = false;
                    }
                }
            }
            if (this._operationId != null) {
                this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_RESULTS"));
                this._xTabLog = operationPrefix + this._operationId + "_LOG";
                this._xTabBad = operationPrefix + this._operationId + "_BAD";
                this._badFileNames = new ArrayList();
                ArrayList<String> logFileNames = new ArrayList<String>();
                String source = (String)this._iProps.get(ImportKeys.OSS_PATH);
                this._isLogRows = this.logXTabLog(this._xTabLog, this._badFileNames, logFileNames);
                this._iGenModel.checkCanProceed();
                this._isBadRows = this.logXTabBad(this._xTabBad);
                this._iGenModel.checkCanProceed();
                if (this._isBadRows && isCopyBad && !this._badFileNames.isEmpty()) {
                    this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_COPY_BAD"));
                    try {
                        this.putObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), source, this._badFileNames, true);
                        this._iGenModel.checkCanProceed();
                    }
                    catch (SQLException e) {
                        isCancelled = false;
                    }
                }
                if (isCopyLog) {
                    this._iGenModel.setProgress(ImportResources.getString("TASK_PROGRESS_COPY_LOG"));
                    try {
                        this.putObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), source, logFileNames, false);
                        this._iGenModel.checkCanProceed();
                    }
                    catch (SQLException e) {
                        isCancelled = false;
                    }
                }
                if (!isDropBadAndLog) {
                    // empty if block
                }
            } else {
                this._iGenModel.streamPrintln(ImportResources.getString("VAL_NOT_AVAILABLE"));
            }
            this.logIsDataRows(this._tableName);
            if (this._operationId == null) return isCancelled;
            this._iGenModel.streamPrintln(SPACE);
            if (!isDropBadAndLog) {
                this._iGenModel.streamPrintln(ImportResources.format("VAL_XTAB_LOG", this._xTabLog));
            }
            if (isDropBadAndLog) return isCancelled;
            this._iGenModel.streamPrintln(ImportResources.format("VAL_XTAB_BAD", this._xTabBad));
            return isCancelled;
        }
        catch (ExecutionException ee) {
            return isCancelled;
        }
    }

    private String getExtCreateTableStatement() {
        ArrayList<String> col2 = this.getColumns();
        StringBuffer cols = new StringBuffer();
        String separator = NL;
        for (String col : col2) {
            cols.append(separator + col);
            separator = ",\n";
        }
        String xTableName = this._loadMethod == 3 || this._loadMethod == 5 ? this._iGenModel.addUser(this._stagingTableName) : this._iGenModel.addUser(this._iGenModel.addDoubleQuote(this._tableName));
        return this.getCloudAPI().getExtCreateTableStatement(xTableName, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), (String)this._iProps.get(ImportKeys.OSS_PATH), this._iGenModel.getSchemaName(), cols.toString(), this.getFormat());
    }

    public String getColumnsAsString() {
        ArrayList<String> col2 = this.getColumns();
        StringBuffer cols = new StringBuffer();
        String separator = "";
        for (String col : col2) {
            cols.append(separator + col);
            separator = ", ";
        }
        return cols.toString();
    }

    private ArrayList<String> getColumns() {
        String[] colList = ImportGenHelper.formatTableColumns(this._iProps, this._loadMethod == 3 && this._iGenModel.isExistingTable());
        ArrayList<String> col2 = new ArrayList<String>();
        for (String c : colList) {
            col2.add(c.replaceAll("NOT NULL", ""));
        }
        return col2;
    }

    private void appendCredential(StringBuffer sql) {
        this._iProps.get(ImportKeys.OSS_CREDENTIAL);
        sql.append(CREDENTIAL_NAME);
        sql.append(SINGLEQ + (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL) + SINGLEQ);
        sql.append(COMMA);
    }

    private void appendFileUri(StringBuffer sql) {
        sql.append(FILE_URI_LIST);
        sql.append(SINGLEQ + this._iProps.get(ImportKeys.OSS_PATH) + SINGLEQ);
        sql.append(COMMA);
    }

    public String getFields() {
        return this.getFields(NL);
    }

    public String getFields(String spacing) {
        return this.getFields(spacing, false);
    }

    public String getFields(String spacing, boolean force) {
        return this.getFields(spacing, false, false);
    }

    public String getFields(String spacing, boolean force, boolean isDbmsCloud) {
        StringBuffer sql = new StringBuffer();
        this.appendFields(sql, spacing, force, isDbmsCloud);
        return sql.toString();
    }

    private void appendFields(StringBuffer sql, String spacing, boolean force, boolean isDbmsCloud) {
        if (force || this._iGenModel.isExistingTable()) {
            Object separator = spacing;
            ArrayList<String> fields = new ArrayList<String>();
            if (this._iGenModel.isExistingTable()) {
                ImportGenHelper.genFieldsFromLoadFile(fields, this._iProps, this._iGenModel.isExistingTable(), isDbmsCloud);
            }
            if (!fields.isEmpty()) {
                for (String col : fields) {
                    sql.append((String)separator + col);
                    separator = COMMA + spacing;
                }
            }
        }
    }

    private void appendFormat(StringBuffer sql) {
        sql.append("format => ");
        sql.append(this.getFormat());
    }

    public String getFormat() {
        boolean truncate;
        boolean blank;
        Integer missingFields;
        String mask;
        this._destVersion = VersionTracker.getDbVersion((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)this._iGenModel.getConn()));
        StringBuffer sql = new StringBuffer();
        sql.append("json_object(");
        sql.append("'delimiter'");
        ImportDataFormat dataFormat = this._iGenModel.getDataFormat();
        Object fieldDelimiter = BaseDataFormat.getDelimiterString(dataFormat.getDelimiter());
        fieldDelimiter = fieldDelimiter == null || ((String)fieldDelimiter).equals("") ? "','" : (((String)fieldDelimiter).equals("X'09'") ? "'\\\\t'" : SINGLEQ + (String)fieldDelimiter + SINGLEQ);
        if (VERSION18.compareTo(this._destVersion) <= 0) {
            fieldDelimiter = ((String)fieldDelimiter).replace("\\\\", "\\");
        }
        sql.append(VALUE + (String)fieldDelimiter);
        String recTerm = this.formatString(BaseDataFormat.getRecordTerminatorString(dataFormat.getRecordTerminator()));
        if (VERSION18.compareTo(this._destVersion) <= 0) {
            recTerm = recTerm.replace("\\\\", "\\");
        }
        String newline = BaseDataFormat.singleQuote(BaseDataFormat.singleQuote(BaseDataFormat.singleQuote(recTerm)));
        sql.append(", ");
        sql.append("'recorddelimiter'");
        sql.append(VALUE);
        sql.append(newline);
        Integer skipRows = this._iGenModel.getDataFormat().isHeader() ? dataFormat.getSkipRows() + 1 : dataFormat.getSkipRows();
        if (skipRows != 0) {
            sql.append(", ");
            sql.append("'skipheaders'");
            sql.append(VALUE);
            sql.append(SINGLEQ + skipRows.toString() + SINGLEQ);
        }
        if ((mask = (String)this._iProps.get(ImportKeys.DATE_MASK_DATE)) != null && !mask.isEmpty()) {
            sql.append(", ");
            sql.append("'dateformat'");
            sql.append(VALUE);
            sql.append(SINGLEQ + mask + SINGLEQ);
        }
        if ((mask = (String)this._iProps.get(ImportKeys.DATE_MASK_TIMESTAMP)) != null && !mask.isEmpty()) {
            sql.append(", ");
            sql.append("'timestampformat'");
            sql.append(VALUE);
            sql.append(SINGLEQ + mask + SINGLEQ);
        }
        if ((mask = (String)this._iProps.get(ImportKeys.DATE_MASK_TIMESTAMPTZ)) != null && !mask.isEmpty()) {
            sql.append(", ");
            sql.append("'timestamptzformat'");
            sql.append(VALUE);
            sql.append(SINGLEQ + mask + SINGLEQ);
        }
        if ((mask = (String)this._iProps.get(ImportKeys.DATE_MASK_TIMESTAMPLTZ)) != null && !mask.isEmpty()) {
            sql.append(", ");
            sql.append("'timestampltzformat'");
            sql.append(VALUE);
            sql.append(SINGLEQ + mask + SINGLEQ);
        }
        String enclLeft = dataFormat.getEnclosureLeftValue();
        String enclRight = dataFormat.getEnclosureRightValue();
        String formattedEncl = this.formatString(enclLeft);
        if (formattedEncl.length() != 0) {
            sql.append(", ");
            sql.append("'quote'");
            sql.append(VALUE);
            if (!enclRight.equals(enclLeft)) {
                sql.append("'''" + formattedEncl + "''");
                sql.append(" AND ''" + this.formatString(enclRight) + "'''");
            } else {
                sql.append(SINGLEQ + formattedEncl + SINGLEQ);
            }
        }
        if (this._iProps.getValueBoolean(ImportKeys.USE_REJECT_LIMIT).booleanValue()) {
            sql.append(", ");
            sql.append("'rejectlimit'");
            sql.append(VALUE);
            sql.append(SINGLEQ + this._iProps.getValueInteger(ImportKeys.REJECT_LIMIT).toString() + SINGLEQ);
        } else {
            sql.append(", ");
            sql.append("'rejectlimit'");
            sql.append(VALUE);
            if (this._iProps.get(ImportKeys.TEST_ROWS) == null) {
                sql.append("'UNLIMITED'");
            } else {
                BigDecimal testRows = (BigDecimal)this._iProps.get(ImportKeys.TEST_ROWS);
                sql.append(SINGLEQ + testRows.toBigInteger().toString() + SINGLEQ);
            }
        }
        Integer trim = this._iProps.getValueInteger(ImportKeys.TRIM);
        String trimValue = null;
        if (trim != null) {
            switch (trim) {
                case 0: {
                    trimValue = "notrim";
                    break;
                }
                case 1: {
                    trimValue = "ltrim";
                    break;
                }
                case 2: {
                    trimValue = "rtrim";
                    break;
                }
                case 3: {
                    trimValue = "lrtrim";
                }
            }
            if (trimValue != null) {
                sql.append(", ");
                sql.append("'trimspaces'");
                sql.append(VALUE);
                sql.append(SINGLEQ + trimValue + SINGLEQ);
            }
        }
        Integer nullRows = this._iProps.getValueInteger(ImportKeys.NULL_ROWS);
        sql.append(", ");
        sql.append("'ignoreblanklines'");
        sql.append(VALUE);
        if (nullRows == 0) {
            sql.append("'true'");
        } else {
            sql.append("'false'");
        }
        Integer conversionErrors = this._iProps.getValueInteger(ImportKeys.CONVERSION_ERRORS);
        if (conversionErrors == 0) {
            sql.append(", ");
            sql.append("'conversionerrors'");
            sql.append(VALUE);
            sql.append("'store_null'");
        }
        if ((missingFields = this._iProps.getValueInteger(ImportKeys.MISSING_FIELDS)) == 0) {
            sql.append(", ");
            sql.append("'ignoremissingcolumns'");
            sql.append(VALUE);
            sql.append("'true'");
        }
        if (blank = this._iProps.getValueBoolean(ImportKeys.IS_BLANK_COLS).booleanValue()) {
            sql.append(", ");
            sql.append("'blankasnull'");
            sql.append(VALUE);
            sql.append("'true'");
        }
        if (truncate = this._iProps.getValueBoolean(ImportKeys.IS_TRUNCATE_COLS).booleanValue()) {
            sql.append(", ");
            sql.append("'truncatecol'");
            sql.append(VALUE);
            sql.append("'true'");
        }
        boolean isCharset = this._iProps.getValueBoolean(ImportKeys.IS_GENERATE_CHARSET);
        String charsetval = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (isCharset && charsetval != null && !charsetval.equals("")) {
            sql.append(", ");
            sql.append("'characterset'");
            sql.append(VALUE);
            sql.append(SINGLEQ + charsetval + SINGLEQ);
        }
        sql.append(CLOSEP);
        return sql.toString();
    }

    private String formatString(String str) {
        StringBuffer newStr = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\\' || c == '\'') {
                newStr.append("\\");
            }
            newStr.append(c);
        }
        return newStr.toString();
    }

    private void createExternalTable(String sql) throws SQLException {
        this.getCloudAPI().createExternalTable(sql);
    }

    public BigDecimal validateExternalTable(String tableName, String schemaName, BigDecimal rowCount) throws SQLException {
        return this.getCloudAPI().validateExternalTable(tableName, schemaName, rowCount);
    }

    public boolean logXTabLog(String xTabLogName, ArrayList<String> badFileNames, ArrayList<String> logFileNames) {
        return this.getCloudAPI().logXTabLog(xTabLogName, badFileNames, logFileNames);
    }

    public boolean logXTabBad(String xTabBadName) {
        return this.getCloudAPI().logXTabBad(xTabBadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCountXTab(String xTabName, String rowLimit) {
        String count = null;
        try {
            if (this._iGenModel.lockConnection()) {
                count = DBUtil.getInstance((Connection)this._iGenModel.getConn()).executeReturnOneCol(dbms_cloudGetXTabCount1 + xTabName + dbms_cloudGetXTabCount2 + rowLimit, Collections.EMPTY_MAP);
            }
        }
        finally {
            this._iGenModel.unlockConnection();
        }
        return count;
    }

    public void logIsDataRows(String tabName) {
        String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS");
        this._iGenModel.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_START", (Object[])new Object[]{DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_IS_DATA_ROWS", (Object[])new Object[]{tabName})}));
        if (this._isDataRows) {
            this._iGenModel.streamPrintln(DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_DATA_ROWS"));
        } else {
            this._iGenModel.streamPrintln(DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_NO_DATA_ROWS"));
        }
        this._iGenModel.streamPrintln(msg);
        this._iGenModel.streamPrintln(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_IS_DATA_ROWS", (Object[])new Object[]{tabName}) + NL}));
    }

    private void putObject(String credentialName, String source, ArrayList<String> putFileNames, boolean logAdvice) throws SQLException {
        this.getCloudAPI().putObject(credentialName, source, putFileNames, logAdvice);
    }

    public void deleteObject(String credentialName, String source, ArrayList<String> putFileNames) throws SQLException {
        this.getCloudAPI().deleteObject(credentialName, source, putFileNames);
    }

    public void deleteObject(String credentialName, String object) throws SQLException {
        this.getCloudAPI().deleteObject(credentialName, object);
    }

    private boolean dropTable(String tableName, String type, boolean log) {
        return this.getCloudAPI().dropTable(tableName, type, log);
    }

    private void deleteOperation(BigDecimal operationId) throws SQLException {
        this.getCloudAPI().deleteOperation(operationId);
    }

    public void putObject(String credentialName, String dest, FileInputStream contents) throws SQLException {
        this.getCloudAPI().putObject(credentialName, dest, (InputStream)contents);
    }

    @Override
    public String getStatusMsg() {
        boolean isOperationId;
        StringBuffer statusMsg = new StringBuffer();
        boolean isDataRows = this.isDataRows();
        boolean bl = isOperationId = this.getOperationId() != null;
        if (!isDataRows) {
            statusMsg.append(ImportResources.getString("TASK_FAILED_AND_COMMITTED") + NL);
            statusMsg.append(ImportResources.format("PREREQ_TEST_FAIL", ImportResources.getString("PREREQ_TEST_NO_DATA")));
            if (this.isBadRows()) {
                statusMsg.append("; " + ImportResources.getString("PREREQ_TEST_BAD_ROWS"));
            }
        } else if (!isOperationId) {
            statusMsg.append(ImportResources.getString("TASK_FAILED_AND_COMMITTED") + NL);
            statusMsg.append(ImportResources.format("PREREQ_TEST_FAIL", ImportResources.getString("PREREQ_TEST_VAL_FAILED")));
        } else if (!this.isLogRows()) {
            statusMsg.append(ImportResources.getString("TASK_FAILED_AND_COMMITTED") + NL);
            statusMsg.append(ImportResources.format("PREREQ_TEST_FAIL", ImportResources.getString("PREREQ_TEST_LOG_FAILED")));
            if (this.isBadRows()) {
                statusMsg.append("; " + ImportResources.getString("PREREQ_TEST_BAD_ROWS"));
            }
        } else if (this.isBadRows()) {
            statusMsg.append(ImportResources.getString("TASK_WARNING_AND_COMMITTED") + NL);
            statusMsg.append(ImportResources.format("PREREQ_TEST_WARN", ImportResources.getString("PREREQ_TEST_BAD_ROWS")));
        } else {
            statusMsg.append(ImportResources.getString("TASK_SUCCEEDED_AND_COMMITTED"));
        }
        return statusMsg.toString();
    }

    private DbmsCloudAPI getCloudAPI() {
        if (this._cloudAPI == null) {
            this._cloudAPI = new DbmsCloudAPI((ToolLogger)this._iGenModel.getStream());
            this._cloudAPI.setSchema(ImportGenHelper.getSchema(this._iProps));
            this._cloudAPI.isConnLocked(true);
            this._iGenModel.setExitCode(this._cloudAPI.startService(this._iGenModel.getConnName(), false));
        }
        return this._cloudAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(BigDecimal validateLimit) {
        block19: {
            if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
                return true;
            }
            this.start(this._iProps, this._iGenModel);
            if (!this._isValid) {
                return false;
            }
            LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            String inputFileName = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)this._iProps.get(ImportKeys.OSS_PATH) : loadFile.getName();
            GenericTable table = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            int loc = -1;
            loc = inputFileName.lastIndexOf("/");
            if (loc > 0) {
                inputFileName = inputFileName.substring(loc + 1);
            }
            table.getTable().getTablename();
            try {
                if (!this._iGenModel.lockConnectionForImport()) break block19;
                this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
                if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
                    this._iGenModel.streamPrintln(ImportResources.getString("TEST_NOT_SUPPORTED"));
                    boolean bl = false;
                    return bl;
                }
                boolean isStaging = this._loadMethod == 3 || this._loadMethod == 5;
                this._operationId = null;
                String operationPrefix = null;
                if (!this._iGenModel.isExistingTable() && isStaging) {
                    if (!this._iGenModel.doCreateTable()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.dropTable((String)this._iProps.get(ImportKeys.TABLE_NAME), null, false);
                }
                operationPrefix = "VALIDATE$";
                boolean useRejectLimitSave = this._iProps.getValueBoolean(ImportKeys.USE_REJECT_LIMIT);
                this._iProps.put(ImportKeys.USE_REJECT_LIMIT, false);
                this._iProps.put(ImportKeys.TEST_ROWS, validateLimit);
                String createXTab = this.getExtCreateTableStatement();
                this._iProps.put(ImportKeys.USE_REJECT_LIMIT, useRejectLimitSave);
                this._iProps.put(ImportKeys.TEST_ROWS, null);
                try {
                    this.createExternalTable(createXTab);
                    this._isDataRows = this.getCloudAPI().isDataRows(this._xTableName);
                }
                catch (SQLException e) {
                    boolean bl = false;
                    this._iGenModel.unlockConnectionForImport();
                    return bl;
                }
                try {
                    this._operationId = this.validateExternalTable(this._xTableName, this._iGenModel.getSchemaName(), validateLimit);
                }
                catch (SQLException e) {
                    boolean bl = false;
                    this._iGenModel.unlockConnectionForImport();
                    return bl;
                }
                if (this._operationId == null) {
                    this._iGenModel.streamPrintln(ImportResources.getString("VAL_NOT_AVAILABLE"));
                    boolean bl = false;
                    return bl;
                }
                String xTabLog = operationPrefix + this._operationId + "_LOG";
                String xTabBad = operationPrefix + this._operationId + "_BAD";
                this._iGenModel.streamPrintln(SPACE);
                this._iGenModel.streamPrintln(ImportResources.format("VAL_XTAB_LOG", xTabLog));
                this._iGenModel.streamPrintln(ImportResources.format("VAL_XTAB_BAD", xTabBad));
                this._badFileNames = new ArrayList();
                ArrayList<String> logFileNames = new ArrayList<String>();
                this._isLogRows = this.logXTabLog(xTabLog, this._badFileNames, logFileNames);
                this._isBadRows = this.logXTabBad(xTabBad);
                this.logIsDataRows(this._xTableName);
            }
            finally {
                this._iGenModel.unlockConnectionForImport();
            }
        }
        return true;
    }

    @Override
    public boolean isLogRows() {
        return this._isLogRows;
    }

    @Override
    public boolean isBadRows() {
        return this._isBadRows;
    }

    @Override
    public boolean isDataRows() {
        return this._isDataRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer getLogFromTest() {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        if (this._iGenModel.getStream() != null) {
            this._iGenModel.getStream().finished();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this._iGenModel.getStream().getLogName());
                String encoding = IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING");
                InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
                reader = new BufferedReader(isr);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line + NL);
                }
            }
            catch (IOException e) {
                Logger.warn(this.getClass(), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Logger.warn(this.getClass(), (Throwable)e);
                    }
                }
                this._iGenModel.setStream(null);
            }
        }
        return sb;
    }

    @Override
    public void cleanUpTest() {
        this.dropTable(this._xTableName, null, false);
        if (this._operationId != null) {
            try {
                this.deleteOperation(this._operationId);
            }
            catch (Exception e) {
                Logger.warn(this.getClass(), (Throwable)e);
            }
        }
    }

    @Override
    public String handleBadFileTest() {
        if (this._isBadRows && this._isBadRows && !this._badFileNames.isEmpty()) {
            ArrayList<String> badFileNames = new ArrayList<String>();
            badFileNames.add(this._badFileNames.get(0));
            String source = (String)this._iProps.get(ImportKeys.OSS_PATH);
            try {
                this.putObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), source, badFileNames, false);
            }
            catch (SQLException e) {
                return null;
            }
            return badFileNames.get(0);
        }
        return null;
    }

    @Override
    public void cleanupBadFileTest() {
        if (this._isBadRows && this._isBadRows && !this._badFileNames.isEmpty()) {
            ArrayList<String> badFileNames = new ArrayList<String>();
            badFileNames.add(this._badFileNames.get(0));
            String source = (String)this._iProps.get(ImportKeys.OSS_PATH);
            try {
                this.deleteObject((String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), source, badFileNames);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public BigDecimal getOperationId() {
        return this._operationId;
    }

    public String getXTabBad() {
        return this._xTabBad;
    }

    public String getXTabLog() {
        return this._xTabLog;
    }
}

