/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.SelectFilesConfiguration;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.op.ui.BasicCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.op.ui.FullCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class SVNOperationCheckout
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.checkout";
    private static final String LAST_CO_ROOT_KEY = SVNOperationCheckout.class.getName() + ".lastCoRoot";
    private static final String TIMING_CTX_CO = "checkout";
    private static final String TIMING_CTX_SCAN = "dirScan";
    private Boolean warnReposRoot = null;

    public SVNOperationCheckout() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        SVNRemoteNode remoteNode;
        if (!super.isAvailableImpl(profile)) {
            return false;
        }
        return !SVNUtil.isRepositoryNavigatorView(this.getContext()) || (remoteNode = SVNUtil.getSVNRemoteNode(this.getContext())) == null || remoteNode.getNodeKind() != SVNNodeKind.FILE;
    }

    protected int doitImpl(final VCSProfile profile) throws Exception {
        URL checkOutRoot;
        ValidatedPanel panel = null;
        String checkOutPath = null;
        SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
        String checkOutRootStr = Ide.getDTCache().getString(LAST_CO_ROOT_KEY);
        URL uRL = checkOutRoot = checkOutRootStr != null ? URLFactory.newDirURL((String)checkOutRootStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
        if (remoteNode != null) {
            if (remoteNode instanceof SVNRepositoryNode) {
                this.warnReposRoot = this.warnReposRoot();
                if (!this.warnReposRoot.booleanValue()) {
                    return 1;
                }
            }
            boolean isReposRoot = false;
            String reposAlias = null;
            if (remoteNode instanceof SVNRepositoryNode) {
                isReposRoot = true;
                SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)((SVNRepositoryNode)remoteNode).getData();
                reposAlias = reposInfo.getAlias();
            }
            URL suggestedDestination = SVNUtil.suggestCheckoutDestination(checkOutRoot, remoteNode.getSVNUrl(), isReposRoot, reposAlias);
            panel = new BasicCheckoutPanel((SVNRepositoryInfo)remoteNode.getParentRepository().getData(), remoteNode.getSVNUrl(), suggestedDestination);
            checkOutPath = SVNUrlUtils.getRelativePath((SVNUrl)remoteNode.getParentRepository().getSVNUrl(), (SVNUrl)remoteNode.getSVNUrl());
        } else {
            if (!SVNUtil.ensureRepositoryConnection(this.getContext())) {
                return 1;
            }
            panel = new FullCheckoutPanel(SVNRepositoryManager.getInstance().list(), checkOutRoot, SVNUtil.getIDEClientAdapter());
        }
        final JEWTDialog dialog = this.createDialog(panel, checkOutPath);
        dialog.setOKButtonEnabled(!(panel instanceof FullCheckoutPanel));
        final CheckoutInfo coInfo = panel;
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                URL[] contents;
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                if (coInfo.getRevision() == SVNRevision.INVALID_REVISION) {
                    MessageDialog.error((Component)dialog, (Object)Resource.get("INVALID_REVISION_ERROR_MESSAGE"), (String)Resource.get("INVALID_REVISION_ERROR_TITLE"), null);
                    throw new PropertyVetoException(null, pce);
                }
                URL dest = coInfo.getDestinationURL();
                URL root = URLFileSystem.getParent((URL)dest);
                if (root == null) {
                    root = URLFactory.newDirURL((String)Ide.getWorkDirectory());
                }
                Ide.getDTCache().putString(LAST_CO_ROOT_KEY, URLFileSystem.getPlatformPathName((URL)root));
                if (URLFileSystem.exists((URL)dest) && (contents = URLFileSystem.list((URL)dest)).length > 0 && !SVNOperationCheckout.this.warnNonEmptyDestination((Component)dialog, dest)) {
                    throw new PropertyVetoException(null, pce);
                }
                if (coInfo.getRepositoryInfo() == null) {
                    SVNOperationCheckout.this.warnEmptyRepository();
                    throw new PropertyVetoException(null, pce);
                }
                if (coInfo.getSourceURL() == null) {
                    SVNOperationCheckout.this.warnSourceRepository();
                    throw new PropertyVetoException(null, pce);
                }
                if (coInfo.getSourceURL().equals((Object)coInfo.getRepositoryInfo().getURL())) {
                    if (SVNOperationCheckout.this.warnReposRoot == null) {
                        SVNOperationCheckout.this.warnReposRoot = SVNOperationCheckout.this.warnReposRoot();
                    }
                    if (!SVNOperationCheckout.this.warnReposRoot.booleanValue()) {
                        throw new PropertyVetoException(null, pce);
                    }
                }
                dialog.setOKButtonEnabled(false);
                CheckoutThread coThread = new CheckoutThread(profile, dialog, dialog.getContent(), coInfo);
                coThread.start();
                throw new PropertyVetoException(null, pce);
            }
        });
        ((ValidatedPanel)panel).addListener(new ValidatedPanel.PanelValidationListener(){

            @Override
            public void onReceiveValidationResult(final boolean validationResult) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setOKButtonEnabled(validationResult);
                    }
                });
            }
        });
        if (dialog.runDialog()) {
            this.postInvoke(profile, coInfo);
            return 0;
        }
        dialog.dispose();
        return 1;
    }

    protected void postInvoke(VCSProfile profile, CheckoutInfo coInfo) throws Exception {
        URL dest = coInfo.getDestinationURL();
        this.fireFileStructureChanged(new URL[]{dest});
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    private boolean warnNonEmptyDestination(Component parent, URL dest) {
        return MessageDialog.optionalConfirm((String)(SVNOperationCheckout.class.getName() + ".warnNonEmptyDestination"), (Component)parent, (Object)Resource.format("ACTION_CHECKOUT_NONEMPTY_DEST_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)dest)), (String)Resource.get("ACTION_CHECKOUT_WARNING_TITLE"), (String)"f1_svnconfirmcheckoutintodir_html");
    }

    private boolean warnReposRoot() {
        return MessageDialog.optionalConfirm((String)(SVNOperationCheckout.class.getName() + ".warnRootCheckout"), (Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_CHECKOUT_ROOT_WARNING_MESSAGE"), (String)Resource.get("ACTION_CHECKOUT_WARNING_TITLE"), (String)"f1_svnconfirmcheckoutfromroot_html");
    }

    private void warnEmptyRepository() {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_CHECKOUT_REPOS_WARNING_MESSAGE"), (String)Resource.get("ACTION_CHECKOUT_WARNING_TITLE"), null);
    }

    private void warnSourceRepository() {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_CHECKOUT_SRC_WARNING_MESSAGE"), (String)Resource.get("ACTION_CHECKOUT_ERROR_TITLE"), null);
    }

    private JEWTDialog createDialog(JComponent content, String relativePath) {
        String title = relativePath != null ? Resource.format("ACTION_CHECKOUT_DIALOG_TITLE_URL", relativePath) : Resource.get("ACTION_CHECKOUT_DIALOG_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)content);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic(content, "f1_svncheckoutfromsubversion_html");
        return dialog;
    }

    public final class CheckoutThread
    extends Thread {
        private final JEWTDialog _parentDialog;
        private final Component _parentPanel;
        private final CheckoutInfo _coInfo;
        private final VCSProfile _profile;

        private CheckoutThread(VCSProfile profile, JEWTDialog parentDialog, Component parentPanel, CheckoutInfo coInfo) {
            super("svn-checkout-thread");
            this._profile = profile;
            this._parentDialog = parentDialog;
            this._parentPanel = parentPanel;
            this._coInfo = coInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            final WaitCursor wc = new WaitCursor(this._parentPanel);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.show();
                }
            });
            try {
                VCSDirectoryWatcher watcher = new VCSDirectoryWatcher(this._coInfo.getDestinationURL());
                this.executeCheckoutWithProgress(this._parentDialog, this._coInfo, watcher);
                this.executeAutoLockWithProgress(this._parentDialog, this._coInfo, watcher);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckoutThread.this._parentDialog.setVisible(false);
                        CheckoutThread.this._parentDialog.dispose();
                    }
                });
                final NewFilesHandler nfh = new NewFilesHandler(watcher, "oracle.jdeveloper.subversion");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Context context = SVNOperationCheckout.this.getContext();
                            String name = CheckoutThread.this.getName(context);
                            nfh.setDialogHintText(Resource.get("PROJECT_TITLE_DIALOG"));
                            if (VCSProcessUtils.productHandleNewFiles()) {
                                nfh.handleNewFiles(context, name);
                            }
                        }
                        catch (Exception e) {
                            SVNOperationCheckout.this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException(e));
                        }
                    }
                });
            }
            catch (IOException ioe) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).severe(ioe.getMessage());
                MessageDialog.error((Component)this._parentDialog, (Object)Resource.format("ACTION_CHECKOUT_ERROR_MESSAGE_DEST", ioe.getMessage()), (String)Resource.get("ACTION_CHECKOUT_ERROR_TITLE"), null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckoutThread.this._parentDialog.setOKButtonEnabled(true);
                    }
                });
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ WaitCursor val$wc;
                    {
                        this.val$wc = waitCursor;
                    }

                    @Override
                    public void run() {
                        this.val$wc.hide();
                    }
                });
            }
            catch (SVNClientException ex) {
                SVNOperationCheckout.this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)ex)));
                {
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        private String getName(Context context) {
            Element elm = context.getElement();
            String name = "";
            if (elm instanceof Locatable) {
                URL url = ((Locatable)elm).getURL();
                if (elm instanceof SVNRemoteFolder) {
                    String[] svnLPath = ((SVNRemoteFolder)elm).getSVNUrl().getPathSegments();
                    String path = url.getPath();
                    if (svnLPath.length > 0 && path.length() > svnLPath[0].length() + 2) {
                        name = path.substring(svnLPath[0].length() + 2);
                    }
                }
                if (name == null) {
                    name = URLFileSystem.getName((URL)url);
                }
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCheckoutWithProgress(JEWTDialog dialog, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            IndeterminateProgressMonitor progressMon = new IndeterminateProgressMonitor((Component)dialog, Resource.get("ACTION_CHECKOUT_PROGRESS_TITLE"), (Object)Resource.get("ACTION_CHECKOUT_PROGRESS_MESSAGE"), null);
            progressMon.setMillisToPopup(0);
            progressMon.setCloseOnFinish(true);
            progressMon.setCancellable(false);
            progressMon.start();
            try {
                this.executeCheckout(progressMon, coInfo, watcher);
            }
            finally {
                progressMon.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCheckout(IndeterminateProgressMonitor progress, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            SVNUrl sourceUrl = coInfo.getSourceURL();
            URL destUrl = coInfo.getDestinationURL();
            String coContext = "checkout.{" + sourceUrl.toString() + "}";
            String scanContext = "dirScan.{" + URLFileSystem.getPlatformPathName((URL)destUrl) + "}";
            TimingUtil.beginTiming(this.getClass(), coContext);
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            URL destination = coInfo.getDestinationURL();
            if (!URLFileSystem.mkdirs((URL)destination)) {
                throw new IOException(URLFileSystem.getPlatformPathName((URL)destination));
            }
            TimingUtil.beginTiming(this.getClass(), scanContext);
            watcher.beginWatch();
            TimingUtil.endTiming(this.getClass(), scanContext);
            try {
                SVNOperationLogger.getInstance().beginOperation(svnClient, coInfo.getRepositoryInfo(), progress);
                svnClient.checkout(sourceUrl, SVNUtil.toFile(coInfo.getDestinationURL()), coInfo.getRevision(), coInfo.getDepth(), false, false);
                TimingUtil.beginTiming(this.getClass(), scanContext);
                watcher.endWatch();
                TimingUtil.endTiming(this.getClass(), scanContext);
                SVNOperationLogger.getInstance().successFinish(Resource.get("OP_CHECKOUT"));
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                TimingUtil.endTiming(this.getClass(), coContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAutoLockWithProgress(JEWTDialog dialog, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            boolean autoLock = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getAutoLock();
            if (!autoLock) {
                return;
            }
            IndeterminateProgressMonitor progressMon = new IndeterminateProgressMonitor((Component)dialog, Resource.get("ACTION_AUTOLOCK_PROGRESS_TITLE"), (Object)Resource.get("ACTION_AUTOLOCK_PROGRESS_MESSAGE"), null);
            progressMon.setMillisToPopup(500);
            progressMon.setCloseOnFinish(true);
            progressMon.setCancellable(false);
            progressMon.start();
            try {
                ArrayList newURLs = new ArrayList();
                newURLs.addAll(watcher.getNewWorkspaces());
                newURLs.addAll(watcher.getNewProjects());
                newURLs.addAll(watcher.getNewRegularURLs());
                File[] newFiles = SVNUtil.toFiles(newURLs.toArray(new URL[0]));
                ArrayList<File> needsLockFiles = new ArrayList<File>();
                ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                for (File file : newFiles) {
                    ISVNProperty[] properties;
                    for (ISVNProperty property : properties = svnClient.getProperties(file)) {
                        if (!property.getName().equals("svn:needs-lock")) continue;
                        needsLockFiles.add(file);
                    }
                }
                if (needsLockFiles.isEmpty()) {
                    return;
                }
                svnClient.lock(needsLockFiles.toArray(new File[0]), Resource.get("ACTION_AUTOLOCK_COMMENT_MESSAGE"), false);
                ArrayList<File> unlockedFiles = new ArrayList<File>();
                for (File file : needsLockFiles) {
                    ISVNStatus status = svnClient.getSingleStatus(file);
                    if (status.getLockOwner() != null) continue;
                    unlockedFiles.add(file);
                }
                if (unlockedFiles.isEmpty()) {
                    return;
                }
                progressMon.finish();
                SelectFilesConfiguration selectFilesConfiguration = new SelectFilesConfiguration((Component)dialog, Resource.get("ACTION_AUTOLOCK_DIALOG_FAILED_TITLE"), Resource.format("ACTION_AUTOLOCK_DIALOG_FAILED_SINGLE_MESSAGE", unlockedFiles.toArray(new File[0])[0].getCanonicalPath()), Resource.get("ACTION_AUTOLOCK_DIALOG_FAILED_MULTI_MESSAGE"), VCSComponents.createCheckBoxListModel((Object[])unlockedFiles.toArray(new File[0]), (boolean)false), false, -1, "f1_svnfailedautomaticlock_html");
                SelectFilesPanel.showDialog((SelectFilesConfiguration)selectFilesConfiguration);
            }
            finally {
                progressMon.finish();
            }
        }
    }
}

