/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class DotDensityStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 8273185276122465955L;
    protected static int MAX_DOTS = 1500;
    SizeDefinition2D dotSize = new SizeDefinition2D(6.0, 6.0, null);
    String markerStyleName = null;

    public DotDensityStyleModel() {
        this.type = 9;
    }

    @Override
    public Object clone() {
        DotDensityStyleModel dotDensityStyleModel = (DotDensityStyleModel)super.clone();
        dotDensityStyleModel.setDotSize(this.dotSize);
        return dotDensityStyleModel;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public void setDotSize(SizeDefinition2D sizeDefinition2D) {
        this.dotSize = new SizeDefinition2D(6.0, 6.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.dotSize.setSize(sizeDefinition2D.getWidth(), sizeDefinition2D.getHeight());
        this.dotSize.setUnit(sizeDefinition2D.getUnit());
    }

    public SizeDefinition2D getDotSize() {
        return this.dotSize;
    }

    @Override
    public String toXMLString() {
        String string = StyleUtils.getUSLocaleFormat(this.dotSize.getWidth());
        string = StyleUtils.cleanDecimalZeros(string, 1);
        String string2 = StyleUtils.getUSLocaleFormat(this.dotSize.getHeight());
        string2 = StyleUtils.cleanDecimalZeros(string2, 1);
        String string3 = "";
        if (this.dotSize.getUnit() != null && !this.dotSize.getUnit().equalsIgnoreCase("px")) {
            string3 = this.dotSize.getUnit();
        }
        if (this.dotSize.isPixelUnit()) {
            string = String.valueOf((int)this.dotSize.getWidth());
            string2 = String.valueOf((int)this.dotSize.getHeight());
        }
        String string4 = this.markerStyleName == null ? "" : "MarkerStyle=\"" + XMLUtil.replaceXMLEntities(this.markerStyleName) + "\" ";
        String string5 = "<?xml version=\"1.0\" ?>\n";
        string5 = string5 + "<AdvancedStyle>\n    <DotDensityStyle " + string4 + "DotWidth=\"" + string + string3 + "\" DotHeight=\"" + string2 + string3 + "\" />\n" + "</AdvancedStyle>\n";
        return string5;
    }

    public static void setMaxDots(int n) {
        MAX_DOTS = n;
    }

    public static int getMaxDots() {
        return MAX_DOTS;
    }

    public void setDotWidth(int n) {
        this.dotSize.setWidth(n);
    }

    public void setDotWidth(double d) {
        this.dotSize.setWidth(d);
    }

    public int getDotWidth() {
        return (int)this.dotSize.getWidth();
    }

    public double getDoubleDotWidth() {
        return this.dotSize.getWidth();
    }

    public void setDotHeight(int n) {
        this.dotSize.setHeight(n);
    }

    public void setDotHeight(double d) {
        this.dotSize.setHeight(d);
    }

    public int getDotHeight() {
        return (int)this.dotSize.getHeight();
    }

    public double getDoubleDotHeight() {
        return this.dotSize.getHeight();
    }

    public void setDotSize(int n, int n2) {
        this.dotSize.setSize(n, n2);
    }

    public void setDotSize(double d, double d2) {
        this.dotSize.setSize(d, d2);
    }

    public String getDotUnit() {
        return this.dotSize.getUnit();
    }

    public void setDotUnit(String string) {
        this.dotSize.setUnit(string);
    }

    public void setMarkerStyleName(String string) {
        this.markerStyleName = string;
    }

    public String getMarkerStyleName() {
        return this.markerStyleName;
    }

    @Override
    public String[] getStyleDependency() {
        String[] stringArray = null;
        if (this.markerStyleName != null) {
            stringArray = new String[]{this.markerStyleName};
        }
        return stringArray;
    }
}

