/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.db.migration.ConnectionMigrator;

public class StorageWrapper {
    private StorageManager mStorageManager;
    private final URL mURL;
    private final ReferenceWorker mWorker;

    public static StorageWrapper getDefaultWrapper() {
        return DefaultHolder.INSTANCE;
    }

    public static StorageWrapper createSystemWrapper(URL uRL) {
        return StorageWrapper.createWrapper(uRL, StorageWrapper.getSystemKey());
    }

    public static StorageWrapper createWrapper(URL uRL, String string) {
        return new StorageWrapper(uRL, StorageWrapper.createDefaultWorker(string));
    }

    private static String generateNewKey() {
        return UUID.randomUUID().toString();
    }

    static String getSystemKey() {
        String string;
        if (!Ide.isRunning()) {
            String string2 = System.getProperty("db.junit.system.id");
            string = string2 == null ? null : string2;
        } else {
            HashStructure hashStructure = Preferences.getPreferences().getProperties();
            string = hashStructure.getString("db.system.id");
            if (string == null) {
                string = StorageWrapper.generateNewKey();
                hashStructure.putString("db.system.id", string);
            }
        }
        return string;
    }

    static ReferenceWorker createDefaultWorker(String string) {
        ReferenceWorker referenceWorker = ModelUtil.hasLength((String)string) ? ReferenceWorker.createDefaultWorker((TextSecret)Secrets.instance().of(string.toCharArray(), true)) : ReferenceWorker.createNullWorker();
        return referenceWorker;
    }

    private StorageWrapper(URL uRL, ReferenceWorker referenceWorker) {
        this.mURL = uRL;
        this.mWorker = referenceWorker;
    }

    public ReferenceWorker getReferenceWorker() {
        return this.mWorker;
    }

    public StorageManager getStorageManager() {
        if (this.mStorageManager == null && this.mURL != null) {
            try {
                this.mStorageManager = StorageManager.builder().location((Location)new InternalLocation(this.mURL)).autosave(true).addEnvValue(ReferenceWorker.KEY, (Object)this.mWorker).build();
            }
            catch (StorageException storageException) {
                Logger.severe(StorageWrapper.class, (Throwable)storageException);
                this.mStorageManager = StorageManager.builder().addEnvValue(ReferenceWorker.KEY, (Object)this.mWorker).build();
            }
        }
        return this.mStorageManager;
    }

    public void saveDatabaseStorage() throws StorageException {
        if (this.mStorageManager != null) {
            this.mStorageManager.save();
        }
    }

    public <T> Storage<T> getStorage(String string) {
        StorageManager storageManager = this.getStorageManager();
        return storageManager != null ? storageManager.getStorage(string) : null;
    }

    public Storage<DatabaseProvider> getDatabaseStorage() {
        return this.getStorage("jdbc");
    }

    private static final class DefaultHolder {
        private static final StorageWrapper INSTANCE;

        private DefaultHolder() {
        }

        static {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            URL uRL = extensionRegistry.getSystemDirectory("oracle.jdeveloper.db.connection");
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)"connections.json");
            if (!URLFileSystem.exists((URL)uRL)) {
                URLFileSystem.mkdirs((URL)uRL2);
            }
            INSTANCE = StorageWrapper.createSystemWrapper(uRL2);
            ConnectionMigrator.finishMigration(INSTANCE);
        }
    }

    private static final class InternalLocation
    implements Location {
        private final URL mURL;

        private InternalLocation(URL uRL) {
            this.mURL = URLFactory.encodeURL((URL)uRL);
        }

        public InputStream getInputStream() throws IOException {
            return URLFileSystem.openInputStream((URL)this.mURL);
        }

        public OutputStream getOutputStream() throws IOException {
            return URLFileSystem.openOutputStream((URL)this.mURL);
        }

        public URI getRelativeRoot() {
            URI uRI = null;
            try {
                URI uRI2 = this.mURL.toURI();
                String string = uRI2.getPath();
                if (string != null) {
                    uRI = uRI2.resolve(string.endsWith("/") ? ".." : ".");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            return uRI;
        }

        public boolean exists() {
            return URLFileSystem.exists((URL)this.mURL);
        }
    }
}

