/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.toolbar;

import ilog.views.IlvManagerView;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.view.ViewUtil;
import oracle.diagram.res.ActionResource;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public class ZoomComboBox
extends JComboBox {
    private static final String CUSTOM_PERCENT_FORMAT;
    private IlvManagerView _mgrView;
    private String _customZoom;
    private final TransformerListener _txl = new TransformerListener(){

        public void transformerChanged(TransformerChangedEvent tce) {
            ZoomComboBox.this.updateZoomDisplay();
        }
    };
    private int _ignore;

    public ZoomComboBox(View view, IlvManagerView mgrView) {
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this._mgrView = mgrView;
        this.setEditable(false);
        this.setRenderer(new MyCellRenderer());
        this.setRequestFocusEnabled(false);
        this.setPrototypeDisplayValue(ZoomComboBox.formatPercentageString(99999));
        this.addItem(new ActionZoomItem(Actions.ZOOM_400_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_200_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_150_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_125_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_100_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_75_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_50_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_40_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_25_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_15_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_10_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_5_PERCENT.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_SELECTED.newLocalAction(view)));
        this.addItem(new ActionZoomItem(Actions.ZOOM_FIT_TO_WINDOW.newLocalAction(view)));
        this.setMaximumRowCount(this.getItemCount());
        Dimension preferred = this.getPreferredSize();
        this.setMaximumSize(preferred);
        this.setMinimumSize(preferred);
        this.updateZoomDisplay();
        this._mgrView.addTransformerListener(this._txl);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ZoomComboBox.this._ignore > 0) {
                    return;
                }
                ActionZoomItem item = (ActionZoomItem)ZoomComboBox.this.getSelectedItem();
                try {
                    ZoomComboBox.this.performZoomAction(item);
                    ZoomComboBox.this.hidePopup();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void dispose() {
        if (this._mgrView != null) {
            this._mgrView.removeTransformerListener(this._txl);
            this._mgrView = null;
        }
    }

    protected void performZoomAction(ActionZoomItem ai) throws Exception {
        ai.getAction().performAction();
    }

    protected static String formatPercentageString(int percentage) {
        return MessageFormat.format(CUSTOM_PERCENT_FORMAT, percentage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZoomDisplay() {
        String lastCustomValue = this._customZoom;
        this._customZoom = null;
        try {
            ++this._ignore;
            IlvManagerView view = this.getView();
            if (view != null) {
                int scale = ViewUtil.getCurrentPercentageZoom(view);
                for (int i = 0; i < ViewUtil.ZOOM_PERCENTAGES.length; ++i) {
                    if (scale != ViewUtil.ZOOM_PERCENTAGES[i]) continue;
                    this.setSelectedIndex(i);
                    return;
                }
                this._customZoom = ZoomComboBox.formatPercentageString(scale);
                if (this.getSelectedIndex() != -1) {
                    this.setSelectedIndex(-1);
                } else if (!this._customZoom.equals(lastCustomValue)) {
                    this.repaint();
                }
            }
        }
        finally {
            --this._ignore;
        }
    }

    protected final IlvManagerView getView() {
        return this._mgrView;
    }

    static {
        ResourceBundle rb = ActionResource.getBundle();
        CUSTOM_PERCENT_FORMAT = rb.getString("ZoomCustomPercentFormat.text");
    }

    private class MyCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                value = ZoomComboBox.this._customZoom;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class ActionZoomItem {
        private final IdeAction _action;

        public ActionZoomItem(IdeAction action) {
            this._action = action;
        }

        public String toString() {
            return (String)this._action.getValue("Name");
        }

        public IdeAction getAction() {
            return this._action;
        }
    }
}

