/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.framework.interaction.InPlaceEditContext;
import oracle.diagram.framework.interaction.InPlaceEditor;
import oracle.diagram.framework.interaction.LabelInPlaceEditor;
import oracle.diagram.framework.readonly.ReadOnlyUtil;

public class EditInteractor
extends IlvManagerViewInteractor {
    private boolean _reinvokeEnabled = true;
    private final InPlaceEditContext _initialContext;
    private final InteractorListener _interactorListener = new MyInteractorListener();
    private final MyMouseListener _mouseListener = new MyMouseListener();
    private InPlaceEditContext _reinvokeContext = null;
    private InPlaceEditor _inplaceEditor = null;
    private boolean _editionAllowed = true;
    private boolean _creationAllowed = true;
    private boolean _grapherMode = false;
    private Status _exitStatus = Status.COMMIT;
    private LinkedList<MouseEvent> _mouseEventCache = new LinkedList();

    public EditInteractor(InPlaceEditContext initialContext) {
        this._initialContext = initialContext;
        this.setGrapherMode(true);
    }

    public final DiagramContext getDiagramContext() {
        return DiagramContext.getDiagramContext(this.getManagerView());
    }

    public boolean isReinvokeEnabled() {
        return this._reinvokeEnabled;
    }

    public final void setExitStatus(Status status) {
        this._exitStatus = status;
    }

    public final Status getExitStatus() {
        return this._exitStatus;
    }

    protected void attach(final IlvManagerView view) {
        super.attach(view);
        IlvGraphic mainObject = this._initialContext.getMainObject();
        IlvGraphic subObject = this._initialContext.getSubObject();
        this.setExitStatus(Status.COMMIT);
        if (this._inplaceEditor != null) {
            SwingUtilities.invokeLater(new AbortInteractorListener());
            this.setExitStatus(Status.ABORT);
            return;
        }
        this._inplaceEditor = this.createInplaceEditor(this._initialContext);
        if (this._inplaceEditor != null && ReadOnlyUtil.checkWritableEdit(this.getDiagramContext(), mainObject, subObject)) {
            view.addInteractorListener(this._interactorListener);
            if (this._mouseEventCache == null) {
                this._mouseEventCache = new LinkedList();
            }
            this._mouseEventCache.clear();
            this._inplaceEditor.addMouseListener(this._mouseListener);
            if (!(view.getManager() instanceof IlvGrapher)) {
                this.setGrapherMode(false);
            }
            this._reinvokeContext = null;
            final InPlaceEditor editor = this._inplaceEditor;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() != null) {
                        if (view.getInteractor() == EditInteractor.this && EditInteractor.this.getExitStatus() != Status.ABORT) {
                            view.pushInteractor((IlvManagerViewInteractor)editor);
                            editor.edit();
                        } else {
                            SwingUtilities.invokeLater(new AbortInteractorListener());
                            EditInteractor.this.setExitStatus(Status.ABORT);
                        }
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new AbortInteractorListener());
            this.setExitStatus(Status.ABORT);
        }
    }

    protected void detach() {
        this.getManagerView().removeInteractorListener(this._interactorListener);
        this.cleanup();
        super.detach();
    }

    public void setReinvokeContext(InPlaceEditContext context) {
        this._reinvokeContext = context;
    }

    public void setReinvokeEnabled(boolean enable) {
        this._reinvokeEnabled = enable;
    }

    public final boolean isEditionAllowed() {
        return this._editionAllowed;
    }

    public final void setEditionAllowed(boolean allowed) {
        this._editionAllowed = allowed;
        if (!allowed) {
            this._creationAllowed = true;
        }
    }

    public final boolean isCreationAllowed() {
        return this._creationAllowed;
    }

    public final void setCreationAllowed(boolean allowed) {
        this._creationAllowed = allowed;
        if (!allowed) {
            this._editionAllowed = true;
        }
    }

    protected void cleanup() {
        this._mouseEventCache = null;
    }

    public boolean isGrapherMode() {
        return this._grapherMode;
    }

    public void setGrapherMode(boolean value) {
        this._grapherMode = value;
    }

    protected InPlaceEditor createInplaceEditor(InPlaceEditContext context) {
        return new LabelInPlaceEditor(this, context);
    }

    protected void reinvoke(InPlaceEditContext context) {
        this._inplaceEditor = this.createInplaceEditor(context);
        final IlvManagerView view = this.getManagerView();
        final InPlaceEditor editor = this._inplaceEditor;
        this._mouseEventCache.clear();
        this._inplaceEditor.addMouseListener(this._mouseListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                view.pushInteractor((IlvManagerViewInteractor)editor);
                editor.edit();
            }
        });
    }

    private final class MyInteractorListener
    implements InteractorListener {
        private boolean _isEditorDetached = false;

        private MyInteractorListener() {
        }

        public void interactorChanged(InteractorChangedEvent event) {
            if (event.getOldValue() == EditInteractor.this._inplaceEditor) {
                this._isEditorDetached = true;
            }
            if (this._isEditorDetached && event.getManagerView().getInteractor() == EditInteractor.this) {
                EditInteractor.this._inplaceEditor.removeMouseListener(EditInteractor.this._mouseListener);
                EditInteractor.this._inplaceEditor = null;
                InPlaceEditContext context = EditInteractor.this._reinvokeContext;
                EditInteractor.this._reinvokeContext = null;
                if (context != null && EditInteractor.this.isReinvokeEnabled()) {
                    EditInteractor.this.reinvoke(context);
                } else {
                    IlvManagerView view = EditInteractor.this.getManagerView();
                    ArrayList<MouseEvent> events = null;
                    if (EditInteractor.this._mouseEventCache != null) {
                        events = new ArrayList<MouseEvent>(EditInteractor.this._mouseEventCache);
                    }
                    view.requestFocus();
                    view.popInteractor();
                    IlvManagerViewInteractor i = view.getInteractor();
                    if (events != null && i instanceof CoreSelectInteractor) {
                        ((CoreSelectInteractor)i).processMouseEvents(events);
                    }
                }
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.cacheEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.cacheEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.cacheEvent(e);
        }

        private void cacheEvent(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                EditInteractor.this._mouseEventCache.add(e);
            }
        }
    }

    public static enum Status {
        COMMIT,
        ABORT;

    }

    private final class AbortInteractorListener
    implements InteractorListener,
    Runnable {
        private AbortInteractorListener() {
        }

        public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
            IlvManagerView view = interactorChangedEvent.getManagerView();
            if (view.getInteractor() == EditInteractor.this) {
                view.popInteractor();
                view.removeInteractorListener((InteractorListener)this);
            }
        }

        @Override
        public void run() {
            IlvManagerView view = EditInteractor.this.getManagerView();
            if (view != null) {
                if (view.getInteractor() == EditInteractor.this) {
                    view.popInteractor();
                } else {
                    view.addInteractorListener((InteractorListener)this);
                }
            }
        }
    }
}

